/*
 * Decompiled with CFR 0.152.
 */
package strawberry.init;

import com.sun.faces.application.ConfigNavigationCase;
import com.sun.faces.config.beans.ComponentBean;
import com.sun.faces.config.beans.ConverterBean;
import com.sun.faces.config.beans.FacesConfigBean;
import com.sun.faces.config.beans.NavigationCaseBean;
import com.sun.faces.config.beans.NavigationRuleBean;
import com.sun.faces.config.beans.RenderKitBean;
import com.sun.faces.config.beans.RendererBean;
import com.sun.faces.config.beans.ValidatorBean;
import com.sun.faces.util.Util;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.ServletContext;
import strawberry.ResourceConfig;
import strawberry.application.I18n;
import strawberry.application.NavigationRuleAware;
import strawberry.config.ConfigureListener;
import strawberry.context.FacesContextEL;
import strawberry.context.ResourceConfigWrapper;
import strawberry.el.GlobalELContext;
import strawberry.init.ApplicationCreator;
import strawberry.init.ApplicationNav;
import strawberry.init.FacesContextInitializer;
import strawberry.xmlconfig.ConfigServletContext;
import strawberry.xmlconfig.ConfigureListenerOrig;

public class FacesContextInitializer1
implements FacesContextInitializer {
    protected static final Logger log = Logger.getLogger("strawberry.init.app");
    protected static final Logger initLog = Logger.getLogger("strawberry.init");
    protected static final Logger elLog = Logger.getLogger("strawberry.el.common");
    RenderKitFactory rkFactory = null;
    Application application = null;
    ApplicationCreator appCreator = new ApplicationCreator();
    ApplicationNav appliNav = new ApplicationNav();
    String lifecycleFactoryClassName = "strawberry.lifecycle.LifecycleFactoryImpl";
    private static final String RENDER_KIT_IMPL_REQ = "com.sun.faces.renderKitImplForRequest";

    public LifecycleFactory createLifecycleFactory() {
        LifecycleFactory lifecycleFactory = null;
        try {
            Object wk = Class.forName(this.lifecycleFactoryClassName).newInstance();
            lifecycleFactory = (LifecycleFactory)wk;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return lifecycleFactory;
    }

    public Application getApplication() {
        return this.application;
    }

    public void processXmls(ExternalContext ec, ResourceConfig rc) {
        int i;
        ResourceConfigWrapper rr = new ResourceConfigWrapper(rc);
        ServletContext sc = (ServletContext)ec.getContext();
        ConfigureListener cl = new ConfigureListener();
        initLog.fine("96) digester\u3092\u4f7f\u3063\u3066 xml\u3092\u51e6\u7406\u3057\u307e\u3059 ");
        FacesConfigBean fcb = new FacesConfigBean();
        ConfigureListenerOrig orig = new ConfigureListenerOrig();
        ConfigServletContext csc = new ConfigServletContext(sc);
        csc.addInitParameter("com.sun.faces.validateXml", "true");
        csc.addInitParameter("javax.faces.CONFIG_FILES", "faces-config.xml");
        orig.step1to5(csc, fcb);
        if (initLog.isLoggable(Level.FINE)) {
            ComponentBean[] bean1 = fcb.getComponents();
            for (i = 0; i < bean1.length; ++i) {
                initLog.fine("70) getComponents " + i + " = " + bean1[i].getComponentClass());
            }
        }
        cl.setManagedBeanFactoryClass("ManagedBeanFactoryApp");
        try {
            cl.configure(sc, fcb);
        }
        catch (Exception ex) {
            initLog.log(Level.WARNING, "Application\u521d\u671f\u5316", ex);
        }
        if (fcb.getFactory() == null) {
            initLog.config("95)  fcb.getFactory() = null ");
        } else {
            List lifecycles = fcb.getFactory().getLifecycleFactories();
            if (lifecycles == null || lifecycles.size() == 0) {
                initLog.config("LifecycleFactories.size() = 0 ");
            }
            for (i = 0; i < lifecycles.size(); ++i) {
                String lifecycle = (String)lifecycles.get(i);
                initLog.config("lifecycle(" + i + ") = " + lifecycle);
                this.lifecycleFactoryClassName = lifecycle;
            }
        }
        if (fcb.getApplication() != null) {
            String[] nhs = fcb.getApplication().getNavigationHandlers();
            if (nhs == null || nhs.length == 0) {
                initLog.info("NavigationHandlers.size() = 0 ");
            }
            for (i = 0; i < nhs.length; ++i) {
                initLog.log(Level.CONFIG, "getNavigationHandlers(" + i + ") = '" + nhs[i] + "' ----------------------**");
                this.appCreator.setNavigationHandlerClass(nhs[i]);
            }
        }
        initLog.fine("Application\u521d\u671f\u5316");
        this.application = this.appCreator.initializeApplication(ec, rr, fcb);
        try {
            this.configureFromBean(this.application, fcb);
        }
        catch (Exception ex2) {
            initLog.log(Level.WARNING, "Application\u521d\u671f\u5316", ex2);
        }
        this.rkFactory = this.appCreator.initializeRenderKitFactory(ec, rr);
        initLog.fine("44) RenderKitFactory\u521d\u671f\u5316 = " + this.rkFactory);
        try {
            this.configure(fcb.getRenderKits(), this.rkFactory, (Object)rc);
        }
        catch (Exception ex3) {
            initLog.log(Level.WARNING, "Application\u521d\u671f\u5316", ex3);
        }
    }

    public void configureFromBean(Application application, FacesConfigBean facesConfig) throws Exception {
        NavigationHandler navHan;
        this.configure(application, facesConfig.getComponents());
        this.configure(application, facesConfig.getConvertersByClass());
        this.configure(application, facesConfig.getConvertersById());
        this.configure(facesConfig.getNavigationRules());
        Map caseListMap = this.appliNav.getNavigationCaseListMappings();
        TreeSet wildCardSet = this.appliNav.getNavigationWildCardList();
        if (initLog.isLoggable(Level.FINE)) {
            log.fine("176) caseListMap:" + caseListMap);
            log.fine("177) wildCardSet:" + wildCardSet);
        }
        if ((navHan = application.getNavigationHandler()) instanceof NavigationRuleAware) {
            NavigationRuleAware ruleAware = (NavigationRuleAware)navHan;
            ruleAware.setRule(caseListMap, wildCardSet);
        }
        this.configure(application, facesConfig.getValidators());
    }

    private void configure(NavigationRuleBean[] config) {
        if (config == null) {
            return;
        }
        if (null == this.appliNav) {
            return;
        }
        for (int i = 0; i < config.length; ++i) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("addNavigationRule(" + config[i].getFromViewId() + ')');
            }
            NavigationCaseBean[] ncb = config[i].getNavigationCases();
            for (int j = 0; j < ncb.length; ++j) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("addNavigationCase(" + ncb[j].getFromAction() + ',' + ncb[j].getFromOutcome() + ',' + ncb[j].isRedirect() + ',' + ncb[j].getToViewId() + ')');
                }
                ConfigNavigationCase cnc = new ConfigNavigationCase();
                if (config[i].getFromViewId() == null) {
                    cnc.setFromViewId("*");
                } else {
                    cnc.setFromViewId(config[i].getFromViewId());
                }
                cnc.setFromAction(ncb[j].getFromAction());
                String fromAction = ncb[j].getFromAction();
                if (fromAction == null) {
                    fromAction = "-";
                }
                cnc.setFromOutcome(ncb[j].getFromOutcome());
                String fromOutcome = ncb[j].getFromOutcome();
                if (fromOutcome == null) {
                    fromOutcome = "-";
                }
                cnc.setToViewId(ncb[j].getToViewId());
                String toViewId = ncb[j].getToViewId();
                if (toViewId == null) {
                    toViewId = "-";
                }
                cnc.setKey(cnc.getFromViewId() + fromAction + fromOutcome);
                if (ncb[j].isRedirect()) {
                    cnc.setRedirect("true");
                } else {
                    cnc.setRedirect(null);
                }
                this.appliNav.addNavigationCase(cnc);
            }
        }
    }

    private void configure(Application application, ValidatorBean[] config) throws Exception {
        if (config == null) {
            return;
        }
        for (int i = 0; i < config.length; ++i) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("addValidator(" + config[i].getValidatorId() + ',' + config[i].getValidatorClass() + ')');
            }
            application.addValidator(config[i].getValidatorId(), config[i].getValidatorClass());
        }
    }

    public void configure(Application application, ComponentBean[] config) throws Exception {
        if (config == null) {
            return;
        }
        for (int i = 0; i < config.length; ++i) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("75) addComponent(" + config[i].getComponentType() + ',' + config[i].getComponentClass() + ')');
            }
            application.addComponent(config[i].getComponentType(), config[i].getComponentClass());
        }
    }

    public void configure(Application application, ConverterBean[] config) throws Exception {
        int i = 0;
        int len = 0;
        if (config == null) {
            return;
        }
        len = config.length;
        for (i = 0; i < len; ++i) {
            if (config[i].getConverterId() != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("112) addConverterById(" + config[i].getConverterId() + ',' + config[i].getConverterClass() + ')');
                }
                application.addConverter(config[i].getConverterId(), config[i].getConverterClass());
                continue;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("120) addConverterByClass(" + config[i].getConverterForClass() + ',' + config[i].getConverterClass() + ')');
            }
            Class<?> clazz = Util.getCurrentLoader(this).loadClass(config[i].getConverterForClass());
            application.addConverter(clazz, config[i].getConverterClass());
        }
    }

    public void configure(RenderKitBean[] config, RenderKitFactory rkFactory, Object fallback) throws Exception {
        if (config == null) {
            return;
        }
        for (int i = 0; i < config.length; ++i) {
            RenderKit rk;
            if (log.isLoggable(Level.FINE)) {
                log.fine("90) i = " + i);
            }
            if ((rk = rkFactory.getRenderKit(null, config[i].getRenderKitId())) == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("createRenderKit(" + config[i].getRenderKitId() + ',' + config[i].getRenderKitClass() + ')');
                }
                if (config[i].getRenderKitClass() == null) {
                    throw new IllegalArgumentException("No renderKitClass for renderKit " + config[i].getRenderKitId());
                }
                rk = (RenderKit)Util.loadClass(config[i].getRenderKitClass(), this).newInstance();
                log.fine("renderKit\u3092\u65b0\u3057\u304f\u4f5c\u6210\u3057\u767b\u9332\u3057\u307e\u3059" + config[i].getRenderKitId() + "," + rk);
                rkFactory.addRenderKit(config[i].getRenderKitId(), rk);
            } else if (log.isLoggable(Level.FINE)) {
                log.fine("75) getRenderKit(" + config[i].getRenderKitId() + ')');
            }
            this.configure(config[i].getRenderers(), rk, fallback);
        }
    }

    public void configure(RendererBean[] config, RenderKit rk, Object fallback) throws Exception {
        if (config == null) {
            return;
        }
        for (int i = 0; i < config.length; ++i) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("100) addRenderer(" + config[i].getComponentFamily() + ',' + config[i].getRendererType() + ',' + config[i].getRendererClass() + ')');
                log.fine("105) fallback = " + fallback);
            }
            Renderer r = (Renderer)Util.loadClass(config[i].getRendererClass(), fallback).newInstance();
            rk.addRenderer(config[i].getComponentFamily(), config[i].getRendererType(), r);
        }
    }

    public FacesContext createFacesContext(ExternalContext ec, ResourceConfig rc) throws FacesException {
        ResourceConfigWrapper rr = new ResourceConfigWrapper(rc);
        FacesContextEL context = new FacesContextEL(ec, null, null);
        if (this.application == null) {
            initLog.severe("369) Application \u304c\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (this.rkFactory == null) {
            initLog.severe("374) RenderKitFactory \u304c\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        Map requestMap = context.getExternalContext().getRequestMap();
        requestMap.put(RENDER_KIT_IMPL_REQ, this.rkFactory);
        context.setApplication(this.application);
        context.setRenderKitFactory(this.rkFactory);
        GlobalELContext elc = new GlobalELContext(context);
        if (elLog.isLoggable(Level.FINE)) {
            elLog.info("91) " + I18n.getLogMessage("strawberry.FacesContextSupportImpl.CREATE_ELCONTEXT"));
        }
        context.setELContext(elc);
        return context;
    }
}

