/*
 * Decompiled with CFR 0.152.
 */
package strawberry.facelet;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.tag.CompositeFaceletHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import com.sun.facelets.tag.jsf.core.AttributeHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import strawberry.facelet.ImportHandler;
import strawberry.facelet.ServerSideScriptComponent;

public final class ServerSideScriptHandler
extends TagHandler {
    protected static final Logger log = Logger.getLogger("strawberry.script");
    private TagAttribute phase = this.getRequiredAttribute("phase");
    private TagAttribute method = this.getAttribute("method");

    public ServerSideScriptHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        String oMethod = this.method.getValue(ctx);
        String oPhase = this.phase.getValue(ctx);
        ServerSideScriptComponent comp = new ServerSideScriptComponent();
        String script = "";
        Iterator it = this.findAll();
        while (it.hasNext()) {
            Object obj = it.next();
            if (log.isLoggable(Level.FINE)) {
                log.fine("56) obj = " + obj.getClass().getName());
            }
            if (obj instanceof ImportHandler) {
                ImportHandler handler = (ImportHandler)obj;
                handler.apply(ctx, (UIComponent)comp);
                continue;
            }
            if (obj instanceof AttributeHandler) {
                log.info("skip");
                continue;
            }
            script = script + obj.toString();
        }
        script = this.removeCdata(script);
        comp.setScript(script);
        if (oMethod != null) {
            comp.setMethod(oMethod);
        }
        if (oPhase != null) {
            comp.setPhase(oPhase);
        }
        parent.getChildren().add(comp);
    }

    public String removeCdata(String script) {
        String wk = script.trim();
        if (wk.startsWith("<![CDATA[") && (wk = wk.substring("<![CDATA[".length())).endsWith("]]>")) {
            int n = wk.length() - 3;
            wk = wk.substring(0, n);
        }
        return wk;
    }

    protected final Iterator findAll() {
        ArrayList<FaceletHandler> found = new ArrayList<FaceletHandler>();
        if (this.nextHandler instanceof CompositeFaceletHandler) {
            FaceletHandler[] h = ((CompositeFaceletHandler)this.nextHandler).getHandlers();
            for (int i = 0; i < h.length; ++i) {
                found.add(h[i]);
            }
        } else {
            found.add(this.nextHandler);
        }
        return found.iterator();
    }
}

