/*
 * Decompiled with CFR 0.152.
 */
package strawberry.facelet;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.servlet.http.HttpServletRequest;
import strawberry.event.PhaseEventEx;
import strawberry.lifecycle.AnyPhase;
import strawberry.plugin.ScriptEngine;

public class ServerSideScriptComponent
extends UIComponentBase
implements AnyPhase {
    protected static final Logger log = Logger.getLogger("strawberry.script");
    protected static final Logger slog = Logger.getLogger("strawberry.scriptlog");
    String script = "";
    String method = null;
    int phase = 0;
    public static final String[] keywords = new String[]{"afterRestoreView", "beforeApplyRequestValues", "afterApplyRequestValues", "beforeProcessValidations", "afterProcessValidations", "beforeUpdateModelValues", "afterUpdateModelValues", "beforeInvokeApplication", "afterInvokeApplication", "beforeRenderResponse", "afterRenderResponse"};

    public String getFamily() {
        return "strawberry";
    }

    public void setScript(String newValue) {
        this.script = newValue;
    }

    public void setMethod(String newValue) {
        this.method = newValue;
    }

    public void setPhase(String newValue) {
        log.fine("55) setPhase '" + newValue + "'");
        if (newValue == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < keywords.length; ++i) {
            if (!keywords[i].equals(newValue)) continue;
            this.phase = 1 + i;
            log.fine("61) break");
            break;
        }
        if (this.phase == 0) {
            log.info("66) IllegalArgumentException");
            throw new IllegalArgumentException(newValue + "\u306f\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093");
        }
    }

    public void anyPhase(PhaseEventEx event) {
        PhaseEvent pe = event.getPhaseEvent();
        PhaseId pid = pe.getPhaseId();
        int ord = (pid.getOrdinal() - 1) * 2;
        if (event.isAfter()) {
            ++ord;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("anyPhase  " + pid + ", after = " + event.isAfter());
            log.finer("83)  phase = " + this.phase + ", ord = " + ord);
        }
        if (this.phase == ord) {
            FacesContext faces = pe.getFacesContext();
            boolean b = this.checkMethod(faces);
            if (b) {
                log.fine("script\u3092\u5b9f\u884c\u3057\u307e\u3059");
                this.execute(faces);
            } else {
                log.fine("script\u3092\u5b9f\u884c\u3057\u307e\u305b\u3093");
            }
        } else {
            log.fine("script\u3092\u5b9f\u884c\u3057\u307e\u305b\u3093");
        }
    }

    public boolean checkMethod(FacesContext faces) {
        if (this.method == null) {
            return true;
        }
        HttpServletRequest req = (HttpServletRequest)faces.getExternalContext().getRequest();
        String methodName = req.getMethod();
        log.fine("methodName = " + methodName);
        return methodName.equalsIgnoreCase(this.method);
    }

    public void decode(FacesContext context) {
    }

    public void encodeEnd(FacesContext context) {
    }

    public void encodeChildren(FacesContext context) {
    }

    public void encodeBegin(FacesContext context) {
    }

    public void execute(FacesContext faces) {
        ArrayList<String> importsArray = new ArrayList<String>();
        importsArray.add("javax.faces.application.FacesMessage");
        ExternalContext ec = faces.getExternalContext();
        Object wk = ec.getApplicationMap().get("javascript.Engine");
        ScriptEngine engine = null;
        if (wk != null && wk instanceof ScriptEngine) {
            engine = (ScriptEngine)wk;
            engine.addScriptableObject("faces", faces);
            UIViewRoot uiv = faces.getViewRoot();
            engine.addScriptableObject("root", uiv);
            engine.addScriptableObject("logging", slog);
            engine.addScriptableObject("session", faces.getExternalContext().getSessionMap());
            engine.addScriptableObject("application", faces.getExternalContext().getApplicationMap());
            engine.addScriptableObject("request", faces.getExternalContext().getRequestMap());
            engine.addScriptableObject("param", faces.getExternalContext().getRequestParameterMap());
            String wkScript = "";
            for (int i = 0; i < importsArray.size(); ++i) {
                String tmp = (String)importsArray.get(i);
                String state = this.extractClassName(tmp) + " = Packages." + tmp + ";";
                log.fine("157) state" + state);
                wkScript = wkScript + state;
            }
            Object result = engine.evaluateString(wkScript + this.script, "<cmd>", 1);
        } else {
            log.warning("ENGINE \u304c\u307f\u3064\u304b\u308a\u307e\u305b\u3093");
        }
    }

    public String extractClassName(String fullName) {
        int idx = fullName.lastIndexOf(".");
        return fullName.substring(idx + 1);
    }
}

