/*
 * Decompiled with CFR 0.152.
 */
package strawberry.facelet;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.VariableResolver;

public final class InitHandler
extends TagHandler {
    protected static final Logger log = Logger.getLogger("strawberry.tag.InitHandler");
    private TagAttribute taBean = this.getRequiredAttribute("bean");
    private TagAttribute taMethod = this.getRequiredAttribute("method");

    public InitHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        String sBean = this.taBean.getValue(ctx);
        String sMethod = this.taMethod.getValue(ctx);
        log.fine("bean = '" + sBean + "'");
        log.fine("method = '" + sMethod + "'");
        FacesContext faces = ctx.getFacesContext();
        VariableResolver vri = faces.getApplication().getVariableResolver();
        Object obj = vri.resolveVariable(faces, sBean);
        this.callMethod(obj, sMethod);
    }

    public Object callMethod(Object bean, String methodName) {
        Object ret = null;
        Class<?> cls = bean.getClass();
        try {
            Method method = cls.getMethod(methodName, null);
            ret = method.invoke(bean, (Object[])null);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "(76)catch Exception bean = " + bean + ", method= " + methodName);
            log.log(Level.SEVERE, "(76)catch Exception " + ex.getMessage());
        }
        return ret;
    }
}

