/*
 * Decompiled with CFR 0.152.
 */
package strawberry.facelet;

import com.sun.facelets.FaceletFactory;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.compiler.SAXCompiler;
import com.sun.facelets.compiler.TagLibraryConfig;
import com.sun.facelets.impl.DefaultFaceletFactory;
import com.sun.facelets.impl.DefaultResourceResolver;
import com.sun.facelets.impl.ResourceResolver;
import com.sun.facelets.tag.TagDecorator;
import com.sun.facelets.tag.TagLibrary;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;

public class FaceletFactorySupport {
    protected static final Logger log = Logger.getLogger("strawberry.application");
    protected static final Logger elLog = Logger.getLogger("strawberry.el.funmap");
    public static final String PARAM_LIBRARIES = "facelets.LIBRARIES";
    public static final String PARAM_DECORATORS = "facelets.DECORATORS";
    public static final String PARAM_SKIP_COMMENTS = "facelets.SKIP_COMMENTS";
    boolean original = true;
    public static final String PARAM_REFRESH_PERIO = "facelets.REFRESH_PERIOD";
    public static final long DEFAULT_REFRESH_PERIOD = 2L;

    public Compiler createCompiler() {
        return new SAXCompiler();
    }

    public void initializeCompiler(Compiler c, ExternalContext ext) {
        String skipParam;
        String decParam;
        int i;
        String libParam = ext.getInitParameter(PARAM_LIBRARIES);
        log.fine("42) libParam = " + libParam);
        if (libParam != null) {
            libParam = libParam.trim();
            String[] libs = libParam.split(";");
            for (i = 0; i < libs.length; ++i) {
                log.config("50) libs(" + i + ") = '" + libs[i] + "'");
                try {
                    URL src = ext.getResource(libs[i].trim());
                    if (src == null) {
                        throw new FileNotFoundException(libs[i]);
                    }
                    TagLibrary libObj = TagLibraryConfig.create(src);
                    c.addTagLibrary(libObj);
                    continue;
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Error Loading Library: " + libs[i], e);
                }
            }
        }
        if ((decParam = ext.getInitParameter(PARAM_DECORATORS)) != null) {
            decParam = decParam.trim();
            String[] decs = decParam.split(";");
            for (i = 0; i < decs.length; ++i) {
                try {
                    TagDecorator decObj = (TagDecorator)Class.forName(decs[i]).newInstance();
                    c.addTagDecorator(decObj);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error Loading Decorator: " + decs[i], e);
                }
            }
        }
        if ((skipParam = ext.getInitParameter(PARAM_SKIP_COMMENTS)) != null && "true".equals(skipParam)) {
            c.setTrimmingComments(true);
        }
    }

    public FaceletFactory createFaceletFactory(ExternalContext ec, ResourceResolver resolver) {
        Compiler c = this.createCompiler();
        this.initializeCompiler(c, ec);
        long refreshPeriod = 2L;
        if (this.original) {
            log.config("\u6307\u5b9a\u3055\u308c\u305fRR\u306f\u4f7f\u308f\u306a\u3044\u3067\u3001DefaultResourceResolver \u3092\u4f7f\u3044\u307e\u3059");
            DefaultResourceResolver defaultR = new DefaultResourceResolver();
            return new DefaultFaceletFactory(c, defaultR, refreshPeriod);
        }
        return new DefaultFaceletFactory(c, resolver, refreshPeriod);
    }
}

