/*
 * Decompiled with CFR 0.152.
 */
package strawberry.event;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import strawberry.event.PhaseEventEx;
import strawberry.lifecycle.AfterProcessValidations;
import strawberry.lifecycle.AfterRestoreView;
import strawberry.lifecycle.AfterUpdateModelValues;
import strawberry.lifecycle.AnyPhase;

public class PhaseListenerImpl
implements PhaseListener {
    protected static final Logger log = Logger.getLogger("strawberry.PhaseListener");

    public void afterPhase(PhaseEvent event) {
        FacesContext faces = event.getFacesContext();
        PhaseId pid = event.getPhaseId();
        int ord = pid.getOrdinal();
        if (ord == 1) {
            this.processAfterRestoreView(faces, (UIComponent)faces.getViewRoot());
        }
        if (ord == 3) {
            this.processAfterProcessValidations(faces, (UIComponent)faces.getViewRoot());
        }
        if (ord == 4) {
            this.processAfterUpdateModelValuesPhase(faces, (UIComponent)faces.getViewRoot());
        }
        this.processAnyPhase(new PhaseEventEx(event, 1), (UIComponent)faces.getViewRoot());
    }

    public void processAnyPhase(PhaseEventEx event, UIComponent component) throws FacesException {
        if (component == null) {
            log.finer("component == null");
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("processAnyPhase:" + component.getClass().getName() + ", !isRendered = " + !component.isRendered());
        }
        List childs = component.getChildren();
        for (int i = 0; i < childs.size(); ++i) {
            UIComponent kid = (UIComponent)childs.get(i);
            this.processAnyPhase(event, kid);
        }
        if (component instanceof AnyPhase) {
            AnyPhase wk = (AnyPhase)component;
            wk.anyPhase(event);
        }
    }

    public void processAfterUpdateModelValuesPhase(FacesContext facesContext, UIComponent component) throws FacesException {
        if (log.isLoggable(Level.FINER)) {
            log.finer("processAfterUpdateModelValuesPhase:" + component.getClass().getName() + ", !isRendered = " + !component.isRendered());
        }
        List childs = component.getChildren();
        for (int i = 0; i < childs.size(); ++i) {
            UIComponent kid = (UIComponent)childs.get(i);
            this.processAfterUpdateModelValuesPhase(facesContext, kid);
        }
        if (component instanceof AfterUpdateModelValues) {
            AfterUpdateModelValues wk = (AfterUpdateModelValues)component;
            wk.afterUpdateModelValues(facesContext);
        }
    }

    public void processAfterProcessValidations(FacesContext facesContext, UIComponent component) throws FacesException {
        if (log.isLoggable(Level.FINER)) {
            log.finer("processAfterProcessValidations:" + component.getClass().getName() + ", !isRendered = " + !component.isRendered());
        }
        List childs = component.getChildren();
        for (int i = 0; i < childs.size(); ++i) {
            UIComponent kid = (UIComponent)childs.get(i);
            this.processAfterProcessValidations(facesContext, kid);
        }
        if (component instanceof AfterProcessValidations) {
            AfterProcessValidations wk = (AfterProcessValidations)component;
            wk.afterProcessValidations(facesContext);
        }
    }

    public void processAfterRestoreView(FacesContext facesContext, UIComponent component) throws FacesException {
        if (log.isLoggable(Level.FINER)) {
            log.finer("processAfterRestoreView:" + component.getClass().getName() + ", !isRendered = " + !component.isRendered());
        }
        List childs = component.getChildren();
        for (int i = 0; i < childs.size(); ++i) {
            UIComponent kid = (UIComponent)childs.get(i);
            this.processAfterRestoreView(facesContext, kid);
        }
        if (component instanceof AfterRestoreView) {
            AfterRestoreView wk = (AfterRestoreView)component;
            wk.afterRestoreView(facesContext);
        }
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext faces = event.getFacesContext();
        this.processAnyPhase(new PhaseEventEx(event, 0), (UIComponent)faces.getViewRoot());
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

