/*
 * Decompiled with CFR 0.152.
 */
package strawberry.el;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import strawberry.application.ApplicationAssociate;

public class VariableResolverImpl
extends VariableResolver {
    protected static final Logger log = Logger.getLogger("strawberry.el");

    public Object resolveVariable(FacesContext context, String name) throws EvaluationException {
        log.fine("resolveVariable ------------------------------------- **");
        ExternalContext ec = context.getExternalContext();
        if ("applicationScope".equals(name)) {
            return ec.getApplicationMap();
        }
        if ("cookie".equals(name)) {
            return ec.getRequestCookieMap();
        }
        if ("facesContext".equals(name)) {
            log.finer("(69) => " + context);
            return context;
        }
        if ("header".equals(name)) {
            return ec.getRequestHeaderMap();
        }
        if ("headerValues".equals(name)) {
            return ec.getRequestHeaderValuesMap();
        }
        if ("initParam".equals(name)) {
            return ec.getInitParameterMap();
        }
        if ("param".equals(name)) {
            return ec.getRequestParameterMap();
        }
        if ("paramValues".equals(name)) {
            return ec.getRequestParameterValuesMap();
        }
        if ("requestScope".equals(name)) {
            return ec.getRequestMap();
        }
        if ("sessionScope".equals(name)) {
            return ec.getSessionMap();
        }
        if ("view".equals(name)) {
            return context.getViewRoot();
        }
        Object value = null;
        if (name.startsWith("autoHashMap")) {
            Object v = ec.getSessionMap().get(name);
            value = v;
            if (null == v) {
                value = new HashMap();
                ec.getSessionMap().put(name, value);
            }
        } else {
            Object v = ec.getRequestMap().get(name);
            value = v;
            if (null == v && null == (value = ec.getSessionMap().get(name)) && null == (value = ec.getApplicationMap().get(name))) {
                ApplicationAssociate associate = ApplicationAssociate.getInstance(context.getExternalContext());
                if (null != associate) {
                    value = associate.createAndMaybeStoreManagedBeans(context, name);
                } else {
                    log.info("106) ********** associate is null '" + name + "'");
                }
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            String wk = "null";
            if (value != null) {
                wk = value.toString();
            }
            if (wk.length() > 70) {
                wk = wk.substring(0, 70);
            }
            log.finest("resolveVariable: Resolved variable:" + wk);
        }
        return value;
    }
}

