/*
 * Decompiled with CFR 0.152.
 */
package strawberry.ctx;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import strawberry.ctx.BaseContextMap;

class RequestParameterMap
extends BaseContextMap {
    protected static final Logger log = Logger.getLogger("strawberry.request");
    private ServletRequest request = null;

    RequestParameterMap(ServletRequest request) {
        this.request = request;
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key == "com.sun.faces.IMMUTABLE") {
            return "com.sun.faces.IMMUTABLE";
        }
        String ans = this.request.getParameter(key.toString());
        if (log.isLoggable(Level.FINE)) {
            log.fine("get(" + key + ") => '" + ans + "'");
        }
        return ans;
    }

    public Object put(Object key, Object value) {
        log.warning("put -------------- IGNORED !!");
        return value;
    }

    public Set entrySet() {
        HashSet<BaseContextMap.Entry> entries = new HashSet<BaseContextMap.Entry>();
        Enumeration e = this.request.getParameterNames();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            entries.add(new BaseContextMap.Entry(paramName, this.request.getParameter(paramName)));
        }
        return entries;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RequestParameterMap)) {
            return false;
        }
        return super.equals(obj);
    }
}

