/*
 * Decompiled with CFR 0.152.
 */
package strawberry.config;

import com.sun.faces.config.beans.FacesConfigBean;
import com.sun.faces.config.beans.ListEntriesBean;
import com.sun.faces.config.beans.ManagedBeanBean;
import com.sun.faces.config.beans.ManagedPropertyBean;
import com.sun.faces.config.beans.MapEntriesBean;
import com.sun.faces.config.beans.MapEntryBean;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FacesConfigLoader
extends DefaultHandler {
    protected static final Logger log = Logger.getLogger("strawberry.application");
    private Stack stack = new Stack();
    FacesConfigBean configBean = new FacesConfigBean();
    ManagedBeanBean mBean = null;
    ManagedPropertyBean propBean = null;
    MapEntriesBean mapEntries = null;
    MapEntryBean mapEntry = null;
    ListEntriesBean listEntries = null;

    public void log(String msg) {
        log.finest(msg);
    }

    public FacesConfigBean load(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        try {
            SAXParserFactory fac = SAXParserFactory.newInstance();
            SAXParser parser = fac.newSAXParser();
            parser.parse(path, (DefaultHandler)this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (log.isLoggable(Level.FINER)) {
            this.print();
        }
        return this.configBean;
    }

    public void print() {
        this.log("_______________________");
        ManagedBeanBean[] beanBean = this.configBean.getManagedBeans();
        for (int i = 0; i < beanBean.length; ++i) {
            ListEntriesBean listEnt;
            ManagedBeanBean mb = beanBean[i];
            this.log("" + i + ", getManagedBeanName: " + mb.getManagedBeanName());
            this.log("" + i + ", getManagedBeanClass: " + mb.getManagedBeanClass());
            this.log("" + i + ", getManagedBeanScope: " + mb.getManagedBeanScope());
            ManagedPropertyBean[] propArray = mb.getManagedProperties();
            for (int j = 0; j < propArray.length; ++j) {
                ManagedPropertyBean pb = propArray[j];
                this.log("" + i + ", ManagedPropertyBean.Name: " + pb.getPropertyName() + ", Class: " + pb.getPropertyClass() + ", Value: " + pb.getValue());
            }
            MapEntriesBean mapEnt = mb.getMapEntries();
            if (mapEnt != null) {
                this.printMapEntries(mapEnt);
            }
            if ((listEnt = mb.getListEntries()) == null) continue;
            log.fine("" + i + ", listEnt = " + listEnt);
        }
        this.log("_______________________");
    }

    private void printMapEntries(MapEntriesBean mapEnt) {
        MapEntryBean[] beans = mapEnt.getMapEntries();
        for (int i = 0; i < beans.length; ++i) {
            this.log("?, " + i + ", " + beans[i].getKey() + " = " + beans[i].getValue());
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("managed-bean".equals(qName)) {
            this.mBean = new ManagedBeanBean();
        } else if ("managed-property".equals(qName)) {
            this.propBean = new ManagedPropertyBean();
        } else if ("managed-property".equals(qName)) {
            this.propBean = new ManagedPropertyBean();
        } else if ("map-entries".equals(qName)) {
            this.mapEntries = new MapEntriesBean();
            this.log("startElement    new MapEntriesBean = " + this.mapEntries);
        } else if ("map-entry".equals(qName)) {
            this.mapEntry = new MapEntryBean();
            this.log("startElement    new MapEntryBean = " + this.mapEntry);
        } else if ("list-entries".equals(qName)) {
            this.listEntries = new ListEntriesBean();
            this.log("startElement    new ListEntriesBean = " + this.listEntries);
        }
        this.stack.push(qName);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.log("endElement = " + qName + "," + localName);
        String pop = (String)this.stack.pop();
        if (!qName.equals(pop)) {
            log.warning("error");
        }
        if ("managed-bean".equals(qName)) {
            this.configBean.addManagedBean(this.mBean);
        } else if ("managed-property".equals(qName)) {
            this.mBean.addManagedProperty(this.propBean);
        } else if ("map-entries".equals(qName)) {
            this.mBean.setMapEntries(this.mapEntries);
        } else if ("map-entry".equals(qName)) {
            this.mapEntries.addMapEntry(this.mapEntry);
        } else if ("list-entries".equals(qName)) {
            this.mBean.setListEntries(this.listEntries);
        }
    }

    public void endDocument() throws SAXException {
        this.log("stack.size = " + this.stack.size());
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        String qName = (String)this.stack.peek();
        Object[] stackArray = this.stack.toArray();
        log.finer("stack = " + this.stackToString(stackArray));
        String text = new String(ch, start, length);
        if ("managed-bean-name".equals(qName)) {
            this.mBean.setManagedBeanName(text);
        } else if ("managed-bean-class".equals(qName)) {
            this.mBean.setManagedBeanClass(text);
        } else if ("managed-bean-scope".equals(qName)) {
            this.mBean.setManagedBeanScope(text);
        } else if ("property-name".equals(qName)) {
            this.propBean.setPropertyName(text);
        } else if ("property-class".equals(qName)) {
            this.propBean.setPropertyClass(text);
        } else if ("key-class".equals(qName)) {
            this.mapEntries.setKeyClass(text);
        } else if ("value-class".equals(qName)) {
            int n = stackArray.length;
            String pop2 = (String)stackArray[n - 2];
            if ("map-entries".equals(pop2)) {
                this.mapEntries.setValueClass(text);
            } else if ("list-entries".equals(pop2)) {
                this.listEntries.setValueClass(text);
            } else {
                log.warning("?????" + pop2);
            }
        } else if ("key".equals(qName)) {
            this.mapEntry.setKey(text);
        } else if ("value".equals(qName)) {
            int n = stackArray.length;
            String pop2 = (String)stackArray[n - 2];
            if ("managed-property".equals(pop2)) {
                this.propBean.setValue(text);
            } else if ("map-entry".equals(pop2)) {
                this.mapEntry.setValue(text);
            } else if ("list-entries".equals(pop2)) {
                this.listEntries.setValueClass(text);
            } else {
                log.warning("?????" + pop2);
            }
        }
    }

    public String stackToString(Object[] arr) {
        StringBuffer sb = new StringBuffer();
        String sep = "";
        for (int i = 0; i < arr.length; ++i) {
            sb.append(sep + arr[i]);
            sep = ", ";
        }
        return sb.toString();
    }
}

