/*
 * Decompiled with CFR 0.152.
 */
package strawberry.config;

import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.context.ExternalContext;
import strawberry.config.SetupUtil;

public class ApplicationInitializer {
    protected static final Logger log = Logger.getLogger("strawberry.init.app");
    String[] validators = new String[]{"javax.faces.DoubleRange", "javax.faces.validator.DoubleRangeValidator", "javax.faces.Length", "javax.faces.validator.LengthValidator", "javax.faces.LongRange", "javax.faces.validator.LongRangeValidator", "jsfutil.validator.FutureValidator", "jsfutil.validator.FutureValidator"};
    private static final Class[] PRIM_CLASSES_TO_CONVERT = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE};
    private static final String[] CONVERTERS_FOR_PRIMS = new String[]{"javax.faces.convert.BooleanConverter", "javax.faces.convert.ByteConverter", "javax.faces.convert.CharacterConverter", "javax.faces.convert.DoubleConverter", "javax.faces.convert.FloatConverter", "javax.faces.convert.IntegerConverter", "javax.faces.convert.LongConverter", "javax.faces.convert.ShortConverter"};
    String[] converId = new String[]{"javax.faces.BigDecimal", "javax.faces.convert.BigDecimalConverter", "javax.faces.BigInteger", "javax.faces.convert.BigIntegerConverter", "javax.faces.Boolean", "javax.faces.convert.BooleanConverter", "javax.faces.Byte", "javax.faces.convert.ByteConverter", "javax.faces.Character", "javax.faces.convert.CharacterConverter", "javax.faces.DateTime", "javax.faces.convert.DateTimeConverter", "javax.faces.Double", "javax.faces.convert.DoubleConverter", "javax.faces.Float", "javax.faces.convert.FloatConverter", "javax.faces.Integer", "javax.faces.convert.IntegerConverter", "javax.faces.Long", "javax.faces.convert.LongConverter", "javax.faces.Number", "javax.faces.convert.NumberConverter", "javax.faces.Short", "javax.faces.convert.ShortConverter", "jsfutil.IntegerConverterAllowsNullString", "jsfutil.convert.IntegerConverter", "jsfutil.IntegerConverterAllowsBigDecimal", "jsfutil.convert.IntegerConverterAllowsBigDecimal", "jsfutil.RedirectConverter", "jsfutil.convert.RedirectConverter"};
    String[] otherComponents = new String[]{"strawberry.HtmlInputText", "strawberry.component.html.HtmlInputText", "strawberry.HtmlOutputText", "strawberry.component.html.HtmlOutputText"};

    public void configureApplication(ExternalContext ec, Application application) throws Exception {
        this.configureComponents(application);
        this.configureConverters(application);
        this.configureLocale(application);
        this.configureValidators(application);
    }

    public void configureValidators(Application application) {
        for (int i = 0; i < this.validators.length; i += 2) {
            String validatorId = this.validators[i + 0];
            String validatorClass = this.validators[i + 1];
            if (log.isLoggable(Level.FINEST)) {
                log.finest("addValidator(" + validatorId + ',' + validatorClass + ")    @@@");
            }
            application.addValidator(validatorId, validatorClass);
        }
    }

    private void configureConverters(Application application) throws Exception {
        int i = 0;
        int len = 0;
        len = PRIM_CLASSES_TO_CONVERT.length;
        for (i = 0; i < len; ++i) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("addConverterByClass(" + PRIM_CLASSES_TO_CONVERT[i] + ',' + CONVERTERS_FOR_PRIMS[i] + ")    @@@");
            }
            application.addConverter(PRIM_CLASSES_TO_CONVERT[i], CONVERTERS_FOR_PRIMS[i]);
        }
        this.addConverterFromArray(application, this.converId);
    }

    private void addConverterFromArray(Application application, String[] array) throws Exception {
        for (int j = 0; j < array.length; j += 2) {
            String converterId = array[j + 0];
            String converterClass = array[j + 1];
            if (log.isLoggable(Level.FINER)) {
                log.finer("240) converterId ------------------------  \u914d\u5217\u304b\u3089\u8ffd\u52a0 ");
                log.finer("241) converterId = " + converterId + ", converterClass = " + converterClass);
            }
            application.addConverter(converterId, converterClass);
        }
    }

    public void configureLocale(Application application) {
        application.setDefaultLocale(Util.getLocaleFromString("ja"));
        String[] values = new String[]{"en", "ja"};
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (int i = 0; i < values.length; ++i) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("addSupportedLocale(" + values[i] + ')');
            }
            locales.add(Util.getLocaleFromString(values[i]));
        }
        application.setSupportedLocales(locales);
    }

    public void configureComponents(Application application) {
        SetupUtil util = new SetupUtil();
        util.addStandardComponents(application);
        util.addComponents(application, this.otherComponents);
    }
}

