/*
 * Decompiled with CFR 0.152.
 */
package strawberry.component;

import java.io.Serializable;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;

class StateHolderSaverEx
implements Serializable {
    private String className = null;
    private Object savedState = null;

    public StateHolderSaverEx(FacesContext context, Object toSave) {
        this.className = toSave.getClass().getName();
        if (toSave instanceof StateHolder) {
            if (!((StateHolder)toSave).isTransient()) {
                this.savedState = ((StateHolder)toSave).saveState(context);
            } else {
                this.className = null;
            }
        } else if (toSave instanceof Serializable) {
            this.savedState = toSave;
            this.className = null;
        }
    }

    public Object restore(FacesContext context) throws IllegalStateException {
        Object result = null;
        Class toRestoreClass = null;
        if (null == this.className && null != this.savedState) {
            return this.savedState;
        }
        if (this.className == null) {
            return null;
        }
        try {
            toRestoreClass = StateHolderSaverEx.loadClass(this.className, this);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage());
        }
        if (null != toRestoreClass) {
            try {
                result = toRestoreClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e.getMessage());
            }
            catch (IllegalAccessException a) {
                throw new IllegalStateException(a.getMessage());
            }
        }
        if (null != result && null != this.savedState && result instanceof StateHolder) {
            ((StateHolder)result).restoreState(context, this.savedState);
        }
        return result;
    }

    private static Class loadClass(String name, Object fallbackClass) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader.loadClass(name);
    }
}

