/*
 * Decompiled with CFR 0.152.
 */
package strawberry.application;

import com.sun.faces.renderkit.ResponseStateManagerImpl;
import com.sun.faces.util.TreeStructure;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ResponseStateManager;
import org.apache.commons.collections.LRUMap;

public class StateManagerImpl
extends StateManager {
    protected static final Logger log = Logger.getLogger("strawberry.state.save");
    protected static final Logger logRestore = Logger.getLogger("strawberry.state.restore");
    private static final String NUMBER_OF_VIEWS_IN_SESSION = "com.sun.faces.NUMBER_OF_VIEWS_IN_SESSION";
    private static final int DEFAULT_NUMBER_OF_VIEWS_IN_SESSION = 15;
    private static final String NUMBER_OF_VIEWS_IN_LOGICAL_VIEW_IN_SESSION = "com.sun.faces.NUMBER_OF_VIEWS_IN_LOGICAL_VIEW_IN_SESSION";
    private static final int DEFAULT_NUMBER_OF_VIEWS_IN_LOGICAL_VIEW_IN_SESSION = 15;
    int noOfViews = 0;
    int noOfViewsInLogicalView = 0;
    char requestIdSerial = '\u0000';

    public boolean isSavingStateInClient(FacesContext context) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateManager.SerializedView saveSerializedView(FacesContext context) throws IllegalStateException {
        log.fine("saveSerializedView --- \u5165\u308a\u307e\u3059");
        StateManager.SerializedView result = null;
        Object treeStructure = null;
        Object componentState = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            log.info("(96) isTransient() \u306a\u306e\u3067 return");
            return result;
        }
        this.checkIdUniqueness(context, (UIComponent)viewRoot, new HashSet());
        if (log.isLoggable(Level.FINE)) {
            log.fine("(105) Begin creating serialized view for " + viewRoot.getViewId());
        }
        treeStructure = this.getTreeStructureToSave(context);
        componentState = this.getComponentStateToSave(context);
        result = new StateManager.SerializedView((StateManager)this, treeStructure, componentState);
        Util.doAssert(treeStructure instanceof Serializable);
        Util.doAssert(componentState instanceof Serializable);
        if (log.isLoggable(Level.FINE)) {
            log.fine("(116) End creating serialized view " + viewRoot.getViewId());
        }
        if (!this.isSavingStateInClient(context)) {
            String id = null;
            String idInActualMap = null;
            String idInLogicalMap = (String)context.getExternalContext().getRequestMap().get("com.sun.faces.logicalViewMap");
            LRUMap logicalMap = null;
            LRUMap actualMap = null;
            int logicalMapSize = this.getNumberOfViewsParameter(context);
            int actualMapSize = this.getNumberOfViewsInLogicalViewParameter(context);
            Object[] stateArray = new Object[]{treeStructure, componentState};
            Map sessionMap = Util.getSessionMap(context);
            StateManagerImpl stateManagerImpl = this;
            synchronized (stateManagerImpl) {
                logicalMap = (LRUMap)sessionMap.get("com.sun.faces.logicalViewMap");
                if (null == logicalMap) {
                    logicalMap = new LRUMap(logicalMapSize);
                    sessionMap.put("com.sun.faces.logicalViewMap", logicalMap);
                }
                Util.doAssert(null != logicalMap);
                if (null == idInLogicalMap) {
                    idInLogicalMap = this.createUniqueRequestId();
                }
                Util.doAssert(null != idInLogicalMap);
                idInActualMap = this.createUniqueRequestId();
                actualMap = (LRUMap)logicalMap.get((Object)idInLogicalMap);
                if (null == actualMap) {
                    actualMap = new LRUMap(actualMapSize);
                    logicalMap.put((Object)idInLogicalMap, (Object)actualMap);
                }
                id = idInLogicalMap + ':' + idInActualMap;
                result = new StateManager.SerializedView((StateManager)this, (Object)id, null);
                actualMap.put((Object)idInActualMap, (Object)stateArray);
            }
        }
        return result;
    }

    private String createUniqueRequestId() {
        char c = this.requestIdSerial;
        this.requestIdSerial = (char)(c + '\u0001');
        if (c == '\uffff') {
            this.requestIdSerial = '\u0000';
        }
        return "_id" + this.requestIdSerial;
    }

    protected void checkIdUniqueness(FacesContext context, UIComponent component, Set componentIds) throws IllegalStateException {
        String id;
        UIComponent kid;
        Iterator<Object> kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            kid = (UIComponent)kids.next();
            id = kid.getClientId(context);
            if (id != null && !componentIds.add(id)) {
                String messageString = Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{id});
                if (log.isLoggable(Level.SEVERE)) {
                    log.severe(messageString);
                }
                throw new IllegalStateException(messageString);
            }
            this.checkIdUniqueness(context, kid, componentIds);
        }
        kids = component.getFacets().values().iterator();
        while (kids.hasNext()) {
            kid = (UIComponent)kids.next();
            id = kid.getClientId(context);
            if (id != null && !componentIds.add(id)) {
                String messageString = Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{id});
                if (log.isLoggable(Level.SEVERE)) {
                    log.severe(messageString);
                }
                throw new IllegalStateException(messageString);
            }
            this.checkIdUniqueness(context, kid, componentIds);
        }
    }

    protected Object getComponentStateToSave(FacesContext context) {
        log.fine("253) getViewRoot.processSaveState \u3092\u547c\u3073\u307e\u3059 ---- \u2606");
        return context.getViewRoot().processSaveState(context);
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        TreeStructure structRoot = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (!viewRoot.isTransient()) {
            structRoot = new TreeStructure((UIComponent)viewRoot);
            this.buildTreeStructureToSave(context, (UIComponent)viewRoot, structRoot, null);
        }
        return structRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        if (null == renderKitId) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " renderKitId " + renderKitId;
            throw new IllegalArgumentException(message);
        }
        UIViewRoot viewRoot = null;
        if (this.isSavingStateInClient(context)) {
            if (logRestore.isLoggable(Level.FINE)) {
                logRestore.fine("(282) restoreTreeStructure \u958b\u59cb " + viewId);
            }
            viewRoot = this.restoreTreeStructure(context, viewId, renderKitId);
            if (logRestore.isLoggable(Level.FINE)) {
                logRestore.fine("(285) \u5fa9\u5143\u3055\u308c\u305f\u6728\u69cb\u9020 " + viewRoot);
            }
            if (viewRoot != null) {
                logRestore.fine("(289) restoreComponentState \u51e6\u7406");
                this.restoreComponentState(context, viewRoot, renderKitId);
            } else if (logRestore.isLoggable(Level.FINE)) {
                logRestore.fine("(290) Possibly a new request. Tree structure could not  be restored for " + viewId);
            }
            if (logRestore.isLoggable(Level.FINE)) {
                logRestore.fine("(295) \u7d42\u4e86 restoring view from response " + viewId);
            }
        } else {
            Object id = null;
            ResponseStateManager rsm = Util.getResponseStateManager(context, renderKitId);
            id = rsm.getTreeStructureToRestore(context, viewId);
            if (logRestore.isLoggable(Level.FINE)) {
                logRestore.fine("(306) id = " + id);
            }
            if (null == id) {
                logRestore.fine("(310) id == null");
            } else {
                if (logRestore.isLoggable(Level.FINE)) {
                    logRestore.fine("(313) Begin restoring view in session for viewId " + viewId);
                }
                String idString = (String)id;
                String idInLogicalMap = null;
                String idInActualMap = null;
                int sep = idString.indexOf(58);
                Util.doAssert(-1 != sep);
                Util.doAssert(sep < idString.length());
                idInLogicalMap = idString.substring(0, sep);
                idInActualMap = idString.substring(sep + 1);
                ExternalContext externalCtx = context.getExternalContext();
                Object sessionObj = externalCtx.getSession(false);
                if (sessionObj == null) {
                    if (logRestore.isLoggable(Level.FINE)) {
                        logRestore.fine("Can't Restore Server View State, session expired for viewId: " + viewId);
                    }
                    return null;
                }
                Map logicalMap = null;
                Map actualMap = null;
                Map sessionMap = externalCtx.getSessionMap();
                TreeStructure structRoot = null;
                Object[] stateArray = null;
                Object object = sessionObj;
                synchronized (object) {
                    logicalMap = (Map)sessionMap.get("com.sun.faces.logicalViewMap");
                    if (logicalMap != null && (actualMap = (Map)logicalMap.get(idInLogicalMap)) != null) {
                        context.getExternalContext().getRequestMap().put("com.sun.faces.logicalViewMap", idInLogicalMap);
                        stateArray = (Object[])actualMap.get(idInActualMap);
                    }
                }
                if (stateArray == null) {
                    if (logRestore.isLoggable(Level.FINE)) {
                        logRestore.fine("(358) Session Available, but View State does not exist for viewId: " + viewId);
                    }
                    return null;
                }
                structRoot = (TreeStructure)stateArray[0];
                viewRoot = (UIViewRoot)structRoot.createComponent();
                logRestore.fine("(365) restoreComponentTreeStructure \u51e6\u7406 ----- \u2606");
                this.restoreComponentTreeStructure(structRoot, (UIComponent)viewRoot);
                logRestore.fine("(368) processRestoreState \u51e6\u7406 ----- \u2606");
                viewRoot.processRestoreState(context, stateArray[1]);
                if (logRestore.isLoggable(Level.FINE)) {
                    logRestore.fine("(370) End restoring view in session for viewId " + viewId);
                }
            }
        }
        return viewRoot;
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot root, String renderKitId) {
        if (null == renderKitId) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " renderKitId " + renderKitId;
            throw new IllegalArgumentException(message);
        }
        Object state = null;
        ResponseStateManager rsm = Util.getResponseStateManager(context, renderKitId);
        if (logRestore.isLoggable(Level.FINE)) {
            logRestore.fine("(396) rsm = " + rsm);
        }
        state = rsm.getComponentStateToRestore(context);
        if (logRestore.isLoggable(Level.FINE)) {
            logRestore.fine("(400) state = " + state);
            logRestore.fine("(401) UIViewRoot \u306e processRestoreState() \u3092\u547c\u3073\u307e\u3059");
        }
        root.processRestoreState(context, state);
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        if (null == renderKitId) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " renderKitId " + renderKitId;
            throw new IllegalArgumentException(message);
        }
        UIComponent viewRoot = null;
        TreeStructure structRoot = null;
        ResponseStateManager rsm = Util.getResponseStateManager(context, renderKitId);
        structRoot = (TreeStructure)rsm.getTreeStructureToRestore(context, viewId);
        if (structRoot == null) {
            logRestore.info("401)");
            return null;
        }
        viewRoot = structRoot.createComponent();
        logRestore.fine("405)" + viewRoot);
        this.restoreComponentTreeStructure(structRoot, viewRoot);
        return (UIViewRoot)viewRoot;
    }

    public void writeState(FacesContext context, StateManager.SerializedView state) throws IOException {
        String renderKitId = context.getViewRoot().getRenderKitId();
        log.fine("(390) writeState, renderKitId = " + renderKitId);
        ResponseStateManager rsm = Util.getResponseStateManager(context, renderKitId);
        log.fine("(392) rsm = " + rsm);
        rsm.writeState(context, state);
    }

    public void writeState(FacesContext context, StateManager.SerializedView state, ResponseWriter responseWriter) throws IOException {
        String renderKitId = context.getViewRoot().getRenderKitId();
        log.fine("(412) writeState, renderKitId = " + renderKitId);
        ResponseStateManager rsm = Util.getResponseStateManager(context, renderKitId);
        log.fine("(414) rsm = " + rsm);
        ResponseStateManagerImpl impl = (ResponseStateManagerImpl)rsm;
        impl.writeState(context, state, responseWriter);
    }

    public void buildTreeStructureToSave(FacesContext context, UIComponent component, TreeStructure treeStructure, Set componentIds) {
        String id;
        if (null == componentIds) {
            componentIds = new HashSet<String>();
        }
        Iterator kids = component.getChildren().iterator();
        String messageString = null;
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            id = kid.getClientId(context);
            if (id != null && !componentIds.add(id)) {
                messageString = Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{id});
                if (log.isLoggable(Level.SEVERE)) {
                    log.severe(messageString);
                }
                throw new IllegalStateException(messageString);
            }
            if (kid.isTransient()) continue;
            TreeStructure treeStructureChild = new TreeStructure(kid);
            treeStructure.addChild(treeStructureChild);
            this.buildTreeStructureToSave(context, kid, treeStructureChild, componentIds);
        }
        Iterator facets = component.getFacets().keySet().iterator();
        while (facets.hasNext()) {
            String facetName = (String)facets.next();
            UIComponent facetComponent = (UIComponent)component.getFacets().get(facetName);
            id = facetComponent.getClientId(context);
            if (id != null && !componentIds.add(id)) {
                messageString = Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{id});
                log.severe(messageString);
                throw new IllegalStateException(messageString);
            }
            if (facetComponent.isTransient()) continue;
            TreeStructure treeStructureFacet = new TreeStructure(facetComponent);
            treeStructure.addFacet(facetName, treeStructureFacet);
            this.buildTreeStructureToSave(context, facetComponent, treeStructureFacet, componentIds);
        }
    }

    public void restoreComponentTreeStructure(TreeStructure treeStructure, UIComponent component) {
        logRestore.finer("516 restoreComponentTreeStructure \u5165\u308a\u307e\u3059");
        Iterator kids = treeStructure.getChildren();
        while (kids.hasNext()) {
            logRestore.finer("520)");
            TreeStructure kid = (TreeStructure)kids.next();
            UIComponent child = kid.createComponent();
            component.getChildren().add(child);
            this.restoreComponentTreeStructure(kid, child);
        }
        Iterator facets = treeStructure.getFacetNames();
        while (facets.hasNext()) {
            logRestore.finer("530)");
            String facetName = (String)facets.next();
            TreeStructure facetTreeStructure = treeStructure.getTreeStructureForFacet(facetName);
            UIComponent facetComponent = facetTreeStructure.createComponent();
            component.getFacets().put(facetName, facetComponent);
            this.restoreComponentTreeStructure(facetTreeStructure, facetComponent);
        }
    }

    protected UIViewRoot restoreSerializedView(FacesContext context, StateManager.SerializedView sv, String viewId) {
        if (sv == null) {
            log.fine("Possibly a new request. Tree structure could not  be restored for " + viewId);
            return null;
        }
        TreeStructure structRoot = (TreeStructure)sv.getStructure();
        if (structRoot == null) {
            return null;
        }
        UIComponent viewRoot = structRoot.createComponent();
        if (viewRoot != null) {
            this.restoreComponentTreeStructure(structRoot, viewRoot);
            Object state = sv.getState();
            viewRoot.processRestoreState(context, state);
        }
        return (UIViewRoot)viewRoot;
    }

    protected int getNumberOfViewsParameter(FacesContext context) {
        if (this.noOfViews != 0) {
            return this.noOfViews;
        }
        this.noOfViews = 15;
        String noOfViewsStr = context.getExternalContext().getInitParameter(NUMBER_OF_VIEWS_IN_SESSION);
        if (noOfViewsStr != null) {
            try {
                this.noOfViews = Integer.valueOf(noOfViewsStr);
            }
            catch (NumberFormatException nfe) {
                log.fine("Error parsing the servetInitParameter com.sun.faces.NUMBER_OF_VIEWS_IN_SESSION. Using default " + this.noOfViews);
            }
        }
        return this.noOfViews;
    }

    protected int getNumberOfViewsInLogicalViewParameter(FacesContext context) {
        if (this.noOfViewsInLogicalView != 0) {
            return this.noOfViewsInLogicalView;
        }
        this.noOfViewsInLogicalView = 15;
        String noOfViewsStr = context.getExternalContext().getInitParameter(NUMBER_OF_VIEWS_IN_LOGICAL_VIEW_IN_SESSION);
        if (noOfViewsStr != null) {
            try {
                this.noOfViewsInLogicalView = Integer.valueOf(noOfViewsStr);
            }
            catch (NumberFormatException nfe) {
                log.fine("Error parsing the servetInitParameter com.sun.faces.NUMBER_OF_VIEWS_IN_LOGICAL_VIEW_IN_SESSION. Using default " + this.noOfViewsInLogicalView);
            }
        }
        return this.noOfViewsInLogicalView;
    }
}

