/*
 * Decompiled with CFR 0.152.
 */
package strawberry.application;

import com.sun.faces.application.ConfigNavigationCase;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import strawberry.application.NavigationRuleAware;

public class NavigationHandlerImpl
extends NavigationHandler
implements NavigationRuleAware {
    protected static final Logger initLog = Logger.getLogger("strawberry.init");
    protected static final Logger log = Logger.getLogger("strawberry.nav");
    private Map caseListMap;
    private Set wildCardSet;
    boolean associateSet;

    public NavigationHandlerImpl() {
        if (initLog.isLoggable(Level.FINER)) {
            initLog.finer("Created NavigationHandler instance ");
        }
    }

    public void setRule(Map map, Set set) {
        if (map.size() == 0 && set.size() == 0) {
            initLog.fine("90) map.size() == 0 && set.size() == 0");
        } else {
            if (initLog.isLoggable(Level.FINER)) {
                initLog.finer("92) caseListMap = " + map);
                initLog.finer("93) wildCardSet = " + set);
            }
            this.caseListMap = map;
            this.wildCardSet = set;
            this.associateSet = true;
        }
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        if (context == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " context " + context;
            throw new NullPointerException(message);
        }
        if (outcome == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No navigation rule found for outcome " + outcome + "and viewId " + context.getViewRoot().getViewId() + " Explicitly remain on the current view ");
            }
            return;
        }
        CaseStruct caseStruct = this.getViewId(context, fromAction, outcome);
        ExternalContext extContext = context.getExternalContext();
        if (caseStruct != null) {
            ViewHandler viewHandler = Util.getViewHandler(context);
            if (caseStruct.navCase.hasRedirect()) {
                String newPath = viewHandler.getActionURL(context, caseStruct.viewId);
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Redirecting to path " + newPath + " for outcome " + outcome + "and viewId " + caseStruct.viewId);
                    }
                    extContext.redirect(newPath);
                }
                catch (IOException ioe) {
                    String message = "Redirect to " + newPath + " failed.";
                    log.warning(message);
                    throw new FacesException(message, (Throwable)ioe);
                }
                context.responseComplete();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Response complete for " + caseStruct.viewId);
                }
            } else {
                UIViewRoot newRoot = viewHandler.createView(context, caseStruct.viewId);
                context.setViewRoot(newRoot);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Set new view in FacesContext for " + caseStruct.viewId);
                }
            }
        }
    }

    private CaseStruct getViewId(FacesContext context, String fromAction, String outcome) {
        String viewId = context.getViewRoot().getViewId();
        CaseStruct caseStruct = this.findExactMatch(viewId, fromAction, outcome);
        if (caseStruct == null) {
            caseStruct = this.findWildCardMatch(viewId, fromAction, outcome);
        }
        if (caseStruct == null) {
            caseStruct = this.findDefaultMatch(fromAction, outcome);
        }
        return caseStruct;
    }

    private CaseStruct findExactMatch(String viewId, String fromAction, String outcome) {
        if (!this.associateSet) {
            return null;
        }
        List caseList = (List)this.caseListMap.get(viewId);
        if (caseList == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(caseList, fromAction, outcome);
    }

    private CaseStruct findWildCardMatch(String viewId, String fromAction, String outcome) {
        CaseStruct result = null;
        if (!this.associateSet) {
            return null;
        }
        Iterator iter = this.wildCardSet.iterator();
        while (iter.hasNext()) {
            String fromViewId = (String)iter.next();
            if (viewId.indexOf(fromViewId, 0) == -1) continue;
            String wcFromViewId = fromViewId + '*';
            List caseList = (List)this.caseListMap.get(wcFromViewId);
            if (caseList == null) {
                return null;
            }
            result = this.determineViewFromActionOutcome(caseList, fromAction, outcome);
            if (result == null) continue;
            break;
        }
        return result;
    }

    private CaseStruct findDefaultMatch(String fromAction, String outcome) {
        if (!this.associateSet) {
            return null;
        }
        List caseList = (List)this.caseListMap.get("*");
        if (caseList == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(caseList, fromAction, outcome);
    }

    private CaseStruct determineViewFromActionOutcome(List caseList, String fromAction, String outcome) {
        CaseStruct result = new CaseStruct();
        int size = caseList.size();
        for (int i = 0; i < size; ++i) {
            ConfigNavigationCase cnc = (ConfigNavigationCase)caseList.get(i);
            String cncFromAction = cnc.getFromAction();
            String fromOutcome = cnc.getFromOutcome();
            String toViewId = cnc.getToViewId();
            if (cncFromAction != null && fromOutcome != null && cncFromAction.equals(fromAction) && fromOutcome.equals(outcome)) {
                result.viewId = toViewId;
                result.navCase = cnc;
                return result;
            }
            if (cncFromAction == null && fromOutcome != null && fromOutcome.equals(outcome)) {
                result.viewId = toViewId;
                result.navCase = cnc;
                return result;
            }
            if (cncFromAction != null && fromOutcome == null && cncFromAction.equals(fromAction)) {
                result.viewId = toViewId;
                result.navCase = cnc;
                return result;
            }
            if (cncFromAction != null || fromOutcome != null) continue;
            result.viewId = toViewId;
            result.navCase = cnc;
            return result;
        }
        return null;
    }

    private static class CaseStruct {
        String viewId;
        ConfigNavigationCase navCase;

        private CaseStruct() {
        }
    }
}

