/*
 * Decompiled with CFR 0.152.
 */
package strawberry.application;

import com.sun.faces.application.ConfigNavigationCase;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import strawberry.application.NavigationRuleAware;

public class NavigationHandlerEx
extends NavigationHandler
implements NavigationRuleAware {
    protected static final Logger log = Logger.getLogger("strawberry.nav");
    protected static final Logger initLog = Logger.getLogger("strawberry.init");
    private Map caseListMap;
    private Set wildCardSet;
    boolean associateSet;

    public void setRule(Map map, Set set) {
        if (map.size() == 0 && set.size() == 0) {
            log.fine("90) map.size() == 0 && set.size() == 0");
        } else {
            log.fine("92) caseListMap = " + map);
            log.fine("93) wildCardSet = " + set);
            this.caseListMap = map;
            this.wildCardSet = set;
            this.associateSet = true;
        }
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        if (context == null) {
            String message = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            message = message + " context " + context;
            throw new NullPointerException(message);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("(131) handleNavigation\u51e6\u7406 fromAction='" + fromAction + "', outcome='" + outcome + "'");
        }
        if (outcome == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("135) No navigation rule found for outcome " + outcome + "and viewId " + context.getViewRoot().getViewId() + " Explicitly remain on the current view ");
            }
            return;
        }
        CaseStruct caseStruct = null;
        if (!outcome.startsWith("/")) {
            caseStruct = this.getViewId(context, fromAction, outcome);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("(148)                 caseStruct = '" + caseStruct + "' \u3067\u3059");
        }
        ExternalContext extContext = context.getExternalContext();
        ViewHandler viewHandler = Util.getViewHandler(context);
        if (caseStruct == null) {
            if (outcome.indexOf("/") >= 0) {
                String newPath = viewHandler.getActionURL(context, outcome);
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Redirecting to path " + newPath + " for outcome " + outcome);
                    }
                    extContext.redirect(newPath);
                }
                catch (IOException ioe) {
                    String message = "Redirect to " + newPath + " failed.";
                    log.severe("169) " + message);
                    throw new FacesException(message, (Throwable)ioe);
                }
                context.responseComplete();
            }
        } else {
            log.config("(168)  caseStruct != null \u3067\u3059\u3002JSF\u6a19\u6e96 \u306e Navigation\u51e6\u7406");
            if (caseStruct.navCase.hasRedirect()) {
                String newPath = viewHandler.getActionURL(context, caseStruct.viewId);
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Redirecting to path " + newPath + " for outcome " + outcome + "and viewId " + caseStruct.viewId);
                    }
                    extContext.redirect(newPath);
                }
                catch (IOException ioe) {
                    String message = "Redirect to " + newPath + " failed.";
                    log.severe("192) " + message);
                    throw new FacesException(message, (Throwable)ioe);
                }
                context.responseComplete();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Response complete for " + caseStruct.viewId);
                }
            } else {
                UIViewRoot newRoot = viewHandler.createView(context, caseStruct.viewId);
                context.setViewRoot(newRoot);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Set new view in FacesContext for " + caseStruct.viewId);
                }
            }
        }
    }

    private CaseStruct getViewId(FacesContext context, String fromAction, String outcome) {
        String viewId = context.getViewRoot().getViewId();
        CaseStruct caseStruct = this.findExactMatch(viewId, fromAction, outcome);
        if (caseStruct == null) {
            log.fine("239) findWildCardMatch -----\u2606");
            caseStruct = this.findWildCardMatch(viewId, fromAction, outcome);
        }
        if (caseStruct == null) {
            log.fine("244) findDefaultMatch -----\u2606");
            caseStruct = this.findDefaultMatch(fromAction, outcome);
        }
        return caseStruct;
    }

    private CaseStruct findExactMatch(String viewId, String fromAction, String outcome) {
        if (!this.associateSet) {
            log.fine("271) return null -----\u2606");
            return null;
        }
        List caseList = (List)this.caseListMap.get(viewId);
        if (caseList == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(caseList, fromAction, outcome);
    }

    private CaseStruct findWildCardMatch(String viewId, String fromAction, String outcome) {
        CaseStruct result = null;
        if (!this.associateSet) {
            log.fine("312) return null -----\u2606");
            return null;
        }
        Iterator iter = this.wildCardSet.iterator();
        while (iter.hasNext()) {
            String fromViewId = (String)iter.next();
            if (viewId.indexOf(fromViewId, 0) == -1) continue;
            String wcFromViewId = fromViewId + '*';
            List caseList = (List)this.caseListMap.get(wcFromViewId);
            if (caseList == null) {
                return null;
            }
            result = this.determineViewFromActionOutcome(caseList, fromAction, outcome);
            if (result == null) continue;
            break;
        }
        return result;
    }

    private CaseStruct findDefaultMatch(String fromAction, String outcome) {
        if (!this.associateSet) {
            log.fine("373) return null -----\u2606");
            return null;
        }
        List caseList = (List)this.caseListMap.get("*");
        if (caseList == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(caseList, fromAction, outcome);
    }

    private CaseStruct determineViewFromActionOutcome(List caseList, String fromAction, String outcome) {
        CaseStruct result = new CaseStruct();
        int size = caseList.size();
        for (int i = 0; i < size; ++i) {
            ConfigNavigationCase cnc = (ConfigNavigationCase)caseList.get(i);
            String cncFromAction = cnc.getFromAction();
            String fromOutcome = cnc.getFromOutcome();
            String toViewId = cnc.getToViewId();
            if (cncFromAction != null && fromOutcome != null && cncFromAction.equals(fromAction) && fromOutcome.equals(outcome)) {
                result.viewId = toViewId;
                result.navCase = cnc;
                return result;
            }
            if (cncFromAction == null && fromOutcome != null && fromOutcome.equals(outcome)) {
                result.viewId = toViewId;
                result.navCase = cnc;
                return result;
            }
            if (cncFromAction != null && fromOutcome == null && cncFromAction.equals(fromAction)) {
                result.viewId = toViewId;
                result.navCase = cnc;
                return result;
            }
            if (cncFromAction != null || fromOutcome != null) continue;
            result.viewId = toViewId;
            result.navCase = cnc;
            return result;
        }
        return null;
    }

    private static class CaseStruct {
        String viewId;
        ConfigNavigationCase navCase;

        private CaseStruct() {
        }
    }
}

