/*
 * Decompiled with CFR 0.152.
 */
package strawberry.application;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class I18n {
    protected static final Logger log = Logger.getLogger("strawberry.application");

    private I18n() {
    }

    public static String substituteParams(Locale locale, String msgtext, Object[] params) {
        String localizedStr = null;
        if (params == null || msgtext == null) {
            return msgtext;
        }
        StringBuffer b = new StringBuffer(100);
        MessageFormat mf = new MessageFormat(msgtext);
        if (locale != null) {
            mf.setLocale(locale);
            b.append(mf.format(params));
            localizedStr = b.toString();
        }
        return localizedStr;
    }

    public static String getLogMessage(String messageId, Object[] params) {
        Locale locale = Locale.getDefault();
        return I18n.getLogMessage(locale, messageId, params);
    }

    public static String getLogMessage(Locale locale, String messageId, Object[] params) {
        String summary = null;
        String bundleName = "strawberry.LogMessages";
        ResourceBundle bundle = null;
        if (log.isLoggable(Level.FINE)) {
            log.fine("(145)locale = " + locale);
        }
        if (null != bundleName && null != (bundle = ResourceBundle.getBundle(bundleName, locale, I18n.getCurrentLoader(bundleName)))) {
            try {
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return I18n.substituteParams(locale, summary, params);
    }

    public static String getLogMessage(String messageId) {
        return I18n.getLogMessage(messageId, null);
    }

    public static String getLogMessage(String messageId, Object param0) {
        return I18n.getLogMessage(messageId, new Object[]{param0});
    }

    public static String getLogMessage(String messageId, Object param0, Object param1) {
        return I18n.getLogMessage(messageId, new Object[]{param0, param1});
    }

    protected static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }
}

