/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.util;

import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;

public final class ConcurrentCache {
    private final int size;
    private final Map eden;
    private final Map longterm;

    public ConcurrentCache(int size) {
        this.size = size;
        this.eden = new Hashtable(size);
        this.longterm = new WeakHashMap(size);
    }

    public Object get(Object k) {
        Object v = this.eden.get(k);
        if (v == null && (v = this.longterm.get(k)) != null) {
            this.eden.put(k, v);
        }
        return v;
    }

    public void put(Object k, Object v) {
        if (this.eden.size() >= this.size) {
            this.longterm.putAll(this.eden);
            this.eden.clear();
        }
        this.eden.put(k, v);
    }
}

