/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.lang;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.FunctionMapper;
import org.apache.el.util.ReflectionUtil;

public class FunctionMapperImpl
extends FunctionMapper
implements Externalizable {
    protected static final Logger log = Logger.getLogger("strawberry.el.funmap");
    private static final long serialVersionUID = 1L;
    protected Map functions = null;

    public Method resolveFunction(String prefix, String localName) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("56) resolveFunction   \u767b\u9332\u6570 = " + this.functions.size());
        }
        if (this.functions != null) {
            Function f = (Function)this.functions.get(prefix + ":" + localName);
            return f.getMethod();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunction(String prefix, String localName, Method m) {
        if (this.functions == null) {
            this.functions = new HashMap();
        }
        Function f = new Function(prefix, localName, m);
        FunctionMapperImpl functionMapperImpl = this;
        synchronized (functionMapperImpl) {
            this.functions.put(prefix + ":" + localName, f);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        log.fine("writeExternal");
        out.writeObject(this.functions);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        log.fine("readExternal");
        this.functions = (Map)in.readObject();
    }

    public static class Function
    implements Externalizable {
        protected transient Method m;
        protected String owner;
        protected String name;
        protected String[] types;
        protected String prefix;
        protected String localName;

        public Function(String prefix, String localName, Method m) {
            if (localName == null) {
                throw new NullPointerException("LocalName cannot be null");
            }
            if (m == null) {
                throw new NullPointerException("Method cannot be null");
            }
            this.prefix = prefix;
            this.localName = localName;
            this.m = m;
        }

        public Function() {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.prefix != null ? this.prefix : "");
            out.writeUTF(this.localName);
            out.writeUTF(this.m.getDeclaringClass().getName());
            out.writeUTF(this.m.getName());
            out.writeObject(ReflectionUtil.toTypeNameArray(this.m.getParameterTypes()));
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.prefix = in.readUTF();
            if ("".equals(this.prefix)) {
                this.prefix = null;
            }
            this.localName = in.readUTF();
            this.owner = in.readUTF();
            this.name = in.readUTF();
            this.types = (String[])in.readObject();
        }

        public Method getMethod() {
            if (this.m == null) {
                try {
                    Class<?> t = Class.forName(this.owner);
                    Class[] p = ReflectionUtil.toTypeArray(this.types);
                    this.m = t.getMethod(this.name, p);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.m;
        }

        public boolean matches(String prefix, String localName) {
            if (this.prefix != null) {
                if (prefix == null) {
                    return false;
                }
                if (!this.prefix.equals(prefix)) {
                    return false;
                }
            }
            return this.localName.equals(localName);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Function) {
                return this.hashCode() == obj.hashCode();
            }
            return false;
        }

        public int hashCode() {
            return (this.prefix + this.localName).hashCode();
        }
    }
}

