/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.FunctionMapper;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.el.lang.ELSupport;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.lang.ExpressionBuilder;
import org.apache.el.parser.AstLiteralExpression;
import org.apache.el.parser.Node;
import org.apache.el.util.ReflectionUtil;

public final class ValueExpressionImpl
extends ValueExpression
implements Externalizable {
    protected static final Logger log = Logger.getLogger("strawberry.el.funmap");
    private Class expectedType;
    private String expr;
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;
    private transient Node node;

    public VariableMapper getVariableMapper() {
        return this.varMapper;
    }

    public ValueExpressionImpl() {
    }

    public ValueExpressionImpl(String expr, Node node, FunctionMapper fnMapper, VariableMapper varMapper, Class expectedType) {
        this.expr = expr;
        this.node = node;
        this.fnMapper = fnMapper;
        this.varMapper = varMapper;
        this.expectedType = expectedType;
    }

    public boolean equals(Object obj) {
        log.fine("equals");
        return obj instanceof ValueExpressionImpl && obj.hashCode() == this.hashCode();
    }

    public Class getExpectedType() {
        log.fine("getExpectedType");
        return this.expectedType;
    }

    public String getExpressionString() {
        log.fine("getExpressionString");
        return this.expr;
    }

    private Node getNode() throws ELException {
        log.finer("getNode");
        if (this.node == null) {
            this.node = ExpressionBuilder.createNode(this.expr);
        }
        return this.node;
    }

    public Class getType(ELContext context) throws PropertyNotFoundException, ELException {
        log.fine("getType");
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        return this.getNode().getType(ctx);
    }

    public Object getValue(ELContext context) throws PropertyNotFoundException, ELException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("getValue \u5165\u308a\u307e\u3059, ELContext = " + context);
            log.fine("  hashCode = " + Integer.toHexString(this.hashCode()));
        }
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        Node node = this.getNode();
        if (log.isLoggable(Level.FINE)) {
            log.fine("  node = " + node.getClass().getName());
        }
        Object value = node.getValue(ctx);
        if (this.expectedType != null) {
            log.fine("  coerceToType");
            value = ELSupport.coerceToType(value, this.expectedType);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("  hashCode = " + Integer.toHexString(this.hashCode()) + ", getValue ==> " + value);
        }
        return value;
    }

    public int hashCode() {
        return this.expr.hashCode();
    }

    public boolean isLiteralText() {
        log.fine("isLiteralText");
        try {
            return this.getNode() instanceof AstLiteralExpression;
        }
        catch (ELException ele) {
            return false;
        }
    }

    public boolean isReadOnly(ELContext context) throws PropertyNotFoundException, ELException {
        log.fine("isReadOnly");
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        return this.getNode().isReadOnly(ctx);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        log.fine("readExternal");
        this.expr = in.readUTF();
        String type = in.readUTF();
        if (!"".equals(type)) {
            this.expectedType = ReflectionUtil.forName(type);
        }
        this.fnMapper = (FunctionMapper)in.readObject();
        this.varMapper = (VariableMapper)in.readObject();
    }

    public void setValue(ELContext context, Object value) throws PropertyNotFoundException, PropertyNotWritableException, ELException {
        log.fine("setValue------------");
        EvaluationContext ctx = new EvaluationContext(context, this.fnMapper, this.varMapper);
        this.getNode().setValue(ctx, value);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        log.fine("writeExternal");
        out.writeUTF(this.expr);
        out.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
        out.writeObject(this.fnMapper);
        out.writeObject(this.varMapper);
    }

    public String toString() {
        return "apache.ValueExpressionImpl[" + this.expr + "]@" + Integer.toHexString(this.hashCode());
    }
}

