/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import org.apache.el.ValueExpressionLiteral;
import org.apache.el.lang.ELSupport;
import org.apache.el.lang.ExpressionBuilder;
import org.apache.el.util.MessageFactory;

public class ExpressionFactoryImpl
extends ExpressionFactory {
    protected static final Logger log = Logger.getLogger("strawberry.el.funmap");

    public Object coerceToType(Object obj, Class type) {
        return ELSupport.coerceToType(obj, type);
    }

    public MethodExpression createMethodExpression(ELContext context, String expression, Class expectedReturnType, Class[] expectedParamTypes) {
        if (expectedParamTypes == null) {
            throw new NullPointerException(MessageFactory.get("error.method.nullParms"));
        }
        ExpressionBuilder builder = new ExpressionBuilder(expression, context);
        return builder.createMethodExpression(expectedReturnType, expectedParamTypes);
    }

    public ValueExpression createValueExpression(ELContext context, String expression, Class expectedType) {
        if (expectedType == null) {
            throw new NullPointerException(MessageFactory.get("error.value.expectedType"));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("79) createValueExpression, expression = " + expression);
            log.fine("80) createValueExpression, expectedType = " + expectedType);
        }
        ExpressionBuilder builder = new ExpressionBuilder(expression, context);
        ValueExpression ve = builder.createValueExpression(expectedType);
        if (log.isLoggable(Level.FINE)) {
            String msg = ve.getClass().getName() + "@";
            msg = msg + Integer.toHexString(ve.hashCode());
            log.fine("86) createValueExpression ===> " + msg + " ------\u2605");
        }
        return ve;
    }

    public ValueExpression createValueExpression(Object instance, Class expectedType) {
        log.fine("93) createValueExpression");
        if (expectedType == null) {
            throw new NullPointerException(MessageFactory.get("error.value.expectedType"));
        }
        return new ValueExpressionLiteral(instance, expectedType);
    }
}

