/*
 * Decompiled with CFR 0.152.
 */
package jsfutil.validator;

import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class FutureValidator
implements Validator,
StateHolder {
    protected static final Logger log = Logger.getLogger("strawberry.FutureValidator");
    public static final String VALIDATOR_ID = "jsfutil.validator.FutureValidator";
    public static final String MAXIMUM_MESSAGE_ID = "jsfutil.validator.FutureValidator.MAXIMUM";
    private int maximum = 0;
    private boolean maximumSet = false;
    private boolean transientValue = true;

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
        this.maximumSet = true;
    }

    public Calendar getTodaysMidnight() {
        GregorianCalendar gc = new GregorianCalendar();
        int startYY = gc.get(1);
        int startMM = gc.get(2);
        int startDD = gc.get(5);
        return new GregorianCalendar(startYY, startMM, startDD);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value != null) {
            log.info("value = " + value + ", " + value.getClass().getName());
            Calendar today = this.getTodaysMidnight();
            this.checkFuture(value, today);
        }
    }

    public void checkFuture(Object value, Calendar today) throws ValidatorException {
        Calendar inputValue;
        if (value instanceof Date) {
            Date input = (Date)value;
            long inputTime = input.getTime();
            long todayTime = today.getTimeInMillis();
            if (todayTime <= inputTime) {
                throw new ValidatorException(new FacesMessage("\u65e5\u4ed8\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059"));
            }
        }
        if (value instanceof Calendar && !today.after(inputValue = (Calendar)value)) {
            throw new ValidatorException(new FacesMessage("\u65e5\u4ed8\u304c\u8aa4\u3063\u3066\u3044\u307e\u3059"));
        }
    }

    public boolean equals(Object otherObj) {
        return otherObj instanceof FutureValidator;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[4];
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }
}

