/*
 * Decompiled with CFR 0.152.
 */
package jsfutil.convert;

import java.math.BigDecimal;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class IntegerConverter
implements Converter {
    protected static final Logger log = Logger.getLogger("strawberry.IntegerConverter");
    public static final String CONVERTER_ID = "jsfutil.Integer";

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return new Integer(0);
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            throw new ConverterException(new FacesMessage("\u6570\u5b57\u5165\u529b"), (Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        String ans = "";
        try {
            if (value instanceof Integer) {
                ans = Integer.toString((Integer)value);
            } else if (value instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)value;
                int iVal = bd.intValue();
                ans = Integer.toString(iVal);
            } else {
                log.warning("value = " + value + " ------------------ \u2605");
            }
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
        return ans;
    }
}

