/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.TreeStructure;
import com.sun.faces.util.Util;
import java.io.PrintStream;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.model.SelectItem;

public class DebugUtil {
    public static boolean keepWaiting = true;
    private static int curDepth = 0;

    public DebugUtil() {
        this.init();
    }

    protected void init() {
    }

    public static void waitForDebugger() {
        while (keepWaiting) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                System.out.println("DebugUtil.waitForDebugger(): Exception: " + e.getMessage());
            }
        }
    }

    private static void indentPrintln(PrintStream out, String str) {
        int i = 0;
        for (i = 0; i < curDepth; ++i) {
            out.print("  ");
        }
        out.print(str + "\n");
    }

    public static void printTree(UIComponent root, PrintStream out) {
        Iterator<Object> it;
        if (null == root) {
            return;
        }
        boolean i = false;
        Object value = null;
        DebugUtil.indentPrintln(out, "id:" + root.getId());
        Iterator items = null;
        SelectItem curItem = null;
        boolean j = false;
        if (root instanceof UISelectOne) {
            items = Util.getSelectItems(null, root);
            DebugUtil.indentPrintln(out, " {");
            while (items.hasNext()) {
                curItem = (SelectItem)items.next();
                DebugUtil.indentPrintln(out, "\t value=" + curItem.getValue() + " label=" + curItem.getLabel() + " description=" + curItem.getDescription());
            }
            DebugUtil.indentPrintln(out, " }");
        } else {
            if (root instanceof ValueHolder) {
                value = ((ValueHolder)root).getValue();
            }
            DebugUtil.indentPrintln(out, "value= " + value);
            it = root.getAttributes().keySet().iterator();
            if (it != null) {
                while (it.hasNext()) {
                    String attrValue = null;
                    String attrName = (String)it.next();
                    Object attrObj = root.getAttributes().get(attrName);
                    if (!(attrValue instanceof String)) {
                        attrValue = attrObj.toString();
                        int at = 0;
                        boolean doTruncate = false;
                        at = attrValue.indexOf("$");
                        if (-1 == at) {
                            at = attrValue.indexOf("@");
                            if (-1 != at) {
                                doTruncate = true;
                            }
                        } else {
                            doTruncate = true;
                        }
                        if (doTruncate) {
                            attrValue = attrValue.substring(0, at);
                        }
                    } else {
                        attrValue = (String)attrObj;
                    }
                    DebugUtil.indentPrintln(out, "attr=" + attrName + " : " + attrValue);
                }
            }
        }
        ++curDepth;
        it = root.getChildren().iterator();
        Iterator facets = root.getFacets().values().iterator();
        while (facets.hasNext()) {
            DebugUtil.printTree((UIComponent)facets.next(), out);
        }
        while (it.hasNext()) {
            DebugUtil.printTree((UIComponent)it.next(), out);
        }
        --curDepth;
    }

    public static void printTree(TreeStructure root, PrintStream out) {
        if (null == root) {
            return;
        }
        boolean i = false;
        Object value = null;
        DebugUtil.indentPrintln(out, "id:" + root.id);
        Object items = null;
        Object curItem = null;
        boolean j = false;
        ++curDepth;
        if (null != root.children) {
            Iterator it = root.children.iterator();
            while (it.hasNext()) {
                DebugUtil.printTree((TreeStructure)it.next(), out);
            }
        }
        --curDepth;
    }
}

