/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class OutputMessageRenderer
extends HtmlBasicRenderer {
    protected static final Logger log = Logger.getLogger("strawberry.rk.RI");

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("End encoding component " + component.getId());
        }
        String currentValue = null;
        String style = (String)component.getAttributes().get("style");
        String styleClass = (String)component.getAttributes().get("styleClass");
        ResponseWriter writer = context.getResponseWriter();
        Util.doAssert(writer != null);
        if (!component.isRendered()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("End encoding component " + component.getId() + " since rendered attribute is set to false");
            }
            return;
        }
        Object currentObj = ((ValueHolder)component).getValue();
        if (currentObj != null) {
            currentValue = currentObj instanceof String ? (String)currentObj : currentObj.toString();
        } else {
            return;
        }
        ArrayList<Object> parameterList = new ArrayList<Object>();
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof UIParameter)) continue;
            parameterList.add(((UIParameter)kid).getValue());
        }
        String message = null;
        message = parameterList.size() > 0 ? MessageFormat.format(currentValue, parameterList.toArray(new Object[parameterList.size()])) : currentValue;
        boolean wroteSpan = false;
        if (null != styleClass || null != style || Util.hasPassThruAttributes(component) || this.shouldWriteIdAttribute(component)) {
            writer.startElement("span", component);
            this.writeIdAttributeIfNecessary(context, writer, component);
            wroteSpan = true;
            if (null != styleClass) {
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            }
            Util.renderPassThruAttributes(writer, component);
            Util.renderBooleanPassThruAttributes(writer, component);
        }
        Boolean escape = Boolean.TRUE;
        Object val = component.getAttributes().get("escape");
        if (val != null) {
            if (val instanceof Boolean) {
                escape = (Boolean)val;
            } else if (val instanceof String) {
                try {
                    escape = Boolean.valueOf((String)val);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        if (escape.booleanValue()) {
            writer.writeText((Object)message, "value");
        } else {
            writer.write(message);
        }
        if (wroteSpan) {
            writer.endElement("span");
        }
    }
}

