/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class LabelRenderer
extends HtmlBasicInputRenderer {
    protected static final Logger log = Logger.getLogger("strawberry.rk.RI");
    private static final String RENDER_END_ELEMENT = "com.sun.faces.RENDER_END_ELEMENT";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Begin decoding component " + component.getId());
        }
        ResponseWriter writer = null;
        String forValue = null;
        String style = (String)component.getAttributes().get("style");
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (!component.isRendered()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        writer = context.getResponseWriter();
        Util.doAssert(writer != null);
        UIComponent forComponent = null;
        String forClientId = null;
        forValue = (String)component.getAttributes().get("for");
        if (forValue != null) {
            forComponent = this.getForComponent(context, forValue, component);
            forClientId = forComponent == null ? this.getForComponentClientId(component, context, forValue) : forComponent.getClientId(context);
        }
        component.getAttributes().put(RENDER_END_ELEMENT, "yes");
        writer.startElement("label", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        if (forClientId != null) {
            writer.writeAttribute("for", (Object)forClientId, "for");
        }
        Util.renderPassThruAttributes(writer, component);
        if (null != styleClass) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.writeText((Object)"\n", null);
        String value = this.getCurrentValue(context, component);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Value to be rendered " + value);
        }
        if (value != null && value.length() != 0) {
            writer.write(value);
        }
        writer.flush();
    }

    public void encodeChildren(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        String render = (String)component.getAttributes().get(RENDER_END_ELEMENT);
        if (render != null && render.equals("yes")) {
            component.getAttributes().remove(RENDER_END_ELEMENT);
            ResponseWriter writer = context.getResponseWriter();
            Util.doAssert(writer != null);
            writer.endElement("label");
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("End encoding component " + component.getId());
        }
    }

    protected String getForComponentClientId(UIComponent component, FacesContext context, String forValue) {
        UIComponent parent;
        String result = null;
        for (parent = component.getParent(); parent != null && !(parent instanceof NamingContainer); parent = parent.getParent()) {
        }
        if (parent == null) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("component " + component.getId() + " must be enclosed inside a form ");
            }
            return result;
        }
        String parentClientId = parent.getClientId(context);
        result = parentClientId + ':' + forValue;
        return result;
    }
}

