/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ImageRenderer
extends HtmlBasicRenderer {
    protected static final Logger log = Logger.getLogger("strawberry.rk.RI");

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String altText;
        ResponseWriter writer = null;
        String styleClass = null;
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Begin encoding component " + component.getId());
        }
        if (!component.isRendered()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        writer = context.getResponseWriter();
        Util.doAssert(writer != null);
        writer.startElement("img", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        writer.writeAttribute("src", (Object)this.src(context, component), "value");
        Util.renderPassThruAttributes(writer, component);
        Util.renderBooleanPassThruAttributes(writer, component);
        styleClass = (String)component.getAttributes().get("styleClass");
        if (null != styleClass) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if ((altText = (String)component.getAttributes().get("alt")) == null) {
            writer.writeAttribute("alt", (Object)"", "alt");
        }
        writer.endElement("img");
        if (log.isLoggable(Level.FINER)) {
            log.finer("End encoding component " + component.getId());
        }
    }

    private String src(FacesContext context, UIComponent component) {
        String value = (String)((UIGraphic)component).getValue();
        if (value == null) {
            return "";
        }
        value = context.getApplication().getViewHandler().getResourceURL(context, value);
        return context.getExternalContext().encodeResourceURL(value);
    }
}

