/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.util.MessageFactory;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;

public abstract class HtmlBasicRenderer
extends Renderer {
    protected static final Logger log = Logger.getLogger("strawberry.ren");
    protected static final Logger applyLog = Logger.getLogger("strawberry.ApplyRequestValuesPhase");
    public static final String SCRIPT_ELEMENT = "script";
    public static final String SCRIPT_LANGUAGE = "language";
    public static final String SCRIPT_TYPE = "type";
    public static final String SCRIPT_LANGUAGE_JAVASCRIPT = "JavaScript";
    public static final String CLEAR_HIDDEN_FIELD_FN_NAME = "clearFormHiddenParams";
    public static final String FORM_CLIENT_ID_ATTR = "com.sun.faces.FORM_CLIENT_ID_ATTR";

    public void addGenericErrorMessage(FacesContext facesContext, UIComponent component, String messageId, String param) {
        Object[] params = new Object[3];
        params[0] = param;
        facesContext.addMessage(component.getClientId(facesContext), MessageFactory.getMessage(facesContext, messageId, params));
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (applyLog.isLoggable(Level.FINE)) {
            applyLog.fine("126) Begin decoding component " + component.getId());
        }
        UIInput uiInput = null;
        if (!(component instanceof UIInput)) {
            if (applyLog.isLoggable(Level.FINE)) {
                applyLog.fine("No decoding necessary since the component " + component.getId() + " is not an instance or a sub class of UIInput");
            }
            return;
        }
        uiInput = (UIInput)component;
        if (Util.componentIsDisabledOnReadonly(component)) {
            if (applyLog.isLoggable(Level.FINE)) {
                applyLog.fine("No decoding necessary since the component " + component.getId() + " is disabled");
            }
            return;
        }
        String clientId = component.getClientId(context);
        Util.doAssert(clientId != null);
        if (applyLog.isLoggable(Level.FINE)) {
            applyLog.fine("155) clientId " + clientId);
        }
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        if (applyLog.isLoggable(Level.FINE)) {
            applyLog.fine("159) requestMap " + requestMap);
        }
        boolean b = requestMap.containsKey(clientId);
        if (applyLog.isLoggable(Level.FINE)) {
            applyLog.fine("165) clientId " + clientId + ", containsKey = " + b);
        }
        if (b) {
            String newValue = (String)requestMap.get(clientId);
            this.setSubmittedValue(component, newValue);
            if (log.isLoggable(Level.FINE)) {
                log.fine("166) new value after decoding" + newValue);
            }
        }
        if (applyLog.isLoggable(Level.FINE)) {
            applyLog.fine("164) End decoding component " + component.getId());
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String currentValue = null;
        ResponseWriter writer = null;
        Object styleClass = null;
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Begin encoding component " + component.getId());
        }
        if (!component.isRendered()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        writer = context.getResponseWriter();
        Util.doAssert(writer != null);
        currentValue = this.getCurrentValue(context, component);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Value to be rendered " + currentValue);
        }
        this.getEndTextToRender(context, component, currentValue);
    }

    protected String getCurrentValue(FacesContext context, UIComponent component) {
        Object submittedValue;
        if (component instanceof UIInput && (submittedValue = ((UIInput)component).getSubmittedValue()) != null) {
            return (String)submittedValue;
        }
        String currentValue = null;
        Object currentObj = this.getValue(component);
        if (currentObj != null) {
            currentValue = this.getFormattedValue(context, component, currentObj);
        }
        return currentValue;
    }

    protected Object getValue(UIComponent component) {
        throw new UnsupportedOperationException();
    }

    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
    }

    protected void setSubmittedValue(UIComponent component, Object value) {
    }

    protected String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        String result = null;
        if (!(component instanceof ValueHolder)) {
            if (currentValue != null) {
                result = currentValue.toString();
            }
            return result;
        }
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null && currentValue == null) {
            return "";
        }
        if (converter == null) {
            if (currentValue instanceof String) {
                return (String)currentValue;
            }
            Class<?> converterType = currentValue.getClass();
            converter = Util.getConverterForClass(converterType, context);
            if (converter == null && currentValue != null) {
                result = currentValue.toString();
                return result;
            }
        }
        if (converter != null) {
            result = converter.getAsString(context, component, currentValue);
            return result;
        }
        Object[] params = new Object[]{currentValue, "null Converter"};
        throw new ConverterException(MessageFactory.getMessage(context, "com.sun.faces.TYPECONVERSION_ERROR", params));
    }

    public String convertClientId(FacesContext context, String clientId) {
        return clientId;
    }

    protected Iterator getMessageIter(FacesContext context, String forComponent, UIComponent component) {
        UIComponent result;
        Iterator messageIter = null;
        messageIter = null != forComponent ? (forComponent.length() == 0 ? context.getMessages(null) : ((result = this.getForComponent(context, forComponent, component)) == null ? Collections.EMPTY_LIST.iterator() : context.getMessages(result.getClientId(context)))) : context.getMessages();
        return messageIter;
    }

    protected UIComponent getForComponent(FacesContext context, String forComponent, UIComponent component) {
        if (null == forComponent || forComponent.length() == 0) {
            return null;
        }
        UIComponent result = null;
        try {
            for (UIComponent currentParent = component; currentParent != null && (result = currentParent.findComponent(forComponent)) == null; currentParent = currentParent.getParent()) {
            }
            if (result == null) {
                result = this.findUIComponentBelow((UIComponent)context.getViewRoot(), forComponent);
            }
        }
        catch (Throwable t) {
            Object[] params = new Object[]{forComponent};
            throw new RuntimeException(Util.getExceptionMessageString("com.sun.faces.COMPONENT_NOT_FOUND_ERROR", params));
        }
        if (result == null && log.isLoggable(Level.WARNING)) {
            log.warning(Util.getExceptionMessageString("com.sun.faces.COMPONENT_NOT_FOUND_IN_VIEW_WARNING", new Object[]{forComponent}));
        }
        return result;
    }

    private UIComponent findUIComponentBelow(UIComponent startPoint, String forComponent) {
        UIComponent retComp = null;
        List children = startPoint.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            UIComponent comp = (UIComponent)children.get(i);
            if (comp instanceof NamingContainer) {
                retComp = comp.findComponent(forComponent);
            }
            if (retComp == null && comp.getChildCount() > 0) {
                retComp = this.findUIComponentBelow(comp, forComponent);
            }
            if (retComp != null) break;
        }
        return retComp;
    }

    protected void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator kids = this.getChildren(component);
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                this.encodeRecursive(context, kid);
            }
        }
        component.encodeEnd(context);
    }

    protected Iterator getChildren(UIComponent component) {
        ArrayList<UIComponent> results = new ArrayList<UIComponent>();
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!kid.isRendered()) continue;
            results.add(kid);
        }
        return results.iterator();
    }

    protected UIComponent getFacet(UIComponent component, String name) {
        UIComponent facet = component.getFacet(name);
        if (facet != null && !facet.isRendered()) {
            facet = null;
        }
        return facet;
    }

    protected boolean shouldWriteIdAttribute(UIComponent component) {
        String id = component.getId();
        return null != id && !id.startsWith("_id");
    }

    protected void writeIdAttributeIfNecessary(FacesContext context, ResponseWriter writer, UIComponent component) {
        block3: {
            if (this.shouldWriteIdAttribute(component)) {
                try {
                    writer.writeAttribute("id", (Object)component.getClientId(context), "id");
                }
                catch (IOException e) {
                    if (!log.isLoggable(Level.FINE)) break block3;
                    log.fine("Can't write ID attribute" + e.getMessage());
                }
            }
        }
    }

    protected Param[] getParamList(FacesContext context, UIComponent command) {
        ArrayList<Param> parameterList = new ArrayList<Param>();
        Iterator kids = command.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof UIParameter)) continue;
            UIParameter uiParam = (UIParameter)kid;
            Object value = uiParam.getValue();
            Param param = new Param(uiParam.getName(), value == null ? null : value.toString());
            parameterList.add(param);
        }
        return parameterList.toArray(new Param[parameterList.size()]);
    }

    protected class Param {
        private String name;
        private String value;

        public Param(String name, String value) {
            this.set(name, value);
        }

        public void set(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

