/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.html_basic.FormRenderer;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.renderkit.html_basic.LinkRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

public class CommandLinkRenderer
extends LinkRenderer {
    protected static final Logger log = Logger.getLogger("strawberry.rk.RI");

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Begin decoding component " + component.getId());
        }
        UICommand command = (UICommand)component;
        if (Util.componentIsDisabledOnReadonly(component)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("No decoding necessary since the component " + component.getId() + " is disabled");
            }
            return;
        }
        String clientId = command.getClientId(context);
        String paramName = this.getHiddenFieldName(context, (UIComponent)command);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestParameterMap.get(paramName);
        if (value == null || value.equals("") || !clientId.equals(value)) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(component);
        component.queueEvent((FacesEvent)actionEvent);
        if (log.isLoggable(Level.FINE)) {
            log.fine("This command resulted in form submission  ActionEvent queued " + actionEvent);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("End decoding component " + component.getId());
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Begin encoding component " + component.getId());
        }
        UICommand command = (UICommand)component;
        Object value = command.getValue();
        if (!command.isRendered()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        Util.doAssert(writer != null);
        String clientId = command.getClientId(context);
        UIForm uiform = this.getMyForm(context, (UIComponent)command);
        if (uiform == null) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("component '" + component.getId() + "' must be enclosed inside a form ");
            }
            if (value != null) {
                writer.write(value.toString());
            }
            return;
        }
        String formClientId = uiform.getClientId(context);
        HtmlBasicRenderer.Param[] paramList = this.getParamList(context, (UIComponent)command);
        StringBuffer sb = new StringBuffer();
        writer.startElement("a", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        writer.writeAttribute("href", (Object)"#", "href");
        Util.renderPassThruAttributes(writer, component, new String[]{"onclick", "target"});
        Util.renderBooleanPassThruAttributes(writer, component);
        sb = new StringBuffer();
        sb.append("clearFormHiddenParams_" + formClientId.replace(':', '_'));
        sb.append("('");
        sb.append(formClientId);
        sb.append("');");
        sb.append("document.forms[");
        sb.append("'");
        sb.append(formClientId);
        sb.append("'");
        sb.append("]['");
        sb.append(this.getHiddenFieldName(context, (UIComponent)command));
        sb.append("'].value='");
        sb.append(clientId);
        sb.append("';");
        int len = paramList.length;
        for (int i = 0; i < len; ++i) {
            sb.append("document.forms[");
            sb.append("'");
            sb.append(formClientId);
            sb.append("'");
            sb.append("]['");
            sb.append(paramList[i].getName());
            sb.append("'].value='");
            sb.append(paramList[i].getValue());
            sb.append("';");
        }
        String target = (String)component.getAttributes().get("target");
        if (target != null && target.trim().length() > 0) {
            sb.append(" document.forms[");
            sb.append("'");
            sb.append(formClientId);
            sb.append("'");
            sb.append("].target='");
            sb.append(target);
            sb.append("';");
        }
        sb.append(" document.forms[");
        sb.append("'");
        sb.append(formClientId);
        sb.append("'");
        sb.append("].submit()");
        sb.append("; return false;");
        writer.writeAttribute("onclick", (Object)sb.toString(), "onclick");
        this.writeCommonLinkAttributes(writer, (UIComponent)command);
        String label = null;
        if (value != null) {
            label = value.toString();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Value to be rendered " + value);
        }
        if (label != null && label.length() != 0) {
            writer.write(label);
        }
        writer.flush();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Begin encoding children " + component.getId());
        }
        if (!component.isRendered()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.encodeBegin(context);
            if (kid.getRendersChildren()) {
                kid.encodeChildren(context);
            }
            kid.encodeEnd(context);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("End encoding children " + component.getId());
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        UICommand command = (UICommand)component;
        if (!command.isRendered()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        Util.doAssert(writer != null);
        if (this.getMyForm(context, component) == null) {
            writer.write(Util.getExceptionMessageString("com.sun.faces.COMMAND_LINK_NO_FORM_MESSAGE"));
            return;
        }
        writer.endElement("a");
        FormRenderer.addNeededHiddenField(context, this.getHiddenFieldName(context, (UIComponent)command));
        HtmlBasicRenderer.Param[] paramList = this.getParamList(context, (UIComponent)command);
        for (int i = 0; i < paramList.length; ++i) {
            FormRenderer.addNeededHiddenField(context, paramList[i].getName());
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("End encoding component " + component.getId());
        }
    }

    protected String getHiddenFieldName(FacesContext context, UIComponent component) {
        UIForm uiform = this.getMyForm(context, component);
        String formClientId = uiform.getClientId(context);
        return formClientId + ':' + "_id" + "cl";
    }

    protected UIForm getMyForm(FacesContext context, UIComponent component) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        return (UIForm)parent;
    }
}

