/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;

public class CheckboxRenderer
extends HtmlBasicInputRenderer {
    protected static final Logger log = Logger.getLogger("strawberry.rk.RI");

    public void decode(FacesContext context, UIComponent component) {
        Object convertedValue = null;
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Begin decoding component " + component.getId());
        }
        if (Util.componentIsDisabledOnReadonly(component)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("No decoding necessary since the component " + component.getId() + " is disabled");
            }
            return;
        }
        String clientId = component.getClientId(context);
        Util.doAssert(clientId != null);
        UIInput uiInput = (UIInput)component;
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestParameterMap.get(clientId);
        if (newValue == null) {
            newValue = "false";
        } else if (newValue.equalsIgnoreCase("on") || newValue.equalsIgnoreCase("yes") || newValue.equalsIgnoreCase("true")) {
            newValue = "true";
        }
        this.setSubmittedValue(component, newValue);
        if (log.isLoggable(Level.FINER)) {
            log.finer("new value after decoding" + newValue);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("End decoding component " + component.getId());
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        String newValue = (String)submittedValue;
        Boolean convertedValue = Boolean.valueOf(newValue);
        return convertedValue;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
    }

    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Util.doAssert(writer != null);
        String styleClass = null;
        writer.startElement("input", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        writer.writeAttribute("type", (Object)"checkbox", "type");
        writer.writeAttribute("name", (Object)component.getClientId(context), "clientId");
        if (currentValue != null && currentValue.equals("true")) {
            writer.writeAttribute("checked", (Object)Boolean.TRUE, "value");
        }
        if (null != (styleClass = (String)component.getAttributes().get("styleClass"))) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        Util.renderPassThruAttributes(writer, component);
        Util.renderBooleanPassThruAttributes(writer, component);
        writer.endElement("input");
    }
}

