/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.renderkit.ApplicationObjectInputStream;
import com.sun.faces.util.Base64;
import com.sun.faces.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ResponseStateManager;

public class ResponseStateManagerImpl
extends ResponseStateManager {
    protected static final Logger log = Logger.getLogger("strawberry.savestate");
    protected static final Logger logRestore = Logger.getLogger("strawberry.restorestate");
    private static final String FACES_VIEW_STATE = "com.sun.faces.FACES_VIEW_STATE";
    private static final String COMPRESS_STATE_PARAM = "com.sun.faces.COMPRESS_STATE";
    private Boolean compressStateSet = null;

    public Object getComponentStateToRestore(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Object state = requestMap.get(FACES_VIEW_STATE);
        requestMap.put(FACES_VIEW_STATE, null);
        return state;
    }

    public Object getTreeStructureToRestore(FacesContext context, String treeId) {
        StateManager stateManager = Util.getStateManager(context);
        Object structure = null;
        Object state = null;
        ByteArrayInputStream bis = null;
        GZIPInputStream gis = null;
        ApplicationObjectInputStream ois = null;
        boolean compress = this.isCompressStateSet(context);
        logRestore.fine("126) compress = " + compress);
        Map requestParamMap = context.getExternalContext().getRequestParameterMap();
        String viewString = (String)requestParamMap.get("com.sun.faces.VIEW");
        if (viewString == null) {
            logRestore.fine("132) com.sun.faces.VIEW\u304c\u306a\u3044\u306e\u3067 return null ");
            return null;
        }
        if (stateManager.isSavingStateInClient(context)) {
            logRestore.fine("136) isSavingStateInClient \u304b\u3089\u5fa9\u5143");
            byte[] bytes = Base64.decode(viewString.getBytes());
            try {
                bis = new ByteArrayInputStream(bytes);
                if (this.isCompressStateSet(context)) {
                    logRestore.fine("(142) \u5727\u7e2e\u89e3\u51cd Deflating state before restoring..");
                    gis = new GZIPInputStream(bis);
                    ois = new ApplicationObjectInputStream(gis);
                } else {
                    ois = new ApplicationObjectInputStream(bis);
                }
                structure = ois.readObject();
                state = ois.readObject();
                Map requestMap = context.getExternalContext().getRequestMap();
                requestMap.put(FACES_VIEW_STATE, state);
                bis.close();
                if (compress) {
                    gis.close();
                }
                ois.close();
            }
            catch (OptionalDataException ode) {
                log.log(Level.SEVERE, ode.getMessage(), ode);
                throw new FacesException((Throwable)ode);
            }
            catch (ClassNotFoundException cnfe) {
                log.log(Level.SEVERE, cnfe.getMessage(), cnfe);
                throw new FacesException((Throwable)cnfe);
            }
            catch (IOException iox) {
                log.log(Level.SEVERE, iox.getMessage(), iox);
                throw new FacesException((Throwable)iox);
            }
        } else {
            log.fine("171) ! isSavingStateInClient");
            structure = viewString;
        }
        if (logRestore.isLoggable(Level.FINE)) {
            logRestore.fine("\u5fa9\u5143\u3055\u308c\u305fstructure = " + structure);
            logRestore.fine("\u5fa9\u5143\u3055\u308c\u305fstate = " + state);
        }
        return structure;
    }

    public void writeState(FacesContext context, StateManager.SerializedView view) throws IOException {
        StateManager stateManager = Util.getStateManager(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", (UIComponent)context.getViewRoot());
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)"com.sun.faces.VIEW", null);
        writer.writeAttribute("id", (Object)"com.sun.faces.VIEW", null);
        if (stateManager.isSavingStateInClient(context)) {
            log.fine("194) isSavingStateInClient");
            GZIPOutputStream zos = null;
            ObjectOutputStream oos = null;
            boolean compress = this.isCompressStateSet(context);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (compress) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("(202) Compressing state before saving..");
                }
                zos = new GZIPOutputStream(bos);
                oos = new ObjectOutputStream(zos);
            } else {
                oos = new ObjectOutputStream(bos);
            }
            oos.writeObject(view.getStructure());
            oos.writeObject(view.getState());
            oos.close();
            if (compress) {
                zos.close();
            }
            bos.close();
            String valueToWrite = new String(Base64.encode(bos.toByteArray()), "ISO-8859-1");
            writer.writeAttribute("value", (Object)valueToWrite, null);
        } else {
            log.fine("222) ! isSavingStateInClient");
            writer.writeAttribute("value", view.getStructure(), null);
        }
        writer.endElement("input");
    }

    public void writeState(FacesContext context, StateManager.SerializedView view, ResponseWriter writer) throws IOException {
        StateManager stateManager = Util.getStateManager(context);
        writer.startElement("input", (UIComponent)context.getViewRoot());
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)"com.sun.faces.VIEW", null);
        writer.writeAttribute("id", (Object)"com.sun.faces.VIEW", null);
        if (stateManager.isSavingStateInClient(context)) {
            log.fine("242) isSavingStateInClient");
            GZIPOutputStream zos = null;
            ObjectOutputStream oos = null;
            boolean compress = this.isCompressStateSet(context);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (compress) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("(250) Compressing state before saving..");
                }
                zos = new GZIPOutputStream(bos);
                oos = new ObjectOutputStream(zos);
            } else {
                oos = new ObjectOutputStream(bos);
            }
            oos.writeObject(view.getStructure());
            oos.writeObject(view.getState());
            oos.close();
            if (compress) {
                zos.close();
            }
            bos.close();
            String valueToWrite = new String(Base64.encode(bos.toByteArray()), "ISO-8859-1");
            writer.writeAttribute("value", (Object)valueToWrite, null);
        } else {
            log.fine("270) ! isSavingStateInClient");
            writer.writeAttribute("value", view.getStructure(), null);
        }
        writer.endElement("input");
    }

    protected String replaceMarkers(String response, String marker, String hiddenField) {
        int markerIdx = response.indexOf(marker);
        while (markerIdx != -1) {
            String replacedContent = response.substring(0, markerIdx);
            int markerEnd = markerIdx + marker.length();
            String endPortion = response.substring(markerEnd, response.length());
            replacedContent = replacedContent.concat(hiddenField);
            response = replacedContent = replacedContent.concat(endPortion);
            markerIdx = response.indexOf(marker);
        }
        return response;
    }

    public boolean isCompressStateSet(FacesContext context) {
        if (null != this.compressStateSet) {
            return this.compressStateSet;
        }
        this.compressStateSet = Boolean.TRUE;
        String compressStateParam = context.getExternalContext().getInitParameter(COMPRESS_STATE_PARAM);
        if (compressStateParam != null) {
            this.compressStateSet = Boolean.valueOf(compressStateParam);
        }
        return this.compressStateSet;
    }
}

