/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.BeanInfoIndexedProperty;
import com.sun.faces.el.impl.BeanInfoProperty;
import com.sun.faces.el.impl.Constants;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.MessageUtil;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BeanInfoManager {
    protected static final Logger log = Logger.getLogger("strawberry.BeanInfoManager");
    Class mBeanClass;
    BeanInfo mBeanInfo;
    Map mPropertyByName;
    Map mIndexedPropertyByName;
    Map mEventSetByName;
    boolean mInitialized;
    static Map mBeanInfoManagerByClass = new HashMap();

    public Class getBeanClass() {
        return this.mBeanClass;
    }

    BeanInfoManager(Class pBeanClass) {
        this.mBeanClass = pBeanClass;
    }

    public static BeanInfoManager getBeanInfoManager(Class pClass) {
        BeanInfoManager ret = (BeanInfoManager)mBeanInfoManagerByClass.get(pClass);
        if (ret == null) {
            ret = BeanInfoManager.createBeanInfoManager(pClass);
        }
        return ret;
    }

    static synchronized BeanInfoManager createBeanInfoManager(Class pClass) {
        BeanInfoManager ret = (BeanInfoManager)mBeanInfoManagerByClass.get(pClass);
        if (ret == null) {
            ret = new BeanInfoManager(pClass);
            mBeanInfoManagerByClass.put(pClass, ret);
        }
        return ret;
    }

    public static BeanInfoProperty getBeanInfoProperty(Class pClass, String pPropertyName) throws ElException {
        return BeanInfoManager.getBeanInfoManager(pClass).getProperty(pPropertyName);
    }

    public static BeanInfoIndexedProperty getBeanInfoIndexedProperty(Class pClass, String pIndexedPropertyName) throws ElException {
        return BeanInfoManager.getBeanInfoManager(pClass).getIndexedProperty(pIndexedPropertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkInitialized() throws ElException {
        if (!this.mInitialized) {
            BeanInfoManager beanInfoManager = this;
            synchronized (beanInfoManager) {
                if (!this.mInitialized) {
                    this.initialize();
                    this.mInitialized = true;
                }
            }
        }
    }

    void initialize() throws ElException {
        block5: {
            try {
                this.mBeanInfo = Introspector.getBeanInfo(this.mBeanClass);
                this.mPropertyByName = new HashMap();
                this.mIndexedPropertyByName = new HashMap();
                PropertyDescriptor[] pds = this.mBeanInfo.getPropertyDescriptors();
                for (int i = 0; pds != null && i < pds.length; ++i) {
                    PropertyDescriptor pd = pds[i];
                    if (pd instanceof IndexedPropertyDescriptor) {
                        IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                        Method readMethod = BeanInfoManager.getPublicMethod(ipd.getIndexedReadMethod());
                        Method writeMethod = BeanInfoManager.getPublicMethod(ipd.getIndexedWriteMethod());
                        BeanInfoIndexedProperty property = new BeanInfoIndexedProperty(readMethod, writeMethod, ipd);
                        this.mIndexedPropertyByName.put(ipd.getName(), property);
                    }
                    Method readMethod = BeanInfoManager.getPublicMethod(pd.getReadMethod());
                    Method writeMethod = BeanInfoManager.getPublicMethod(pd.getWriteMethod());
                    BeanInfoProperty property = new BeanInfoProperty(readMethod, writeMethod, pd);
                    this.mPropertyByName.put(pd.getName(), property);
                }
                this.mEventSetByName = new HashMap();
                EventSetDescriptor[] esds = this.mBeanInfo.getEventSetDescriptors();
                for (int i = 0; esds != null && i < esds.length; ++i) {
                    EventSetDescriptor esd = esds[i];
                    this.mEventSetByName.put(esd.getName(), esd);
                }
            }
            catch (IntrospectionException exc) {
                if (!log.isLoggable(Level.WARNING)) break block5;
                log.log(Level.WARNING, MessageUtil.getMessageWithArgs(Constants.EXCEPTION_GETTING_BEANINFO, this.mBeanClass.getName()), exc);
            }
        }
    }

    BeanInfo getBeanInfo() throws ElException {
        this.checkInitialized();
        return this.mBeanInfo;
    }

    public BeanInfoProperty getProperty(String pPropertyName) throws ElException {
        this.checkInitialized();
        return (BeanInfoProperty)this.mPropertyByName.get(pPropertyName);
    }

    public BeanInfoIndexedProperty getIndexedProperty(String pIndexedPropertyName) throws ElException {
        this.checkInitialized();
        return (BeanInfoIndexedProperty)this.mIndexedPropertyByName.get(pIndexedPropertyName);
    }

    public EventSetDescriptor getEventSet(String pEventSetName) throws ElException {
        this.checkInitialized();
        return (EventSetDescriptor)this.mEventSetByName.get(pEventSetName);
    }

    static Method getPublicMethod(Method pMethod) {
        if (pMethod == null) {
            return null;
        }
        Class<?> cl = pMethod.getDeclaringClass();
        if (Modifier.isPublic(cl.getModifiers())) {
            return pMethod;
        }
        Method ret = BeanInfoManager.getPublicMethod(cl, pMethod);
        if (ret != null) {
            return ret;
        }
        return pMethod;
    }

    static Method getPublicMethod(Class pClass, Method pMethod) {
        Method m;
        Class superclass;
        Class<?>[] interfaces;
        if (Modifier.isPublic(pClass.getModifiers())) {
            try {
                Method m2;
                try {
                    m2 = pClass.getDeclaredMethod(pMethod.getName(), pMethod.getParameterTypes());
                }
                catch (AccessControlException ex) {
                    m2 = pClass.getMethod(pMethod.getName(), pMethod.getParameterTypes());
                }
                if (Modifier.isPublic(m2.getModifiers())) {
                    return m2;
                }
            }
            catch (NoSuchMethodException exc) {
                // empty catch block
            }
        }
        if ((interfaces = pClass.getInterfaces()) != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                Method m3 = BeanInfoManager.getPublicMethod(interfaces[i], pMethod);
                if (m3 == null) continue;
                return m3;
            }
        }
        if ((superclass = pClass.getSuperclass()) != null && (m = BeanInfoManager.getPublicMethod(superclass, pMethod)) != null) {
            return m;
        }
        return null;
    }
}

