/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.commons.collections.CursorableLinkedList;

public class FacesContextImpl
extends FacesContext {
    protected static final Logger log = Logger.getLogger("strawberry.ctx.faces");
    protected static final Logger logRen = Logger.getLogger("strawberry.ren");
    protected static final Logger lifecycleLog = Logger.getLogger("strawberry.lifecycle");
    private boolean released;
    private ResponseStream responseStream = null;
    private ResponseWriter responseWriter = null;
    private CursorableLinkedList facesEvents = null;
    private ExternalContext externalContext = null;
    private Application application = null;
    private UIViewRoot viewRoot = null;
    private RenderKitFactory rkFactory;
    private RenderKit lastRk;
    private String lastRkId;
    private Map componentMessageLists;
    private boolean renderResponse = false;
    private boolean responseComplete = false;
    private ELContext elContext = null;

    public FacesContextImpl() {
    }

    public FacesContextImpl(ExternalContext ec, RenderKitFactory rkf, Application app) {
        if (null == ec) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        this.externalContext = ec;
        FacesContextImpl.setCurrentInstance((FacesContext)this);
        this.rkFactory = rkf;
        this.application = app;
    }

    public void setRenderKitFactory(RenderKitFactory newValue) {
        this.rkFactory = newValue;
    }

    public RenderKitFactory getRenderKitFactory() {
        return this.rkFactory;
    }

    public ExternalContext getExternalContext() {
        this.assertNotReleased();
        return this.externalContext;
    }

    public Application getApplication() {
        this.assertNotReleased();
        if (null != this.application) {
            return this.application;
        }
        return this.application;
    }

    public void setApplication(Application newValue) {
        this.application = newValue;
    }

    public Iterator getClientIdsWithMessages() {
        this.assertNotReleased();
        Iterator<Object> result = null;
        result = null == this.componentMessageLists ? Collections.EMPTY_LIST.iterator() : this.componentMessageLists.keySet().iterator();
        return result;
    }

    public Iterator getFacesEvents() {
        this.assertNotReleased();
        if (this.facesEvents != null) {
            return this.facesEvents.cursor();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public FacesMessage.Severity getMaximumSeverity() {
        this.assertNotReleased();
        int max = 0;
        FacesMessage.Severity result = null;
        if (null == this.componentMessageLists) {
            return null;
        }
        List messages = this.getMergedMessageLists();
        int size = this.getMergedMessageLists().size();
        for (int i = 0; i < size; ++i) {
            result = ((FacesMessage)messages.get(i)).getSeverity();
            if (result.getOrdinal() > max) {
                max = result.getOrdinal();
            }
            if (result == FacesMessage.SEVERITY_FATAL) break;
        }
        return result;
    }

    public Iterator getMessages() {
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            return Collections.EMPTY_LIST.iterator();
        }
        List messages = this.getMergedMessageLists();
        if (messages.size() > 0) {
            return messages.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getMessages(String clientId) {
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            return Collections.EMPTY_LIST.iterator();
        }
        List list = (List)this.componentMessageLists.get(clientId);
        if (list == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return list.iterator();
    }

    public RenderKit getRenderKit() {
        this.assertNotReleased();
        UIViewRoot vr = this.getViewRoot();
        if (vr == null) {
            log.fine("235) return null");
            return null;
        }
        String renderKitId = vr.getRenderKitId();
        if (renderKitId == null) {
            log.severe("240) UIViewRoot.getRenderKitId() == null \u306a\u306e\u3067\u3001RenderKit\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093  ");
            throw new NullPointerException();
        }
        if (renderKitId.equals(this.lastRkId)) {
            log.finer("245) return lastRk");
            return this.lastRk;
        }
        log.fine("248) return getRenderKit(" + renderKitId + ")");
        this.lastRk = this.rkFactory.getRenderKit((FacesContext)this, renderKitId);
        this.lastRkId = renderKitId;
        return this.lastRk;
    }

    public ResponseStream getResponseStream() {
        this.assertNotReleased();
        return this.responseStream;
    }

    public void setResponseStream(ResponseStream newResponseStream) {
        this.assertNotReleased();
        if (newResponseStream == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_RESPONSE_STREAM_ERROR"));
        }
        this.responseStream = newResponseStream;
    }

    public UIViewRoot getViewRoot() {
        this.assertNotReleased();
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot root) {
        this.assertNotReleased();
        if (root == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (this.viewRoot != root) {
            this.facesEvents = null;
        }
        this.viewRoot = root;
    }

    public ResponseWriter getResponseWriter() {
        this.assertNotReleased();
        return this.responseWriter;
    }

    private String _print(ResponseWriter rw) {
        return rw.getClass().getName() + "@" + Integer.toHexString(rw.hashCode());
    }

    public void setResponseWriter(ResponseWriter newResponseWriter) {
        this.assertNotReleased();
        if (newResponseWriter == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_RESPONSE_WRITER_ERROR"));
        }
        log.info("setResponseWriter <= " + this._print(newResponseWriter));
        this.responseWriter = newResponseWriter;
    }

    public void addFacesEvent(FacesEvent event) {
        this.assertNotReleased();
        if (event == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_EVENT_ERROR"));
        }
        if (this.facesEvents == null) {
            this.facesEvents = new CursorableLinkedList();
            log.info("--------------------- commons.collection \u306e\u6a5f\u80fd\u3092\u4f7f\u3044\u307e\u3057\u305f");
        }
        this.facesEvents.add((Object)event);
        if (log.isLoggable(Level.FINE)) {
            String id = event.getComponent().getId();
            if (id == null) {
                id = "<<NONE>>";
            }
            log.fine("Adding FacesEvent[sourceId=" + id + ",type=" + event.getClass().getName());
        }
    }

    public void addMessage(String clientId, FacesMessage message) {
        ArrayList<FacesMessage> list;
        this.assertNotReleased();
        if (null == message) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (this.componentMessageLists == null) {
            this.componentMessageLists = new HashMap();
        }
        if ((list = (ArrayList<FacesMessage>)this.componentMessageLists.get(clientId)) == null) {
            list = new ArrayList<FacesMessage>();
            this.componentMessageLists.put(clientId, list);
        }
        list.add(message);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding Message[sourceId=" + (clientId != null ? clientId : "<<NONE>>") + ",summary=" + message.getSummary() + ")");
        }
    }

    public void release() {
        this.released = true;
        this.externalContext = null;
        this.responseStream = null;
        this.responseWriter = null;
        this.facesEvents = null;
        this.componentMessageLists = null;
        this.renderResponse = false;
        this.responseComplete = false;
        this.viewRoot = null;
        this.elContext = null;
        FacesContextImpl.setCurrentInstance(null);
    }

    public void renderResponse() {
        lifecycleLog.fine("responseComplete called ------------------- **");
        this.assertNotReleased();
        this.renderResponse = true;
    }

    public void responseComplete() {
        lifecycleLog.fine("responseComplete called ------------------- **");
        this.assertNotReleased();
        this.responseComplete = true;
    }

    public boolean getRenderResponse() {
        this.assertNotReleased();
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        this.assertNotReleased();
        return this.responseComplete;
    }

    private void assertNotReleased() {
        if (this.released) {
            throw new IllegalStateException();
        }
    }

    private List getMergedMessageLists() {
        ArrayList mergedList = new ArrayList();
        if (this.componentMessageLists != null) {
            Iterator i = this.componentMessageLists.values().iterator();
            while (i.hasNext()) {
                Iterator ii = ((ArrayList)i.next()).iterator();
                while (ii.hasNext()) {
                    mergedList.add(ii.next());
                }
            }
        }
        return mergedList;
    }

    public ELContext getELContext() {
        this.assertNotReleased();
        if (this.elContext == null) {
            // empty if block
        }
        return this.elContext;
    }

    public void setELContext(ELContext elc) {
        this.elContext = elc;
    }
}

