/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.beans.ListEntriesBean;
import com.sun.faces.config.beans.ManagedBeanBean;
import com.sun.faces.config.beans.ManagedPropertyBean;
import com.sun.faces.config.beans.MapEntriesBean;
import com.sun.faces.config.beans.MapEntryBean;
import com.sun.faces.context.FacesContextImpl;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.beans.Beans;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import org.apache.commons.beanutils.PropertyUtils;

public class ManagedBeanFactory {
    protected static final Logger log = Logger.getLogger("strawberry.ManagedBeanFactory");
    private static Map scopeMap = null;
    protected static final int TYPE_IS_LIST = 0;
    protected static final int TYPE_IS_MAP = 1;
    protected static final int TYPE_IS_BEAN = 2;
    protected static final int TYPE_IS_UICOMPONENT = 3;
    private static final int TYPE_IS_SIMPLE = 3;
    protected static final String MANAGED_BEAN_CREATED_STACK = "com.sun.faces.managedBeanStack";
    ManagedBeanBean managedBean;
    String scope;
    private Map managedBeanFactoryMap = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;

    public ManagedBeanBean getManagedBeanBean() {
        return this.managedBean;
    }

    public ManagedBeanFactory() {
        if (null == scopeMap) {
            scopeMap = new HashMap();
            scopeMap.put("request", new Integer(1));
            scopeMap.put("session", new Integer(2));
            scopeMap.put("application", new Integer(3));
        }
    }

    public ManagedBeanFactory(ManagedBeanBean managedBean) {
        this.managedBean = managedBean;
        this.scope = managedBean.getManagedBeanScope();
        if (null == scopeMap) {
            scopeMap = new HashMap();
            scopeMap.put("request", new Integer(1));
            scopeMap.put("session", new Integer(2));
            scopeMap.put("application", new Integer(3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManagedBeanBean(ManagedBeanBean newBean) {
        ManagedBeanFactory managedBeanFactory = this;
        synchronized (managedBeanFactory) {
            this.managedBean = newBean;
            this.scope = this.managedBean.getManagedBeanScope();
        }
    }

    public Map getManagedBeanFactoryMap() {
        if (null == this.managedBeanFactoryMap && log.isLoggable(Level.FINE)) {
            log.fine("Contract violation: ManagedBeanFactory must be initialized with managedBeanFactoryMap after instantiation.");
        }
        return this.managedBeanFactoryMap;
    }

    public void setManagedBeanFactoryMap(Map newManagedBeanFactoryMap) {
        this.managedBeanFactoryMap = newManagedBeanFactoryMap;
    }

    public Object newInstance(FacesContext context) throws FacesException {
        Object bean = null;
        int beanType = -1;
        Map requestMap = context.getExternalContext().getRequestMap();
        ArrayList<String> beanList = (ArrayList<String>)requestMap.get(MANAGED_BEAN_CREATED_STACK);
        if (beanList == null) {
            beanList = new ArrayList<String>();
            requestMap.put(MANAGED_BEAN_CREATED_STACK, beanList);
        }
        if (beanList.contains(this.managedBean.getManagedBeanName())) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("Possible cyclic reference to managedBean " + this.managedBean.getManagedBeanName() + " ");
            }
            Object[] obj = new Object[]{this.managedBean.getManagedBeanName()};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CYCLIC_REFERENCE_ERROR", obj));
        }
        try {
            bean = this.createBeanInstance(this.managedBean.getManagedBeanClass(), context);
        }
        catch (Exception ex) {
            Object[] obj = new Object[]{this.managedBean.getManagedBeanClass(), this.managedBean.getManagedBeanName()};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", obj) + ". " + ex.getMessage(), (Throwable)ex);
        }
        beanList.add(this.managedBean.getManagedBeanName());
        try {
            beanType = this.getBeanType(bean);
            switch (beanType) {
                case 0: {
                    this.copyListEntriesFromConfigToList(this.managedBean.getListEntries(), (List)bean);
                    break;
                }
                case 1: {
                    this.copyMapEntriesFromConfigToMap(this.managedBean.getMapEntries(), (Map)bean);
                    break;
                }
                case 2: 
                case 3: {
                    this.setPropertiesIntoBean(bean, beanType, this.managedBean);
                    break;
                }
                default: {
                    Util.doAssert(false);
                    break;
                }
            }
        }
        catch (FacesException fe) {
            throw fe;
        }
        catch (ClassNotFoundException cnfe) {
            Object[] obj = new Object[]{this.managedBean.getManagedBeanClass()};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", obj), (Throwable)cnfe);
        }
        beanList.remove(this.managedBean.getManagedBeanName());
        return bean;
    }

    protected Object createBeanInstance(String className, FacesContext context) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = FacesContext.getCurrentInstance().getClass().getClassLoader();
        }
        Object bean = Beans.instantiate(loader, className);
        return bean;
    }

    protected int getBeanType(Object bean) {
        int result = -1;
        ListEntriesBean listEntries = null;
        MapEntriesBean mapEntries = null;
        listEntries = this.managedBean.getListEntries();
        if (null != listEntries) {
            if (null != this.managedBean.getMapEntries() || null != this.managedBean.getManagedProperties() && this.managedBean.getManagedProperties().length > 0) {
                Object[] obj = new Object[]{this.managedBean.getManagedBeanClass()};
                throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", obj));
            }
            result = 0;
        }
        if (null != (mapEntries = this.managedBean.getMapEntries())) {
            Util.doAssert(-1 == result);
            if (null != this.managedBean.getListEntries() || null != this.managedBean.getManagedProperties() && this.managedBean.getManagedProperties().length > 0) {
                Object[] obj = new Object[]{this.managedBean.getManagedBeanClass()};
                throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", obj));
            }
            result = 1;
        }
        if (0 != result && 1 != result) {
            Util.doAssert(-1 == result);
            result = bean instanceof UIComponent ? 3 : 2;
        }
        Util.doAssert(-1 != result);
        return result;
    }

    protected int getPropertyType(ManagedPropertyBean bean) {
        int result = -1;
        ListEntriesBean listEntries = null;
        MapEntriesBean mapEntries = null;
        listEntries = bean.getListEntries();
        if (null != listEntries) {
            if (null != bean.getMapEntries() || null != bean.getValue() || bean.isNullValue()) {
                Object[] obj = new Object[]{bean.getPropertyName()};
                throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", obj));
            }
            result = 0;
        }
        if (null != (mapEntries = bean.getMapEntries())) {
            Util.doAssert(-1 == result);
            if (null != bean.getListEntries() || null != bean.getValue() || bean.isNullValue()) {
                Object[] obj = new Object[]{bean.getPropertyName()};
                throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", obj));
            }
            result = 1;
        }
        if (0 != result && 1 != result) {
            Util.doAssert(-1 == result);
            if (null != bean.getValue() || bean.isNullValue()) {
                result = 3;
            }
        }
        if (-1 == result && !bean.isNullValue()) {
            Object[] obj = new Object[]{bean.getPropertyName()};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", obj));
        }
        return result;
    }

    protected Class copyListEntriesFromConfigToList(ListEntriesBean listEntries, List valuesForBean) throws ClassNotFoundException {
        String[] valuesFromConfig = listEntries.getValues();
        Class valueClass = class$java$lang$String == null ? (class$java$lang$String = ManagedBeanFactory.class$("java.lang.String")) : class$java$lang$String;
        Object value = null;
        String strValue = null;
        int len = 0;
        len = valuesFromConfig.length;
        if (0 == len) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("zero length array");
            }
            return null;
        }
        valueClass = this.getValueClassConsideringPrimitives(listEntries.getValueClass());
        for (int i = 0; i < len; ++i) {
            strValue = valuesFromConfig[i];
            value = Util.isVBExpression(strValue) ? this.evaluateValueBindingGet(strValue) : (null == strValue ? null : strValue);
            value = this.getConvertedValueConsideringPrimitives(value, valueClass);
            valuesForBean.add(value);
        }
        return valueClass;
    }

    void copyMapEntriesFromConfigToMap(MapEntriesBean mapEntries, Map result) throws ClassNotFoundException {
        Object key = null;
        Object value = null;
        MapEntryBean[] valuesFromConfig = mapEntries.getMapEntries();
        MapEntryBean curEntry = null;
        Class keyClass = class$java$lang$String == null ? (class$java$lang$String = ManagedBeanFactory.class$("java.lang.String")) : class$java$lang$String;
        Class valueClass = class$java$lang$String == null ? (class$java$lang$String = ManagedBeanFactory.class$("java.lang.String")) : class$java$lang$String;
        String strKey = null;
        String strValue = null;
        if (null == mapEntries || 0 == valuesFromConfig.length) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("null or zero length array");
            }
            return;
        }
        keyClass = this.getValueClassConsideringPrimitives(mapEntries.getKeyClass());
        valueClass = this.getValueClassConsideringPrimitives(mapEntries.getValueClass());
        int len = valuesFromConfig.length;
        for (int i = 0; i < len; ++i) {
            curEntry = valuesFromConfig[i];
            strKey = curEntry.getKey();
            strValue = curEntry.getValue();
            key = Util.isVBExpression(strKey) ? this.evaluateValueBindingGet(strKey) : (null == strKey ? null : this.getConvertedValueConsideringPrimitives(strKey, keyClass));
            value = Util.isVBExpression(strValue) ? this.evaluateValueExpressionGet(strValue) : (null == strValue ? null : this.getConvertedValueConsideringPrimitives(strValue, valueClass));
            result.put(key, value);
        }
    }

    protected void setPropertiesIntoBean(Object bean, int beanType, ManagedBeanBean managedBean) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("(537) setPropertiesIntoBean ----\u5165\u308a\u307e\u3059 \u203b" + managedBean.getManagedBeanName());
        }
        Object value = null;
        String propertyClass = null;
        String propertyName = null;
        String strValue = null;
        int propertyType = -1;
        Class valueClass = null;
        ManagedPropertyBean[] properties = managedBean.getManagedProperties();
        if (null == properties) {
            return;
        }
        int len = properties.length;
        for (int i = 0; i < len; ++i) {
            if (null == properties[i] || null == (propertyName = properties[i].getPropertyName())) continue;
            try {
                propertyType = this.getPropertyType(properties[i]);
                switch (propertyType) {
                    case 0: {
                        log.fine("(558) ================== TYPE_IS_LIST");
                        this.setArrayOrListPropertiesIntoBean(bean, properties[i]);
                        break;
                    }
                    case 1: {
                        log.fine("(562) ================== TYPE_IS_MAP");
                        this.setMapPropertiesIntoBean(bean, properties[i]);
                        break;
                    }
                    case 3: {
                        log.finest("(566) ================== ");
                        propertyClass = properties[i].getPropertyClass();
                        if (null == propertyClass) {
                            valueClass = PropertyUtils.getPropertyType((Object)bean, (String)propertyName);
                            if (null == valueClass) {
                                valueClass = this.getValueClassConsideringPrimitives(propertyClass);
                            }
                        } else {
                            valueClass = this.getValueClassConsideringPrimitives(propertyClass);
                        }
                        log.finest("(589) ================== ");
                        strValue = properties[i].getValue();
                        value = Util.isVBExpression(strValue) ? this.evaluateValueExpressionGet(strValue) : (null == strValue && properties[i].isNullValue() ? null : strValue);
                        log.finest("(600) ================== ");
                        value = this.getConvertedValueConsideringPrimitives(value, valueClass);
                        PropertyUtils.setSimpleProperty((Object)bean, (String)propertyName, (Object)value);
                        break;
                    }
                    default: {
                        Util.doAssert(false);
                        break;
                    }
                }
                continue;
            }
            catch (FacesException fe) {
                throw fe;
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "catch Exception", ex);
                if (3 == beanType) {
                    this.setComponentAttribute(bean, propertyName, value);
                    continue;
                }
                Object[] obj = new Object[]{propertyName};
                throw new FacesException(Util.getExceptionMessageString("com.sun.faces.ERROR_SETTING_BEAN_PROPERTY", obj), (Throwable)ex);
            }
        }
    }

    private void setArrayOrListPropertiesIntoBean(Object bean, ManagedPropertyBean property) throws Exception {
        int len;
        Object result = null;
        boolean getterIsNull = true;
        boolean getterIsArray = false;
        List<Object> valuesForBean = null;
        Class valueType = class$java$lang$String == null ? (class$java$lang$String = ManagedBeanFactory.class$("java.lang.String")) : class$java$lang$String;
        Class propertyType = null;
        String propertyName = property.getPropertyName();
        try {
            result = PropertyUtils.getProperty((Object)bean, (String)propertyName);
            getterIsNull = null == result;
            propertyType = PropertyUtils.getPropertyType((Object)bean, (String)propertyName);
            getterIsArray = propertyType.isArray();
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
        if (!getterIsArray && null != propertyType && !(class$java$util$List == null ? (class$java$util$List = ManagedBeanFactory.class$("java.util.List")) : class$java$util$List).isAssignableFrom(propertyType)) {
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CANNOT_SET_LIST_ARRAY_PROPERTY", new Object[]{propertyName, this.managedBean.getManagedBeanName()}));
        }
        if (!getterIsNull) {
            if (getterIsArray) {
                valuesForBean = new ArrayList();
                len = Array.getLength(result);
                for (int i = 0; i < len; ++i) {
                    valuesForBean.add(Array.get(result, i));
                }
            } else {
                if (!(result instanceof List)) {
                    throw new FacesException(Util.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_EXISTING_VALUE_NOT_LIST", new Object[]{propertyName, this.managedBean.getManagedBeanName()}));
                }
                valuesForBean = (List)result;
            }
        } else {
            valuesForBean = new ArrayList();
            result = valuesForBean;
        }
        valueType = this.copyListEntriesFromConfigToList(property.getListEntries(), valuesForBean);
        if (getterIsArray) {
            result = Array.newInstance(valueType, valuesForBean.size());
            len = valuesForBean.size();
            for (int i = 0; i < len; ++i) {
                if (valueType == Boolean.TYPE) {
                    Array.setBoolean(result, i, (Boolean)valuesForBean.get(i));
                    continue;
                }
                if (valueType == Byte.TYPE) {
                    Array.setByte(result, i, (Byte)valuesForBean.get(i));
                    continue;
                }
                if (valueType == Double.TYPE) {
                    Array.setDouble(result, i, (Double)valuesForBean.get(i));
                    continue;
                }
                if (valueType == Float.TYPE) {
                    Array.setFloat(result, i, ((Float)valuesForBean.get(i)).floatValue());
                    continue;
                }
                if (valueType == Integer.TYPE) {
                    Array.setInt(result, i, (Integer)valuesForBean.get(i));
                    continue;
                }
                if (valueType == Character.TYPE) {
                    Array.setChar(result, i, ((Character)valuesForBean.get(i)).charValue());
                    continue;
                }
                if (valueType == Short.TYPE) {
                    Array.setShort(result, i, (Short)valuesForBean.get(i));
                    continue;
                }
                if (valueType == Long.TYPE) {
                    Array.setLong(result, i, (Long)valuesForBean.get(i));
                    continue;
                }
                Array.set(result, i, valuesForBean.get(i));
            }
        } else {
            result = valuesForBean;
        }
        if (getterIsNull || getterIsArray) {
            PropertyUtils.setProperty((Object)bean, (String)propertyName, (Object)result);
        }
    }

    private void setMapPropertiesIntoBean(Object bean, ManagedPropertyBean property) throws Exception {
        HashMap result = null;
        boolean getterIsNull = true;
        Class propertyType = null;
        String propertyName = property.getPropertyName();
        try {
            result = (HashMap)PropertyUtils.getProperty((Object)bean, (String)propertyName);
            getterIsNull = null == result;
            propertyType = PropertyUtils.getPropertyType((Object)bean, (String)propertyName);
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
        if (null != propertyType && !(class$java$util$Map == null ? (class$java$util$Map = ManagedBeanFactory.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(propertyType)) {
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CANNOT_SET_MAP_PROPERTY", new Object[]{propertyName, this.managedBean.getManagedBeanName()}));
        }
        if (getterIsNull) {
            result = new HashMap(property.getMapEntries().getMapEntries().length);
        }
        this.copyMapEntriesFromConfigToMap(property.getMapEntries(), result);
        if (getterIsNull) {
            PropertyUtils.setProperty((Object)bean, (String)propertyName, result);
        }
    }

    private Class getValueClassConsideringPrimitives(String valueClass) throws ClassNotFoundException {
        Class<Serializable> valueType;
        Class<Long> clazz = valueType = class$java$lang$String == null ? (class$java$lang$String = ManagedBeanFactory.class$("java.lang.String")) : class$java$lang$String;
        if (null != valueClass && 0 < valueClass.length()) {
            valueType = valueClass.equals(Boolean.TYPE.getName()) ? Boolean.TYPE : (valueClass.equals(Byte.TYPE.getName()) ? Byte.TYPE : (valueClass.equals(Double.TYPE.getName()) ? Double.TYPE : (valueClass.equals(Float.TYPE.getName()) ? Float.TYPE : (valueClass.equals(Integer.TYPE.getName()) ? Integer.TYPE : (valueClass.equals(Character.TYPE.getName()) ? Character.TYPE : (valueClass.equals(Short.TYPE.getName()) ? Short.TYPE : (valueClass.equals(Long.TYPE.getName()) ? Long.TYPE : Util.loadClass(valueClass, this))))))));
        }
        return valueType;
    }

    private Object getConvertedValueConsideringPrimitives(Object value, Class valueType) throws FacesException {
        if (null != value && null != valueType) {
            if (valueType == Boolean.TYPE || valueType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ManagedBeanFactory.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                value = Boolean.valueOf(value.toString().toLowerCase());
            } else if (valueType == Byte.TYPE || valueType == (class$java$lang$Byte == null ? (class$java$lang$Byte = ManagedBeanFactory.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                value = new Byte(value.toString());
            } else if (valueType == Double.TYPE || valueType == (class$java$lang$Double == null ? (class$java$lang$Double = ManagedBeanFactory.class$("java.lang.Double")) : class$java$lang$Double)) {
                value = new Double(value.toString());
            } else if (valueType == Float.TYPE || valueType == (class$java$lang$Float == null ? (class$java$lang$Float = ManagedBeanFactory.class$("java.lang.Float")) : class$java$lang$Float)) {
                value = new Float(value.toString());
            } else if (valueType == Integer.TYPE || valueType == (class$java$lang$Integer == null ? (class$java$lang$Integer = ManagedBeanFactory.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                value = new Integer(value.toString());
            } else if (valueType == Character.TYPE || valueType == (class$java$lang$Character == null ? (class$java$lang$Character = ManagedBeanFactory.class$("java.lang.Character")) : class$java$lang$Character)) {
                value = new Character(value.toString().charAt(0));
            } else if (valueType == Short.TYPE || valueType == (class$java$lang$Short == null ? (class$java$lang$Short = ManagedBeanFactory.class$("java.lang.Short")) : class$java$lang$Short)) {
                value = new Short(value.toString());
            } else if (valueType == Long.TYPE || valueType == (class$java$lang$Long == null ? (class$java$lang$Long = ManagedBeanFactory.class$("java.lang.Long")) : class$java$lang$Long)) {
                value = new Long(value.toString());
            } else if (valueType != (class$java$lang$String == null ? (class$java$lang$String = ManagedBeanFactory.class$("java.lang.String")) : class$java$lang$String) && !valueType.isAssignableFrom(value.getClass())) {
                throw new FacesException(Util.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_TYPE_CONVERSION_ERROR", new Object[]{value.toString(), value.getClass(), valueType, this.managedBean.getManagedBeanName()}));
            }
        }
        return value;
    }

    public String getScope() {
        return this.scope;
    }

    private Object evaluateValueExpressionGet(String value) throws FacesException {
        Object result = null;
        if (!this.hasValidLifespan(value)) {
            Object[] obj = new Object[]{value};
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.INVALID_SCOPE_LIFESPAN", obj));
        }
        ValueExpression ve = Util.getValueExpression(value);
        if (ve != null) {
            try {
                FacesContextImpl fci = (FacesContextImpl)FacesContext.getCurrentInstance();
                result = ve.getValue(fci.getELContext());
            }
            catch (PropertyNotFoundException ex) {
                Object[] obj = new Object[]{value};
                throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.ERROR_GETTING_VALUEREF_VALUE", obj));
            }
        } else {
            Object[] obj = new Object[]{value};
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.ERROR_GETTING_VALUE_BINDING", obj));
        }
        return result;
    }

    private Object evaluateValueBindingGet(String value) throws FacesException {
        Object valueBinding = null;
        if (!this.hasValidLifespan(value)) {
            Object[] obj = new Object[]{value};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.INVALID_SCOPE_LIFESPAN", obj));
        }
        ValueBinding binding = Util.getValueBinding(value);
        if (binding != null) {
            try {
                valueBinding = binding.getValue(FacesContext.getCurrentInstance());
            }
            catch (PropertyNotFoundException ex) {
                Object[] obj = new Object[]{value};
                throw new FacesException(Util.getExceptionMessageString("com.sun.faces.ERROR_GETTING_VALUEREF_VALUE", obj));
            }
        } else {
            Object[] obj = new Object[]{value};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.ERROR_GETTING_VALUE_BINDING", obj));
        }
        return valueBinding;
    }

    private boolean hasValidLifespan(String value) throws EvaluationException, ReferenceSyntaxException {
        String valueScope = null;
        valueScope = Util.isMixedVBExpression(value) ? this.getNarrowestScopeFromExpression(value) : this.getScopeForSingleExpression(value);
        if (this.scope == null || this.scope.equalsIgnoreCase("NONE")) {
            return valueScope == null || valueScope.equalsIgnoreCase("NONE");
        }
        if (this.scope.equalsIgnoreCase("request")) {
            return true;
        }
        if (this.scope.equalsIgnoreCase("session")) {
            return valueScope == null || !valueScope.equalsIgnoreCase("request");
        }
        if (this.scope.equalsIgnoreCase("application")) {
            return valueScope == null || !valueScope.equalsIgnoreCase("request") && !valueScope.equalsIgnoreCase("session");
        }
        Util.doAssert(false);
        return false;
    }

    private String getScopeForSingleExpression(String value) throws ReferenceSyntaxException, EvaluationException {
        String[] firstSegment = new String[1];
        String valueScope = Util.getScope(value, firstSegment);
        if (null == valueScope) {
            ManagedBeanFactory otherFactory = null;
            valueScope = null != firstSegment[0] && null != (otherFactory = (ManagedBeanFactory)this.getManagedBeanFactoryMap().get(firstSegment[0])) ? otherFactory.getScope() : "application";
        }
        return valueScope;
    }

    private String getNarrowestScopeFromExpression(String expression) throws ReferenceSyntaxException {
        List expressions = Util.getExpressionsFromString(expression);
        Iterator iter = expressions.iterator();
        Integer shortestScope = null;
        Integer currentScope = null;
        String scope = null;
        String result = null;
        while (iter.hasNext()) {
            scope = this.getScopeForSingleExpression((String)iter.next());
            if (null == scope || scope.equalsIgnoreCase("NONE")) continue;
            currentScope = (Integer)scopeMap.get(scope);
            if (null == shortestScope) {
                shortestScope = currentScope;
                result = scope;
                continue;
            }
            if (currentScope >= shortestScope) continue;
            shortestScope = currentScope;
            result = scope;
        }
        return result;
    }

    public void setComponentAttribute(Object component, String propName, Object propValue) {
        ((UIComponent)component).getAttributes().put(propName, propValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

