/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;

public final class Resource {
    protected static final Logger log = Logger.getLogger("strawberry.resource");

    public static URL getResourceUrl(FacesContext ctx, String path) throws MalformedURLException {
        ExternalContext externalContext = ctx.getExternalContext();
        URL url = externalContext.getResource(path);
        log.fine("path " + path + " => " + url);
        if (url == null) {
            log.fine("66) path " + path + " => " + url);
            if (Resource.resourceExist(externalContext, path)) {
                url = Resource.getUrlForResourceAsStream(externalContext, path);
            }
        }
        return url;
    }

    private static boolean resourceExist(ExternalContext externalContext, String path) {
        ServletContext servletContext;
        InputStream stream;
        if ("/".equals(path)) {
            return true;
        }
        Object ctx = externalContext.getContext();
        if (ctx instanceof ServletContext && (stream = (servletContext = (ServletContext)ctx).getResourceAsStream(path)) != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private static URL getUrlForResourceAsStream(final ExternalContext externalContext, String path) throws MalformedURLException {
        URLStreamHandler handler = new URLStreamHandler(){

            protected URLConnection openConnection(URL u) throws IOException {
                String file = u.getFile();
                return new URLConnection(this, u, file){
                    private final /* synthetic */ String val$file;
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$file = val$file;
                    }

                    public void connect() throws IOException {
                    }

                    public InputStream getInputStream() throws IOException {
                        Object ctx;
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Opening internal url to " + this.val$file);
                        }
                        if ((ctx = 1.access$000(this.this$0).getContext()) instanceof ServletContext) {
                            ServletContext servletContext = (ServletContext)ctx;
                            InputStream stream = servletContext.getResourceAsStream(this.val$file);
                            if (stream == null) {
                                throw new FileNotFoundException("Cannot open resource " + this.val$file);
                            }
                            return stream;
                        }
                        throw new IOException("Cannot open resource for an context of " + (ctx != null ? ctx.getClass() : null));
                    }
                };
            }

            static /* synthetic */ ExternalContext access$000(1 x0) {
                return x0.externalContext;
            }
        };
        return new URL("internal", null, 0, path, handler);
    }
}

