/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag.jsf;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import com.sun.facelets.tag.jsf.RendererNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;

public final class ComponentSupport {
    private static final Logger log = Logger.getLogger("strawberry.ren.ComponentSupport");
    private static final String MARK_DELETED = "com.sun.facelets.MARK_DELETED";
    public static final String MARK_CREATED = "com.sun.facelets.MARK_ID";

    public static final void finalizeForDeletion(UIComponent c) {
        c.getAttributes().remove(MARK_DELETED);
        int sz = c.getChildCount();
        if (sz > 0) {
            UIComponent cc = null;
            List cl = c.getChildren();
            while (--sz >= 0) {
                cc = (UIComponent)cl.get(sz);
                if (!cc.getAttributes().containsKey(MARK_DELETED)) continue;
                cl.remove(sz);
            }
        }
        if (c.getFacets().size() > 0) {
            Collection col = c.getFacets().values();
            Iterator itr = col.iterator();
            while (itr.hasNext()) {
                UIComponent fc = (UIComponent)itr.next();
                if (!fc.getAttributes().containsKey(MARK_DELETED)) continue;
                itr.remove();
            }
        }
    }

    public static final UIComponent findChild(UIComponent parent, String id) {
        int sz = parent.getChildCount();
        if (sz > 0) {
            UIComponent c = null;
            List cl = parent.getChildren();
            while (--sz >= 0) {
                c = (UIComponent)cl.get(sz);
                if (!id.equals(c.getId())) continue;
                return c;
            }
        }
        return null;
    }

    public static final UIComponent findChildByTagId(UIComponent parent, String id) {
        int sz = parent.getChildCount();
        if (sz > 0) {
            UIComponent c = null;
            List cl = parent.getChildren();
            String cid = null;
            while (--sz >= 0) {
                c = (UIComponent)cl.get(sz);
                cid = (String)c.getAttributes().get(MARK_CREATED);
                if (!id.equals(cid)) continue;
                return c;
            }
        }
        return null;
    }

    public static final Locale getLocale(FaceletContext ctx, TagAttribute attr) throws TagAttributeException {
        Object obj = attr.getObject(ctx);
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.length() == 2) {
                return new Locale(s);
            }
            if (s.length() == 5) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase());
            }
            if (s.length() >= 7) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase(), s.substring(6, s.length()));
            }
            throw new TagAttributeException(attr, "Invalid Locale Specified: " + s);
        }
        throw new TagAttributeException(attr, "Attribute did not evaluate to a String or Locale: " + obj);
    }

    public static final UIViewRoot getViewRoot(FaceletContext ctx, UIComponent parent) {
        UIComponent c = parent;
        do {
            if (!(c instanceof UIViewRoot)) continue;
            return (UIViewRoot)c;
        } while ((c = c.getParent()) != null);
        return ctx.getFacesContext().getViewRoot();
    }

    public static final void markForDeletion(UIComponent c) {
        c.getAttributes().put(MARK_DELETED, Boolean.TRUE);
        int sz = c.getChildCount();
        if (sz > 0) {
            UIComponent cc = null;
            List cl = c.getChildren();
            while (--sz >= 0) {
                cc = (UIComponent)cl.get(sz);
                if (!cc.getAttributes().containsKey(MARK_CREATED)) continue;
                cc.getAttributes().put(MARK_DELETED, Boolean.TRUE);
            }
        }
        if (c.getFacets().size() > 0) {
            Collection col = c.getFacets().values();
            Iterator itr = col.iterator();
            while (itr.hasNext()) {
                UIComponent fc = (UIComponent)itr.next();
                if (!fc.getAttributes().containsKey(MARK_CREATED)) continue;
                fc.getAttributes().put(MARK_DELETED, Boolean.TRUE);
            }
        }
    }

    public static final void encodeRecursive(FacesContext context, UIComponent viewToRender) throws IOException, FacesException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("(230)\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0:\u30af\u30e9\u30b9" + viewToRender.getClass().getName());
            log.fine("(230)\u30d5\u30a1\u30df\u30ea" + viewToRender.getFamily() + "," + viewToRender.getRendererType());
        }
        if (viewToRender.isRendered()) {
            try {
                viewToRender.encodeBegin(context);
            }
            catch (NullPointerException ex) {
                String msg = viewToRender.toString() + ",family=" + viewToRender.getFamily() + ",rType=" + viewToRender.getRendererType();
                log.log(Level.SEVERE, "catch NPE:" + msg);
                throw new RendererNotFoundException(msg, ex);
            }
            if (viewToRender.getRendersChildren()) {
                log.finer("(267)  encodeChildren()\u3092\u547c\u3073\u307e\u3059");
                viewToRender.encodeChildren(context);
            } else if (viewToRender.getChildCount() > 0) {
                log.finer("(270)  getChildren()\u3067\u53d6\u308a\u51fa\u3057\u305f\u5b50Component\u3092\u51e6\u7406\u3057\u307e\u3059");
                Iterator kids = viewToRender.getChildren().iterator();
                while (kids.hasNext()) {
                    UIComponent kid = (UIComponent)kids.next();
                    ComponentSupport.encodeRecursive(context, kid);
                }
            }
            try {
                viewToRender.encodeEnd(context);
            }
            catch (ConverterException ce) {
                log.warning(" (253) catch ConverterException, \u30af\u30e9\u30b9:" + viewToRender.getClass().getName());
                ValueBinding vb = viewToRender.getValueBinding("value");
                if (vb == null) {
                    log.warning(" (256) vb == null");
                } else {
                    log.warning(" (258) vb = " + vb);
                }
                throw ce;
            }
        }
        log.info("! isRendered=" + viewToRender);
    }

    public static void removeTransient(UIComponent c) {
        UIComponent d;
        Iterator<Object> itr;
        if (c.getChildCount() > 0) {
            itr = c.getChildren().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.getFacets().size() > 0) {
                    Iterator jtr = d.getFacets().values().iterator();
                    while (jtr.hasNext()) {
                        UIComponent e = (UIComponent)jtr.next();
                        if (e.isTransient()) {
                            jtr.remove();
                            continue;
                        }
                        ComponentSupport.removeTransient(e);
                    }
                }
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(d);
            }
        }
        if (c.getFacets().size() > 0) {
            itr = c.getFacets().values().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(d);
            }
        }
    }

    public static final boolean isNew(UIComponent component) {
        return component != null && component.getParent() == null;
    }
}

