/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.el;

import com.sun.facelets.tag.TagAttribute;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;

public final class TagValueExpression
extends ValueExpression
implements Externalizable {
    protected static final Logger log = Logger.getLogger("strawberry.el.funmap");
    protected static final Logger stateLog = Logger.getLogger("strawberry.state.save");
    protected static final Logger restoreLog = Logger.getLogger("strawberry.state.restore");
    private static final long serialVersionUID = 1L;
    private ValueExpression orig;
    private String attr;

    public TagValueExpression() {
    }

    public TagValueExpression(TagAttribute attr, ValueExpression orig) {
        String wk = "";
        if (attr != null) {
            int k;
            wk = attr.toString();
            int n = wk.lastIndexOf("/");
            if (n >= 0) {
                wk = wk.substring(n + 1);
            }
            if ((k = wk.indexOf("value")) >= 0) {
                wk = wk.substring(0, k - 1);
            }
        }
        this.attr = wk;
        this.orig = orig;
    }

    public Class getExpectedType() {
        log.fine("60) getExpectedType");
        return this.orig.getExpectedType();
    }

    public Class getType(ELContext context) {
        log.fine("65) getType");
        try {
            return this.orig.getType(context);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.attr + ": " + pnfe.getMessage(), pnfe.getCause());
        }
        catch (ELException e) {
            throw new ELException(this.attr + ": " + e.getMessage(), e.getCause());
        }
    }

    public Object getValue(ELContext context) {
        log.fine("77) getValue");
        try {
            return this.orig.getValue(context);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.attr + ": " + pnfe.getMessage(), pnfe.getCause());
        }
        catch (ELException e) {
            throw new ELException(this.attr + ": " + e.getMessage(), e.getCause());
        }
    }

    public boolean isReadOnly(ELContext context) {
        log.fine("89) isReadOnly");
        try {
            return this.orig.isReadOnly(context);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.attr + ": " + pnfe.getMessage(), pnfe.getCause());
        }
        catch (ELException e) {
            throw new ELException(this.attr + ": " + e.getMessage(), e.getCause());
        }
    }

    public void setValue(ELContext context, Object value) {
        log.fine("101) setValue");
        try {
            this.orig.setValue(context, value);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(this.attr + ": " + pnfe.getMessage(), pnfe.getCause());
        }
        catch (PropertyNotWritableException pnwe) {
            throw new PropertyNotWritableException(this.attr + ": " + pnwe.getMessage(), pnwe.getCause());
        }
        catch (ELException e) {
            throw new ELException(this.attr + ": " + e.getMessage(), e.getCause());
        }
    }

    public boolean equals(Object obj) {
        log.fine("116) equals");
        return this.orig.equals(obj);
    }

    public String getExpressionString() {
        log.fine("121) getExpressionString");
        return this.orig.getExpressionString();
    }

    public int hashCode() {
        return this.orig.hashCode();
    }

    public boolean isLiteralText() {
        return this.orig.isLiteralText();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        restoreLog.fine("readExternal");
        this.orig = (ValueExpression)in.readObject();
        this.attr = in.readUTF();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        stateLog.fine("writeExternal");
        try {
            out.writeObject(this.orig);
        }
        catch (NotSerializableException nse1) {
            stateLog.log(Level.SEVERE, "orig = " + this.orig.getClass().getName());
            throw nse1;
        }
        try {
            out.writeUTF(this.attr);
        }
        catch (NotSerializableException nse2) {
            stateLog.log(Level.SEVERE, "attr = " + this.attr.getClass().getName());
            throw nse2;
        }
    }

    public String toString() {
        return this.attr + ": " + this.orig;
    }

    public String getDebugString() {
        return "el.TagValueExpression[" + this.attr + ", " + this.orig + "]";
    }

    public ValueExpression getOrig() {
        return this.orig;
    }
}

