/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.el;

import com.sun.facelets.el.ELAdaptor;
import com.sun.facelets.el.TagValueExpression;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ValueBinding;

public final class LegacyValueBinding
extends ValueBinding
implements Externalizable {
    protected static final Logger elLog = Logger.getLogger("strawberry.el.variable");
    protected static final Logger log = Logger.getLogger("strawberry.el.funmap");
    protected static final Logger saveLog = Logger.getLogger("strawberry.state.save");
    protected static final Logger restoreLog = Logger.getLogger("strawberry.state.restore");
    static final long serialVersionUID = 5372799367653684839L;
    private ValueExpression delegate;

    public LegacyValueBinding() {
    }

    public LegacyValueBinding(ValueExpression ve) {
        if (elLog.isLoggable(Level.FINE)) {
            elLog.fine("\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf" + ve);
        }
        this.delegate = ve;
    }

    public Object getValue(FacesContext context) throws EvaluationException, PropertyNotFoundException {
        ELContext ctx = ELAdaptor.getELContext(context);
        if (elLog.isLoggable(Level.FINE)) {
            elLog.fine("68) getValue ctx = " + ctx);
            elLog.fine("69) getValue " + this.delegate.getClass().getName());
        }
        try {
            return this.delegate.getValue(ctx);
        }
        catch (javax.el.PropertyNotFoundException e) {
            throw new PropertyNotFoundException(e.getMessage(), e.getCause());
        }
        catch (ELException e) {
            throw new EvaluationException(e.getMessage(), e.getCause());
        }
    }

    public void setValue(FacesContext context, Object value) throws EvaluationException, PropertyNotFoundException {
        ELContext ctx = ELAdaptor.getELContext(context);
        if (elLog.isLoggable(Level.FINE)) {
            elLog.fine("87) setValue ctx = " + ctx);
            elLog.fine("88) setValue " + value);
        }
        try {
            this.delegate.setValue(ctx, value);
        }
        catch (PropertyNotWritableException e) {
            throw new PropertyNotFoundException(e.getMessage(), e.getCause());
        }
        catch (javax.el.PropertyNotFoundException e) {
            throw new PropertyNotFoundException(e.getMessage(), e.getCause());
        }
        catch (ELException e) {
            throw new EvaluationException(e.getMessage(), e.getCause());
        }
    }

    public boolean isReadOnly(FacesContext context) throws EvaluationException, PropertyNotFoundException {
        ELContext ctx = ELAdaptor.getELContext(context);
        try {
            return this.delegate.isReadOnly(ctx);
        }
        catch (javax.el.PropertyNotFoundException e) {
            throw new PropertyNotFoundException(e.getMessage(), e.getCause());
        }
        catch (ELException e) {
            throw new EvaluationException(e.getMessage(), e.getCause());
        }
    }

    public Class getType(FacesContext context) throws EvaluationException, PropertyNotFoundException {
        ELContext ctx = ELAdaptor.getELContext(context);
        try {
            return this.delegate.getType(ctx);
        }
        catch (javax.el.PropertyNotFoundException e) {
            log.log(Level.WARNING, " 102 ---------------------", e);
            throw new PropertyNotFoundException(e.getMessage(), e.getCause());
        }
        catch (ELException e) {
            throw new EvaluationException(e.getMessage(), e.getCause());
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (restoreLog.isLoggable(Level.FINE)) {
            if (this.delegate == null) {
                restoreLog.fine("113) start: delegate == null");
            } else {
                restoreLog.fine("116) start:" + this.delegate.getClass().getName());
            }
        }
        this.delegate = (ValueExpression)in.readObject();
        restoreLog.fine("120) end");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (saveLog.isLoggable(Level.FINE)) {
            saveLog.fine("126) start:" + this.delegate.getClass().getName());
        }
        if (this.delegate instanceof TagValueExpression) {
            TagValueExpression tve = (TagValueExpression)this.delegate;
            out.writeObject(tve.getOrig());
        } else {
            out.writeObject(this.delegate);
        }
        saveLog.fine("129) end:");
    }

    public String getExpressionString() {
        return this.delegate.getExpressionString();
    }

    public String getDebugString() {
        if (this.delegate instanceof TagValueExpression) {
            TagValueExpression tve = (TagValueExpression)this.delegate;
            return "LegacyVB[" + tve.getDebugString() + "]";
        }
        return "LegacyVB[" + this.delegate + "]";
    }
}

