/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.compiler;

import com.sun.facelets.compiler.NamespaceUnit;
import com.sun.facelets.tag.TagLibrary;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NamespaceManager {
    protected static final Logger log = Logger.getLogger("strawberry.fls.compiler");
    private final List namespaces = new ArrayList();

    public void reset() {
        this.namespaces.clear();
    }

    public void pushNamespace(String prefix, String namespace) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("pushNamespace, prefix = " + prefix + ", namespace = " + namespace);
        }
        NS ns = new NS(prefix, namespace);
        this.namespaces.add(0, ns);
    }

    public String getNamespace(String prefix) {
        NS ns = null;
        for (int i = 0; i < this.namespaces.size(); ++i) {
            ns = (NS)this.namespaces.get(i);
            if (!ns.prefix.equals(prefix)) continue;
            if (log.isLoggable(Level.FINER)) {
                log.finer("getNamespace, prefix = " + prefix + " => " + ns.namespace);
            }
            return ns.namespace;
        }
        return null;
    }

    public void popNamespace(String prefix) {
        NS ns = null;
        for (int i = 0; i < this.namespaces.size(); ++i) {
            ns = (NS)this.namespaces.get(i);
            if (!ns.prefix.equals(prefix)) continue;
            this.namespaces.remove(i);
            return;
        }
    }

    public final NamespaceUnit toNamespaceUnit(TagLibrary library) {
        NamespaceUnit unit = new NamespaceUnit(library);
        if (this.namespaces.size() > 0) {
            NS ns = null;
            for (int i = this.namespaces.size() - 1; i >= 0; --i) {
                ns = (NS)this.namespaces.get(i);
                unit.setNamespace(ns.prefix, ns.namespace);
            }
        }
        return unit;
    }

    private static final class NS {
        public final String prefix;
        public final String namespace;

        public NS(String prefix, String ns) {
            this.prefix = prefix;
            this.namespace = ns;
        }
    }
}

