/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;

public class DebugWriter {
    protected static final Logger log1 = Logger.getLogger("strawberry.tree");

    public void printTreeToEncode(UIComponent component) {
        if (log1.isLoggable(Level.FINE)) {
            this.debugPrintTree("\u2606ToEncode", " ", component);
        }
    }

    public void printTreeToSave(UIComponent component) {
        if (log1.isLoggable(Level.FINE)) {
            this.debugPrintTree("\u2605ToSave", " ", component);
        }
    }

    public void debugPrintTree(String msg, String space, UIComponent component) {
        String clsName = component.getClass().getName();
        String wk = msg + space + this.simplifyClassName(clsName);
        boolean tran = component.isTransient();
        if (!tran) {
            wk = wk + ", *transient = false*";
        }
        log1.fine(wk);
        List childs = component.getChildren();
        for (int i = 0; i < childs.size(); ++i) {
            UIComponent kid = (UIComponent)childs.get(i);
            this.debugPrintTree(msg, "  " + space, kid);
        }
    }

    public String simplifyClassName(String className) {
        if (className.startsWith("com.sun.")) {
            className = className.substring(8);
        }
        return className;
    }
}

