/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.Data.ESWrapper;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.EventAdaptorGenerator;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventObject;

public abstract class EventAdaptor {
    protected Object source;
    protected ESWrapper wrapper;
    protected Method addAdaptorMethod;
    protected Method removeAdaptorMethod;
    static /* synthetic */ Class class$java$util$EventListener;

    public static EventAdaptor getEventAdaptor(Class lc, Object s, ESWrapper w) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IntrospectionException {
        Class eeac = null;
        EventAdaptor eea = null;
        BeanInfo sbi = Introspector.getBeanInfo(s.getClass());
        EventSetDescriptor[] sesd = sbi.getEventSetDescriptors();
        if (EventAdaptor.validateEventSource(sesd, lc) == -1) {
            throw new IllegalArgumentException("Object: " + s + " does not source: " + lc.getName());
        }
        eeac = EventAdaptor.getEventAdaptorClass(lc);
        eea = (EventAdaptor)eeac.newInstance();
        eea.setWrapper(w);
        try {
            eea.setSource(s);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register with source");
        }
        return eea;
    }

    public static Class getEventAdaptorClass(Class lc) throws ClassNotFoundException {
        if (!(class$java$util$EventListener == null ? (class$java$util$EventListener = EventAdaptor.class$("java.util.EventListener")) : class$java$util$EventListener).isAssignableFrom(lc)) {
            throw new IllegalArgumentException("Class is not a subinterface of java.util.EventListenerEventListener");
        }
        return EventAdaptorGenerator.getAdaptorClassForListenerClass(lc);
    }

    protected EventAdaptor() {
    }

    public abstract Class getListenerClass();

    public String getListenerClassName() {
        return this.getListenerClass().getName();
    }

    public synchronized Object getSource() {
        return this.source;
    }

    public synchronized ESWrapper getWarepper() {
        return this.wrapper;
    }

    public synchronized void setWrapper(ESWrapper w) {
        this.wrapper = w;
    }

    private static int validateEventSource(EventSetDescriptor[] sesd, Class lc) {
        for (int i = 0; i < sesd.length; ++i) {
            if (!lc.equals(sesd[i].getListenerType())) continue;
            return i;
        }
        return -1;
    }

    public synchronized void setSource(Object s) throws IntrospectionException, Exception {
        if (this.source != null && s != null && this.source.equals(s)) {
            return;
        }
        if (this.source != null) {
            this.removeAdaptorFromSource();
        }
        if (s == null) {
            this.source = null;
            this.addAdaptorMethod = null;
            this.removeAdaptorMethod = null;
            return;
        }
        BeanInfo sbi = Introspector.getBeanInfo(s.getClass());
        EventSetDescriptor[] sesd = sbi.getEventSetDescriptors();
        int i = EventAdaptor.validateEventSource(sesd, this.getListenerClass());
        if (i == -1) {
            throw new IllegalArgumentException("Object: " + s + " does not source: " + this.getListenerClassName());
        }
        Object olds = this.source;
        Method oldam = this.addAdaptorMethod;
        Method oldrm = this.removeAdaptorMethod;
        this.source = s;
        this.addAdaptorMethod = sesd[i].getAddListenerMethod();
        this.removeAdaptorMethod = sesd[i].getRemoveListenerMethod();
        try {
            this.addAdaptorToSource();
        }
        catch (Exception e) {
            this.source = olds;
            this.addAdaptorMethod = oldam;
            this.removeAdaptorMethod = oldrm;
            if (this.source != null) {
                this.addAdaptorToSource();
            }
            throw e;
        }
    }

    protected void fire(EventObject e, Method lm) throws Exception {
        Object[] a = new Object[]{e};
        this.wrapper.dispatchEvent(a, this.getListenerClass(), lm);
    }

    protected void fire(Object[] a, Method lm) throws Exception {
        this.wrapper.dispatchEvent(a, this.getListenerClass(), lm);
    }

    protected void addAdaptorToSource() {
        try {
            Object[] args = new Object[]{this};
            this.addAdaptorMethod.invoke(this.source, args);
        }
        catch (InvocationTargetException ite) {
            throw new ProgrammingError("cannot add adaptor [" + this + "] to source [" + this.source + "] InvocationTargetException: " + ite.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new ProgrammingError("cannot add adaptor [" + this + "] to source [" + this.source + "] IllegalAccessException: " + iae.getMessage());
        }
    }

    protected void removeAdaptorFromSource() {
        try {
            Object[] args = new Object[]{this};
            this.removeAdaptorMethod.invoke(this.source, args);
        }
        catch (InvocationTargetException ite) {
            System.err.println("cannot remove adaptor [" + this + "] from source [" + this.source + "] InvocationTargetException: " + ite.getMessage());
        }
        catch (IllegalAccessException iae) {
            System.err.println("cannot remove adaptor [" + this + "] from source [" + this.source + "] IllegalAccessException: " + iae.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

