/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.Data.ESLoader;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;

public class ClassInfo {
    private static Hashtable allClassInfo = new Hashtable();
    private Hashtable publicMethods = null;
    private Hashtable beanMethods = null;
    private Hashtable beanProperties = null;
    private BeanInfo beanInfo = null;

    private ClassInfo() {
    }

    private static ClassInfo ensureClassInfo(Class cls) {
        boolean debug = ESLoader.isDebugJavaAccess();
        ClassInfo classInfo = (ClassInfo)allClassInfo.get(cls);
        if (classInfo == null) {
            if (debug) {
                System.out.println("** Class info for class '" + cls + "' not found in cache, created");
            }
            classInfo = new ClassInfo();
            allClassInfo.put(cls, classInfo);
        }
        return classInfo;
    }

    public static synchronized PropertyDescriptor lookupBeanField(String fieldName, Class cls) {
        ClassInfo classInfo = ClassInfo.ensureClassInfo(cls);
        return classInfo.cachedBeanFieldLookup(fieldName, cls);
    }

    private PropertyDescriptor cachedBeanFieldLookup(String propertyName, Class cls) {
        boolean debug = ESLoader.isDebugJavaAccess();
        if (this.beanProperties != null) {
            PropertyDescriptor descriptor;
            if (debug) {
                System.out.println("** Bean properties for class '" + cls + "' found in cache");
            }
            if ((descriptor = (PropertyDescriptor)this.beanProperties.get(propertyName)) != null) {
                if (debug) {
                    System.out.println("** property descriptor '" + propertyName + "' found in cache");
                }
                return descriptor;
            }
        }
        if (debug) {
            System.out.println("** No property named '" + propertyName + "' found in cache, lookup started");
        }
        if (this.beanInfo == null) {
            try {
                this.beanInfo = Introspector.getBeanInfo(cls);
            }
            catch (IntrospectionException e) {
                if (debug) {
                    System.out.println(" ** Error getting beaninfo: " + e);
                }
                return null;
            }
        }
        PropertyDescriptor[] allProperties = this.beanInfo.getPropertyDescriptors();
        PropertyDescriptor descriptor = null;
        for (int i = 0; i < allProperties.length; ++i) {
            PropertyDescriptor property = allProperties[i];
            if (debug) {
                System.out.println("** Property examined: " + property.getName());
            }
            if (!property.getName().equals(propertyName)) continue;
            descriptor = property;
            break;
        }
        if (descriptor != null) {
            Method readMethod = descriptor.getReadMethod();
            Method writeMethod = descriptor.getWriteMethod();
            Class<?> propCls = descriptor.getPropertyType();
            if (descriptor instanceof IndexedPropertyDescriptor) {
                Class<?>[] paramCls;
                IndexedPropertyDescriptor iDescriptor = (IndexedPropertyDescriptor)descriptor;
                Method indexedReadMethod = iDescriptor.getIndexedReadMethod();
                Method indexedWriteMethod = iDescriptor.getIndexedWriteMethod();
                Class<?> propIndexedCls = iDescriptor.getIndexedPropertyType();
                if (propIndexedCls == null) {
                    throw new ProgrammingError("getIndexedPropertyType returned null for " + propertyName);
                }
                if (propIndexedCls == Void.TYPE) {
                    throw new ProgrammingError("Void indexed property type for '" + propertyName + "' is not allowed");
                }
                if (indexedReadMethod != null && indexedReadMethod.getParameterTypes().length != 1) {
                    throw new ProgrammingError("Indexed getter of property ' " + propertyName + "' should have 1 parameter!");
                }
                if (indexedWriteMethod != null) {
                    paramCls = indexedWriteMethod.getParameterTypes();
                    if (paramCls == null || paramCls.length != 2) {
                        throw new ProgrammingError("Indexed setter of property ' " + propertyName + "' should have 2 parameter!");
                    }
                    if (paramCls[0] != propIndexedCls) {
                        throw new ProgrammingError("Inconstant parameter type for indexed setter of indexed property' " + propertyName + "', type: " + propCls);
                    }
                }
                if (propCls != null) {
                    if (!propCls.isArray()) {
                        throw new ProgrammingError("Non array type (" + propCls + ") for array access of indexed property '" + propertyName + "'");
                    }
                    if (propCls.getComponentType() != propIndexedCls) {
                        throw new ProgrammingError("Type missmatch between array and non array access of indexed property '" + propertyName + "'");
                    }
                    if (readMethod != null && readMethod.getParameterTypes().length != 0) {
                        throw new ProgrammingError("Non indexed getter of indxed property ' " + propertyName + "' is not supposed to have a parameter!");
                    }
                    if (writeMethod != null) {
                        paramCls = writeMethod.getParameterTypes();
                        if (paramCls == null || paramCls.length != 1) {
                            throw new ProgrammingError("Non indexed setter of indexed property ' " + propertyName + "' should have 1 parameter!");
                        }
                        if (paramCls[0] != propCls) {
                            throw new ProgrammingError("Inconstant parameter type for non indexed setter of indexed property' " + propertyName + "', type: " + propCls);
                        }
                    }
                }
            } else {
                if (propCls == null) {
                    throw new ProgrammingError("getPropertyType returned null for " + propertyName);
                }
                if (propCls == Void.TYPE) {
                    throw new ProgrammingError("Void property type for '" + propertyName + "' is not allowed");
                }
                if (readMethod != null && readMethod.getParameterTypes().length != 0) {
                    throw new ProgrammingError("Non indexed getter of property ' " + propertyName + "' is not supposed to have a parameter!");
                }
                if (writeMethod != null) {
                    Class<?>[] paramCls = writeMethod.getParameterTypes();
                    if (paramCls == null || paramCls.length != 1) {
                        throw new ProgrammingError("Non indexed setter of property ' " + propertyName + "' should have 1 parameter!");
                    }
                    if (paramCls[0] != propCls) {
                        throw new ProgrammingError("Inconstant parameter type for setter of property' " + propertyName + "', type: " + propCls);
                    }
                }
            }
            if (debug) {
                System.out.println("** property '" + propertyName + "' + found, add to cache");
            }
            if (this.beanProperties == null) {
                this.beanProperties = new Hashtable();
            }
            this.beanProperties.put(propertyName, descriptor);
        } else if (debug) {
            System.out.println("** No method named '" + propertyName + "' found");
        }
        return descriptor;
    }

    public static synchronized Method[] lookupPublicMethod(String functionName, Class cls) throws EcmaScriptException {
        ClassInfo classInfo = ClassInfo.ensureClassInfo(cls);
        return classInfo.cachedPublicMethodLookup(functionName, cls);
    }

    /*
     * Unable to fully structure code
     */
    private Method getInInterfaces(String functionName, Class[] interfaces, Class[] paramTypes) {
        debug = ESLoader.isDebugJavaAccess();
        if (debug && interfaces.length > 0) {
            System.out.println("** Looking in " + interfaces.length + " interfaces");
        }
        for (ix = 0; ix < interfaces.length; ++ix) {
            theInterface = interfaces[ix];
            if (Modifier.isPublic(theInterface.getModifiers())) {
                if (debug) {
                    System.out.println("** Looking in public interface: " + theInterface);
                }
                try {
                    method = theInterface.getDeclaredMethod(functionName, paramTypes);
                    if (!Modifier.isPublic(method.getModifiers())) ** GOTO lbl23
                    if (debug) {
                        System.out.println("** Public method found: " + functionName);
                    }
                    return method;
                }
                catch (NoSuchMethodException e) {
                    if (!debug) ** GOTO lbl23
                    System.out.println("** The method has no public declaration in the interface: " + functionName);
                }
                catch (SecurityException e) {
                    throw new ProgrammingError("Access error inspecting method " + functionName + ": " + e);
                }
            } else if (debug) {
                System.out.println("** Interface " + theInterface + " is not public - not searching for method");
            }
lbl23:
            // 6 sources

            superInterfaces = theInterface.getInterfaces();
            method = this.getInInterfaces(functionName, superInterfaces, paramTypes);
            if (method == null) continue;
            if (debug) {
                System.out.println("** Method found in super interfaces");
            }
            return method;
        }
        if (debug) {
            System.out.println("** No method found in interface and super interfaces");
        }
        return null;
    }

    private Method[] cachedPublicMethodLookup(String functionName, Class cls) throws EcmaScriptException {
        boolean debug = ESLoader.isDebugJavaAccess();
        if (this.publicMethods != null) {
            Method[] methods;
            if (debug) {
                System.out.println("** Method descriptor for class '" + cls + "' found in cache");
            }
            if ((methods = (Method[])this.publicMethods.get(functionName)) != null) {
                if (debug) {
                    System.out.println("** " + methods.length + " method(s) named '" + functionName + "' found in cache");
                }
                return methods;
            }
        }
        if (debug) {
            System.out.println("** No method named '" + functionName + "' found in class cache, lookup started");
        }
        Method[] allMethods = cls.getMethods();
        Vector<Method> methodVector = new Vector<Method>(allMethods.length);
        boolean wasFound = false;
        for (int i = 0; i < allMethods.length; ++i) {
            Method method = allMethods[i];
            if (debug) {
                System.out.println("** Method examined: " + method.toString());
            }
            if (!method.getName().equals(functionName)) continue;
            if (!Modifier.isStatic(cls.getModifiers()) && !Modifier.isPublic(cls.getModifiers())) {
                if (debug) {
                    System.out.println("** Class " + cls + " is not public, examining superclasses and interfaces to find proper method descriptor");
                }
                Class[] paramTypes = method.getParameterTypes();
                for (Class theClass = cls; theClass != null; theClass = theClass.getSuperclass()) {
                    Class[] interfaces = cls.getInterfaces();
                    Method m = this.getInInterfaces(functionName, interfaces, paramTypes);
                    if (m != null) {
                        method = m;
                        wasFound = true;
                        break;
                    }
                    if (Modifier.isPublic(theClass.getModifiers())) {
                        if (debug) {
                            System.out.println("** Looking in public class: " + theClass);
                        }
                        try {
                            m = theClass.getDeclaredMethod(functionName, paramTypes);
                            if (!Modifier.isPublic(method.getModifiers())) continue;
                            if (debug) {
                                System.out.println("** Public method found: " + functionName);
                            }
                            method = m;
                            wasFound = true;
                            break;
                        }
                        catch (NoSuchMethodException e) {
                            if (!debug) continue;
                            System.out.println("** The method has no public declaration in the public class: " + functionName);
                            continue;
                        }
                        catch (SecurityException e) {
                            throw new ProgrammingError("Access error inspecting method " + functionName + ": " + e);
                        }
                    }
                    if (!debug) continue;
                    System.out.println("** Class " + theClass + " is not public - not searching for method");
                }
                if (!wasFound) {
                    throw new EcmaScriptException("The method '" + functionName + "' has no public declaration in a public class or public interface ");
                }
            }
            methodVector.addElement(method);
        }
        Object[] methods = null;
        int nmbMethods = methodVector.size();
        if (nmbMethods > 0) {
            if (debug) {
                System.out.println("** " + nmbMethods + " methods named: '" + functionName + "' + found, add to class cache");
            }
            methods = new Method[nmbMethods];
            methodVector.copyInto(methods);
            if (this.publicMethods == null) {
                this.publicMethods = new Hashtable();
            }
            this.publicMethods.put(functionName, methods);
        } else if (debug) {
            System.out.println("** No method named '" + functionName + "' found");
        }
        return methods;
    }

    public static synchronized Method[] lookupBeanMethod(String functionName, Class cls) {
        ClassInfo classInfo = ClassInfo.ensureClassInfo(cls);
        return classInfo.cachedBeanMethodLookup(functionName, cls);
    }

    private Method[] cachedBeanMethodLookup(String functionName, Class cls) {
        boolean debug = ESLoader.isDebugJavaAccess();
        if (this.beanMethods != null) {
            Method[] methods;
            if (debug) {
                System.out.println("** Method descriptor for bean '" + cls + "' found in cache");
            }
            if ((methods = (Method[])this.beanMethods.get(functionName)) != null) {
                if (debug) {
                    System.out.println("** " + methods.length + " method(s) named '" + functionName + "' found in cache");
                }
                return methods;
            }
        }
        if (debug) {
            System.out.println("** No method named '" + functionName + "' found in bean cache, lookup started");
        }
        if (this.beanInfo == null) {
            try {
                this.beanInfo = Introspector.getBeanInfo(cls);
            }
            catch (IntrospectionException e) {
                if (debug) {
                    System.out.println(" ** Error getting beaninfo: " + e);
                }
                return null;
            }
        }
        MethodDescriptor[] allDescriptors = this.beanInfo.getMethodDescriptors();
        Vector<Method> methodVector = new Vector<Method>(allDescriptors.length);
        for (int i = 0; i < allDescriptors.length; ++i) {
            Method method = allDescriptors[i].getMethod();
            if (debug) {
                System.out.println("** Method examined: " + method.toString());
            }
            if (!allDescriptors[i].getName().equals(functionName)) continue;
            if (!Modifier.isStatic(cls.getModifiers()) && !Modifier.isPublic(cls.getModifiers())) {
                if (debug) {
                    System.out.println("** Bean class " + cls + " is not public, examining superclasses to find proper method descriptor");
                }
                for (Class theClass = cls; theClass != null; theClass = theClass.getSuperclass()) {
                    if (Modifier.isPublic(theClass.getModifiers())) {
                        if (debug) {
                            System.out.println("** Looking in public superlass: " + theClass);
                        }
                        try {
                            Class<?>[] paramTypes = method.getParameterTypes();
                            Method m = theClass.getDeclaredMethod(functionName, paramTypes);
                            if (!Modifier.isPublic(method.getModifiers())) continue;
                            if (debug) {
                                System.out.println("** Public method found: " + functionName);
                            }
                            method = m;
                            break;
                        }
                        catch (NoSuchMethodException e) {
                            throw new ProgrammingError("Error inspecting method " + functionName + ": " + e);
                        }
                        catch (SecurityException e) {
                            throw new ProgrammingError("Acess error inspecting method " + functionName + ": " + e);
                        }
                    }
                    if (!debug) continue;
                    System.out.println("** Superlass " + theClass + " is not public");
                }
            }
            methodVector.addElement(method);
        }
        Object[] methods = null;
        int nmbMethods = methodVector.size();
        if (nmbMethods > 0) {
            if (debug) {
                System.out.println("** " + nmbMethods + " methods named: '" + functionName + "' + found, add to bean cache");
            }
            methods = new Method[nmbMethods];
            methodVector.copyInto(methods);
            if (this.beanMethods == null) {
                this.beanMethods = new Hashtable();
            }
            this.beanMethods.put(functionName, methods);
        } else if (debug) {
            System.out.println("** No bean method named: '" + functionName + "' + found");
        }
        return methods;
    }
}

