/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ArrayPrototype;
import FESI.Data.BuiltinFunctionObject;
import FESI.Data.DatePrototype;
import FESI.Data.ESBoolean;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.ESFile;
import FESI.Extensions.ESStdFile;
import FESI.Extensions.Extension;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.ScopeChain;
import java.io.File;

public class FileIO
extends Extension {
    private Evaluator evaluator = null;
    private ESObject esFilePrototype = null;

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.evaluator = evaluator;
        GlobalObject go = evaluator.getGlobalObject();
        ObjectPrototype op = (ObjectPrototype)evaluator.getObjectPrototype();
        this.esFilePrototype = new ObjectPrototype(op, evaluator);
        FunctionPrototype fp = (FunctionPrototype)evaluator.getFunctionPrototype();
        GlobalObjectFile file = new GlobalObjectFile("File", evaluator, fp);
        ESStdFile infile = new ESStdFile(this.esFilePrototype, evaluator, "<stdin>", System.in);
        ESStdFile outfile = new ESStdFile(this.esFilePrototype, evaluator, "<stdout>", System.out);
        ESStdFile errfile = new ESStdFile(this.esFilePrototype, evaluator, "<stderr>", System.err);
        this.esFilePrototype.putHiddenProperty("open", new FileOpen("open", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("flush", new FileFlush("flush", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("close", new FileClose("close", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("exists", new FileExists("exists", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("isFile", new FileIsFile("isFile", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("isOpened", new FileIsOpened("isOpened", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("isAbsolute", new FileIsAbsolute("isAbsolute", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("isDirectory", new FileIsDirectory("isDirectory", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("eof", new FileEof("eof", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("write", new FileWrite("write", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("writeln", new FileWriteln("writeln", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("readln", new FileReadln("readln", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("error", new FileError("error", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("clearError", new FileClearError("clearError", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("getLength", new FileGetLength("getLength", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("lastModified", new FileLastModified("lastModified", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("remove", new FileRemove("remove", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("renameTo", new FileRenameTo("renameTo", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("canWrite", new FileCanWrite("canWrite", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("canRead", new FileCanRead("canRead", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("getParent", new FileGetParent("getParent", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("getName", new FileGetName("getName", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("getPath", new FileGetPath("getPath", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("toString", new FileGetPath("toString", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("getAbsolutePath", new FileGetAbsolutePath("getAbsolutePath", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("mkdir", new FileMkdir("mkdir", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("list", new FileList("list", evaluator, fp));
        this.esFilePrototype.putHiddenProperty("readAll", new FileReadAll("readAll", evaluator, fp));
        file.putHiddenProperty("stdin", infile);
        file.putHiddenProperty("stdout", outfile);
        file.putHiddenProperty("stderr", errfile);
        go.putHiddenProperty("File", file);
    }

    class FileReadAll
    extends BuiltinFunctionObject {
        FileReadAll(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return new ESString(file.readAll());
        }
    }

    class FileList
    extends BuiltinFunctionObject {
        FileList(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            String[] l = file.list();
            if (l == null) {
                return ESBoolean.makeBoolean(false);
            }
            ESObject ap = this.evaluator.getArrayPrototype();
            ArrayPrototype theArray = new ArrayPrototype(ap, this.evaluator);
            theArray.setSize(l.length);
            for (int i = 0; i < l.length; ++i) {
                theArray.setElementAt(new ESString(l[i]), i);
            }
            return theArray;
        }
    }

    class FileMkdir
    extends BuiltinFunctionObject {
        FileMkdir(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return ESBoolean.makeBoolean(file.mkdir());
        }
    }

    class FileGetAbsolutePath
    extends BuiltinFunctionObject {
        FileGetAbsolutePath(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return new ESString(file.getAbsolutePath());
        }
    }

    class FileGetPath
    extends BuiltinFunctionObject {
        FileGetPath(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return new ESString(file.getPath());
        }
    }

    class FileGetParent
    extends BuiltinFunctionObject {
        FileGetParent(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return new ESString(file.getParent());
        }
    }

    class FileGetName
    extends BuiltinFunctionObject {
        FileGetName(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return new ESString(file.getName());
        }
    }

    class FileCanRead
    extends BuiltinFunctionObject {
        FileCanRead(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return ESBoolean.makeBoolean(file.canRead());
        }
    }

    class FileCanWrite
    extends BuiltinFunctionObject {
        FileCanWrite(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return ESBoolean.makeBoolean(file.canWrite());
        }
    }

    class FileRenameTo
    extends BuiltinFunctionObject {
        FileRenameTo(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            if (arguments.length <= 0) {
                return ESBoolean.makeBoolean(false);
            }
            ESFile toFile = null;
            toFile = arguments[0] instanceof ESFile ? (ESFile)arguments[0] : new ESFile(FileIO.this.esFilePrototype, this.evaluator, arguments[0].toString());
            return ESBoolean.makeBoolean(file.renameTo(toFile));
        }
    }

    class FileRemove
    extends BuiltinFunctionObject {
        FileRemove(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return ESBoolean.makeBoolean(file.remove());
        }
    }

    class FileClearError
    extends BuiltinFunctionObject {
        FileClearError(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            file.clearError();
            return ESUndefined.theUndefined;
        }
    }

    class FileError
    extends BuiltinFunctionObject {
        FileError(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return new ESString(file.error());
        }
    }

    class FileLastModified
    extends BuiltinFunctionObject {
        FileLastModified(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            long lmDate = file.lastModified();
            DatePrototype theDate = new DatePrototype(this.evaluator, lmDate);
            return theDate;
        }
    }

    class FileGetLength
    extends BuiltinFunctionObject {
        FileGetLength(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return new ESNumber(file.getLength());
        }
    }

    class FileFlush
    extends BuiltinFunctionObject {
        FileFlush(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return ESBoolean.makeBoolean(file.flush());
        }
    }

    class FileClose
    extends BuiltinFunctionObject {
        FileClose(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return ESBoolean.makeBoolean(file.close());
        }
    }

    class FileOpen
    extends BuiltinFunctionObject {
        FileOpen(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return ESBoolean.makeBoolean(file.open());
        }
    }

    class FileWrite
    extends BuiltinFunctionObject {
        FileWrite(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return ESBoolean.makeBoolean(file.write(false, arguments));
        }
    }

    class FileIsDirectory
    extends BuiltinFunctionObject {
        FileIsDirectory(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return ESBoolean.makeBoolean(file.isDirectory());
        }
    }

    class FileIsFile
    extends BuiltinFunctionObject {
        FileIsFile(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return ESBoolean.makeBoolean(file.isFile());
        }
    }

    class FileIsAbsolute
    extends BuiltinFunctionObject {
        FileIsAbsolute(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return ESBoolean.makeBoolean(file.isAbsolute());
        }
    }

    class FileIsOpened
    extends BuiltinFunctionObject {
        FileIsOpened(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return ESBoolean.makeBoolean(file.isOpened());
        }
    }

    class FileExists
    extends BuiltinFunctionObject {
        FileExists(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return ESBoolean.makeBoolean(file.exists());
        }
    }

    class FileEof
    extends BuiltinFunctionObject {
        FileEof(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return ESBoolean.makeBoolean(file.eof());
        }
    }

    class FileReadln
    extends BuiltinFunctionObject {
        FileReadln(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 0);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            String line = file.readln();
            if (line == null) {
                return ESNull.theNull;
            }
            return new ESString(line);
        }
    }

    class FileWriteln
    extends BuiltinFunctionObject {
        FileWriteln(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = (ESFile)thisObject;
            return ESBoolean.makeBoolean(file.write(true, arguments));
        }
    }

    class GlobalObjectFile
    extends BuiltinFunctionObject {
        GlobalObjectFile(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            return this.doConstruct(thisObject, arguments);
        }

        public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESFile file = null;
            if (arguments.length == 0) {
                throw new EcmaScriptException("File requires 1 or 2 arguments");
            }
            if (arguments.length == 1) {
                file = new ESFile(FileIO.this.esFilePrototype, this.evaluator, arguments[0].toString());
            } else if (arguments.length > 1) {
                file = new ESFile(FileIO.this.esFilePrototype, this.evaluator, arguments[0].toString(), arguments[1].toString());
            }
            return file;
        }

        public ESValue getPropertyInScope(String propertyName, ScopeChain previousScope, int hash) throws EcmaScriptException {
            if (propertyName.equals("separator")) {
                return new ESString(File.separator);
            }
            return super.getPropertyInScope(propertyName, previousScope, hash);
        }

        public ESValue getProperty(String propertyName, int hash) throws EcmaScriptException {
            if (propertyName.equals("separator")) {
                return new ESString(File.separator);
            }
            return super.getProperty(propertyName, hash);
        }

        public String[] getSpecialPropertyNames() {
            String[] ns = new String[]{"separator"};
            return ns;
        }
    }
}

