/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Interpreter.Evaluator;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

class ESFile
extends ESObject {
    File file = null;
    Object readerWriter = null;
    boolean atEOF = false;
    String lastLine = null;
    Throwable lastError = null;

    ESFile(ESObject prototype, Evaluator evaluator, String fileName) {
        super(prototype, evaluator);
        this.file = new File(fileName);
    }

    ESFile(ESObject prototype, Evaluator evaluator, String pathName, String fileName) {
        super(prototype, evaluator);
        this.file = new File(pathName, fileName);
    }

    protected ESFile(ESObject prototype, Evaluator evaluator) {
        super(prototype, evaluator);
    }

    public String getESClassName() {
        return "File";
    }

    public String toString() {
        if (this.file == null) {
            return "<null>";
        }
        return this.file.toString();
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + this.getClass().getName() + ":" + (this.file == null ? "null" : this.file.toString()) + "]";
    }

    protected void setError(Throwable e) {
        this.lastError = e;
    }

    public boolean exists() {
        if (this.file == null) {
            return false;
        }
        return this.file.exists();
    }

    public boolean open() {
        if (this.readerWriter != null) {
            this.setError(new IllegalStateException("File already open"));
            return false;
        }
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        try {
            this.readerWriter = this.file.exists() ? new BufferedReader(new FileReader(this.file)) : new PrintWriter(new FileWriter(this.file));
            return true;
        }
        catch (IOException e) {
            this.setError(e);
            return false;
        }
    }

    public boolean isOpened() {
        return this.readerWriter != null;
    }

    public boolean close() {
        if (this.readerWriter == null) {
            return false;
        }
        try {
            if (this.readerWriter instanceof Reader) {
                ((Reader)this.readerWriter).close();
            } else {
                ((Writer)this.readerWriter).close();
            }
            this.readerWriter = null;
            return true;
        }
        catch (IOException e) {
            this.setError(e);
            this.readerWriter = null;
            return false;
        }
    }

    public boolean write(boolean ln, ESValue[] arguments) {
        if (this.readerWriter == null) {
            this.setError(new IllegalStateException("File not opened"));
            return false;
        }
        if (!(this.readerWriter instanceof PrintWriter)) {
            this.setError(new IllegalStateException("File not opened for writing"));
            return false;
        }
        PrintWriter writer = (PrintWriter)this.readerWriter;
        for (int i = 0; i < arguments.length; ++i) {
            writer.print(arguments[i].toString());
        }
        if (ln) {
            writer.println();
        }
        return true;
    }

    public String readln() {
        if (this.readerWriter == null) {
            this.setError(new IllegalStateException("File not opened"));
            return null;
        }
        if (!(this.readerWriter instanceof BufferedReader)) {
            this.setError(new IllegalStateException("File not opened for reading"));
            return null;
        }
        if (this.atEOF) {
            this.setError(new EOFException());
            return null;
        }
        if (this.lastLine != null) {
            String line = this.lastLine;
            this.lastLine = null;
            return line;
        }
        BufferedReader reader = (BufferedReader)this.readerWriter;
        try {
            String line = reader.readLine();
            if (line == null) {
                this.atEOF = true;
                this.setError(new EOFException());
            }
            return line;
        }
        catch (IOException e) {
            this.setError(e);
            return null;
        }
    }

    public boolean eof() {
        if (this.readerWriter == null) {
            this.setError(new IllegalStateException("File not opened"));
            return true;
        }
        if (!(this.readerWriter instanceof BufferedReader)) {
            this.setError(new IllegalStateException("File not opened for read"));
            return true;
        }
        if (this.atEOF) {
            return true;
        }
        if (this.lastLine != null) {
            return false;
        }
        BufferedReader reader = (BufferedReader)this.readerWriter;
        try {
            this.lastLine = reader.readLine();
            if (this.lastLine == null) {
                this.atEOF = true;
            }
            return this.atEOF;
        }
        catch (IOException e) {
            this.setError(e);
            return true;
        }
    }

    public boolean isFile() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        return this.file.isFile();
    }

    public boolean isDirectory() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        return this.file.isDirectory();
    }

    public boolean flush() {
        if (this.readerWriter == null) {
            this.setError(new IllegalStateException("File not opened"));
            return false;
        }
        if (this.readerWriter instanceof Writer) {
            try {
                ((Writer)this.readerWriter).flush();
            }
            catch (IOException e) {
                this.setError(e);
                return false;
            }
        } else {
            this.setError(new IllegalStateException("File not opened for write"));
            return false;
        }
        return true;
    }

    public long getLength() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return -1L;
        }
        return this.file.length();
    }

    public long lastModified() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return 0L;
        }
        return this.file.lastModified();
    }

    public String error() {
        if (this.lastError == null) {
            return "";
        }
        String exceptionName = this.lastError.getClass().getName();
        int l = exceptionName.lastIndexOf(".");
        if (l > 0) {
            exceptionName = exceptionName.substring(l + 1);
        }
        return exceptionName + ": " + this.lastError.getMessage();
    }

    public void clearError() {
        this.lastError = null;
    }

    public boolean remove() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        if (this.readerWriter != null) {
            this.setError(new IllegalStateException("An openened file cannot be removed"));
            return false;
        }
        return this.file.delete();
    }

    public boolean renameTo(ESFile toFile) {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized source File object"));
            return false;
        }
        if (toFile.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized target File object"));
            return false;
        }
        if (this.readerWriter != null) {
            this.setError(new IllegalStateException("An openened file cannot be renamed"));
            return false;
        }
        if (toFile.readerWriter != null) {
            this.setError(new IllegalStateException("You cannot rename to an openened file"));
            return false;
        }
        return this.file.renameTo(toFile.file);
    }

    public boolean canRead() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        return this.file.canRead();
    }

    public boolean canWrite() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return false;
        }
        return this.file.canWrite();
    }

    public String getParent() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return "";
        }
        String parent = this.file.getParent();
        return parent == null ? "" : parent;
    }

    public String getName() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return "";
        }
        String name = this.file.getName();
        return name == null ? "" : name;
    }

    public String getPath() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return "";
        }
        String path = this.file.getPath();
        return path == null ? "" : path;
    }

    public String getAbsolutePath() {
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return "";
        }
        String absolutPath = this.file.getAbsolutePath();
        return absolutPath == null ? "" : absolutPath;
    }

    public boolean isAbsolute() {
        if (this.file == null) {
            return false;
        }
        return this.file.isAbsolute();
    }

    public boolean mkdir() {
        if (this.file == null) {
            return false;
        }
        if (this.readerWriter != null) {
            return false;
        }
        return this.file.mkdirs();
    }

    public String[] list() {
        if (this.file == null) {
            return null;
        }
        if (this.readerWriter != null) {
            return null;
        }
        if (!this.file.isDirectory()) {
            return null;
        }
        return this.file.list();
    }

    public String readAll() {
        if (this.readerWriter != null) {
            this.setError(new IllegalStateException("File already open"));
            return null;
        }
        if (this.file == null) {
            this.setError(new IllegalArgumentException("Uninitialized File object"));
            return null;
        }
        try {
            String line;
            if (!this.file.exists()) {
                this.setError(new IllegalStateException("File does not exist"));
                return null;
            }
            this.readerWriter = new BufferedReader(new FileReader(this.file));
            if (!this.file.isFile()) {
                this.setError(new IllegalStateException("File is not a regular file"));
                return null;
            }
            StringBuffer buffer = new StringBuffer((int)((double)this.file.length() * 1.1));
            BufferedReader reader = (BufferedReader)this.readerWriter;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            ((Reader)this.readerWriter).close();
            this.readerWriter = null;
            return buffer.toString();
        }
        catch (IOException e) {
            this.readerWriter = null;
            this.setError(e);
            return null;
        }
    }
}

