/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ESBoolean;
import FESI.Data.ESLoader;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.ESRowSet;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.LocalClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class ESDatabase
extends ESObject {
    private transient Connection connection = null;
    private transient DatabaseMetaData databaseMetaData = null;
    private transient String driverName = null;
    private transient ClassLoader driverLoader = null;
    private transient Exception lastError = null;
    private transient ESObject esRowSetPrototype = null;
    private transient boolean driverOK = false;
    static /* synthetic */ Class class$java$sql$Driver;

    ESDatabase(ESObject prototype, Evaluator evaluator, ESObject esRowSetPrototype, String driverName) {
        super(prototype, evaluator);
        this.driverName = driverName;
        this.esRowSetPrototype = esRowSetPrototype;
        try {
            Class<?> driverClass = Class.forName(driverName);
            if (!(class$java$sql$Driver == null ? (class$java$sql$Driver = ESDatabase.class$("java.sql.Driver")) : class$java$sql$Driver).isAssignableFrom(driverClass)) {
                this.lastError = new EcmaScriptException("Class " + driverClass + " is not a JDBC driver");
            }
            driverClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            this.lastError = e;
        }
        catch (InstantiationException e) {
            this.lastError = e;
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        this.driverOK = true;
    }

    ESDatabase(ESObject prototype, Evaluator evaluator, ESObject esRowSetPrototype, String driverName, String pathName) {
        super(prototype, evaluator);
        this.driverName = driverName;
        this.esRowSetPrototype = esRowSetPrototype;
        try {
            this.driverLoader = LocalClassLoader.makeLocalClassLoader(pathName);
        }
        catch (EcmaScriptException e) {
            this.lastError = e;
            return;
        }
        try {
            Class<?> driverClass = this.driverLoader.loadClass(driverName);
            if (!(class$java$sql$Driver == null ? (class$java$sql$Driver = ESDatabase.class$("java.sql.Driver")) : class$java$sql$Driver).isAssignableFrom(driverClass)) {
                this.lastError = new EcmaScriptException("Class " + driverClass + " is not a JDBC driver");
                return;
            }
            driverClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            this.lastError = e;
        }
        catch (InstantiationException e) {
            this.lastError = e;
        }
        catch (IllegalAccessException e) {
            this.lastError = e;
        }
        this.driverOK = true;
    }

    ESDatabase(ESObject prototype, Evaluator evaluator) {
        super(prototype, evaluator);
        this.driverName = null;
        this.esRowSetPrototype = null;
        this.driverOK = false;
    }

    public String getESClassName() {
        return "Database";
    }

    public String toString() {
        if (this.driverName == null) {
            return "[database protoype]";
        }
        return "[Database: '" + this.driverName + (this.driverOK ? (this.connection == null ? "' - disconnected] " : " - connected]") : " - in error]");
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + this.getClass().getName() + ":" + this.toString() + "]";
    }

    ESValue getLastError() throws EcmaScriptException {
        if (this.lastError == null) {
            return ESNull.theNull;
        }
        return ESLoader.normalizeValue(this.lastError, this.evaluator);
    }

    ESValue connect(ESValue[] arguments) throws EcmaScriptException {
        if (!this.driverOK) {
            throw new EcmaScriptException("Driver not initialized properly - cannot connect");
        }
        this.lastError = null;
        String url = arguments.length > 0 ? arguments[0].toString() : null;
        String userName = arguments.length > 1 ? arguments[1].toString() : null;
        String password = arguments.length > 2 ? arguments[2].toString() : null;
        try {
            this.connection = userName == null ? DriverManager.getConnection(url) : DriverManager.getConnection(url, userName, password);
        }
        catch (Exception e) {
            this.lastError = e;
            return ESBoolean.makeBoolean(false);
        }
        return ESBoolean.makeBoolean(true);
    }

    ESValue disconnect() throws EcmaScriptException {
        if (!this.driverOK) {
            throw new EcmaScriptException("Driver not initialized properly - cannot disconnect");
        }
        this.lastError = null;
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
                this.lastError = null;
            }
            catch (SQLException e) {
                this.lastError = e;
                return ESBoolean.makeBoolean(false);
            }
        }
        return ESBoolean.makeBoolean(true);
    }

    ESValue release() {
        if (this.driverOK) {
            try {
                this.disconnect();
            }
            catch (EcmaScriptException ecmaScriptException) {
                // empty catch block
            }
        }
        return ESUndefined.theUndefined;
    }

    ESValue executeRetrieval(ESValue[] arguments) throws EcmaScriptException {
        String sql;
        String string = sql = arguments.length > 0 ? arguments[0].toString() : null;
        if (this.connection == null) {
            throw new EcmaScriptException("JDBC driver not connected");
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery(sql);
        }
        catch (SQLException e) {
            this.lastError = e;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            statement = null;
            return ESBoolean.makeBoolean(false);
        }
        ESRowSet rowSet = new ESRowSet(this.esRowSetPrototype, this.evaluator, sql, this, statement, resultSet);
        return rowSet;
    }

    ESValue executeCommand(ESValue[] arguments) throws EcmaScriptException {
        String sql = arguments.length > 0 ? arguments[0].toString() : null;
        int count = 0;
        if (this.connection == null) {
            throw new EcmaScriptException("JDBC driver not connected");
        }
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            count = statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.lastError = e;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            statement = null;
            return ESBoolean.makeBoolean(false);
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        return new ESNumber(count);
    }

    public Object getMetaData() {
        if (this.databaseMetaData == null) {
            try {
                this.databaseMetaData = this.connection.getMetaData();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.databaseMetaData;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

