/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESBoolean;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.ESWrapper;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.ESDatabase;
import FESI.Extensions.ESRowSet;
import FESI.Extensions.Extension;
import FESI.Interpreter.Evaluator;

public class Database
extends Extension {
    private transient Evaluator evaluator = null;
    private ESObject esDatabasePrototype = null;
    private ESObject esRowSetPrototype = null;

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.evaluator = evaluator;
        GlobalObject go = evaluator.getGlobalObject();
        ObjectPrototype op = (ObjectPrototype)evaluator.getObjectPrototype();
        FunctionPrototype fp = (FunctionPrototype)evaluator.getFunctionPrototype();
        this.esRowSetPrototype = new ObjectPrototype(op, evaluator);
        this.esDatabasePrototype = new ESDatabase(op, evaluator);
        GlobalObjectDatabase globalDatabaseObject = new GlobalObjectDatabase("Database", evaluator, fp);
        globalDatabaseObject.putHiddenProperty("prototype", this.esDatabasePrototype);
        globalDatabaseObject.putHiddenProperty("length", new ESNumber(2.0));
        this.esDatabasePrototype.putHiddenProperty("constructor", globalDatabaseObject);
        this.esDatabasePrototype.putHiddenProperty("getLastError", new DatabaseGetLastError("getLastError", evaluator, fp));
        this.esDatabasePrototype.putHiddenProperty("release", new DatabaseRelease("release", evaluator, fp));
        this.esDatabasePrototype.putHiddenProperty("connect", new DatabaseConnect("connect", evaluator, fp));
        this.esDatabasePrototype.putHiddenProperty("disconnect", new DatabaseDisconnect("disconnect", evaluator, fp));
        this.esDatabasePrototype.putHiddenProperty("executeRetrieval", new DatabaseExecuteRetrieval("executeRetrieval", evaluator, fp));
        this.esDatabasePrototype.putHiddenProperty("executeCommand", new DatabaseExecuteCommand("executeCommand", evaluator, fp));
        this.esDatabasePrototype.putHiddenProperty("getMetaData", new DatabaseGetMetaData("getMetaData", evaluator, fp));
        this.esRowSetPrototype.putHiddenProperty("release", new RowSetRelease("release", evaluator, fp));
        this.esRowSetPrototype.putHiddenProperty("next", new RowSetNext("next", evaluator, fp));
        this.esRowSetPrototype.putHiddenProperty("getColumnCount", new RowSetGetColumnCount("getColumnCount", evaluator, fp));
        this.esRowSetPrototype.putHiddenProperty("getColumnName", new RowSetGetColumnName("getColumnName", evaluator, fp));
        this.esRowSetPrototype.putHiddenProperty("getColumnItem", new RowSetGetColumnItem("getColumnItem", evaluator, fp));
        this.esRowSetPrototype.putHiddenProperty("getColumnDatatypeNumber", new RowSetGetColumnDatatypeNumber("getColumnDatatypeNumber", evaluator, fp));
        this.esRowSetPrototype.putHiddenProperty("getColumnDatatypeName", new RowSetGetColumnDatatypeName("getColumnDatatypeName", evaluator, fp));
        this.esRowSetPrototype.putHiddenProperty("hasMoreRows", new RowSetHasMoreRows("hasMoreRows", evaluator, fp));
        this.esRowSetPrototype.putHiddenProperty("getMetaData", new RowSetGetMetaData("getMetaData", evaluator, fp));
        go.putHiddenProperty("Database", globalDatabaseObject);
    }

    class RowSetGetMetaData
    extends BuiltinFunctionObject {
        RowSetGetMetaData(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESRowSet rowSet = (ESRowSet)thisObject;
            return new ESWrapper(rowSet.getMetaData(), this.evaluator);
        }
    }

    class RowSetHasMoreRows
    extends BuiltinFunctionObject {
        RowSetHasMoreRows(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESRowSet rowSet = (ESRowSet)thisObject;
            return ESBoolean.makeBoolean(rowSet.hasMoreRows());
        }
    }

    class RowSetGetColumnDatatypeName
    extends BuiltinFunctionObject {
        RowSetGetColumnDatatypeName(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESRowSet rowSet = (ESRowSet)thisObject;
            if (arguments.length < 1) {
                throw new EcmaScriptException("Missing parameter in function " + this);
            }
            int idx = arguments[0].toUInt32();
            String name = rowSet.getColumnDatatypeName(idx);
            if (name == null) {
                return ESUndefined.theUndefined;
            }
            return new ESString(name);
        }
    }

    class RowSetGetColumnDatatypeNumber
    extends BuiltinFunctionObject {
        RowSetGetColumnDatatypeNumber(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESRowSet rowSet = (ESRowSet)thisObject;
            if (arguments.length < 1) {
                throw new EcmaScriptException("Missing parameter in function " + this);
            }
            int idx = arguments[0].toUInt32();
            return new ESNumber(rowSet.getColumnDatatypeNumber(idx));
        }
    }

    class RowSetGetColumnItem
    extends BuiltinFunctionObject {
        RowSetGetColumnItem(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESRowSet rowSet = (ESRowSet)thisObject;
            if (arguments.length < 1) {
                throw new EcmaScriptException("Missing parameter in function " + this);
            }
            String name = arguments[0].toString();
            return rowSet.getColumnItem(name);
        }
    }

    class RowSetGetColumnName
    extends BuiltinFunctionObject {
        RowSetGetColumnName(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESRowSet rowSet = (ESRowSet)thisObject;
            if (arguments.length < 1) {
                throw new EcmaScriptException("Missing parameter in function " + this);
            }
            int idx = arguments[0].toUInt32();
            String name = rowSet.getColumnName(idx);
            if (name == null) {
                return ESUndefined.theUndefined;
            }
            return new ESString(name);
        }
    }

    class RowSetGetColumnCount
    extends BuiltinFunctionObject {
        RowSetGetColumnCount(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESRowSet rowSet = (ESRowSet)thisObject;
            return new ESNumber(rowSet.getColumnCount());
        }
    }

    class RowSetNext
    extends BuiltinFunctionObject {
        RowSetNext(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESRowSet rowSet = (ESRowSet)thisObject;
            return rowSet.next();
        }
    }

    class RowSetRelease
    extends BuiltinFunctionObject {
        RowSetRelease(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESRowSet rowSet = (ESRowSet)thisObject;
            return rowSet.release();
        }
    }

    class DatabaseGetMetaData
    extends BuiltinFunctionObject {
        DatabaseGetMetaData(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESDatabase database = (ESDatabase)thisObject;
            return new ESWrapper(database.getMetaData(), this.evaluator);
        }
    }

    class DatabaseExecuteCommand
    extends BuiltinFunctionObject {
        DatabaseExecuteCommand(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESDatabase database = (ESDatabase)thisObject;
            return database.executeCommand(arguments);
        }
    }

    class DatabaseExecuteRetrieval
    extends BuiltinFunctionObject {
        DatabaseExecuteRetrieval(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESDatabase database = (ESDatabase)thisObject;
            return database.executeRetrieval(arguments);
        }
    }

    class DatabaseDisconnect
    extends BuiltinFunctionObject {
        DatabaseDisconnect(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESDatabase database = (ESDatabase)thisObject;
            return database.disconnect();
        }
    }

    class DatabaseConnect
    extends BuiltinFunctionObject {
        DatabaseConnect(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESDatabase database = (ESDatabase)thisObject;
            return database.connect(arguments);
        }
    }

    class DatabaseRelease
    extends BuiltinFunctionObject {
        DatabaseRelease(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESDatabase database = (ESDatabase)thisObject;
            return database.release();
        }
    }

    class DatabaseGetLastError
    extends BuiltinFunctionObject {
        DatabaseGetLastError(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESDatabase database = (ESDatabase)thisObject;
            return database.getLastError();
        }
    }

    class GlobalObjectDatabase
    extends BuiltinFunctionObject {
        GlobalObjectDatabase(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            return this.doConstruct(thisObject, arguments);
        }

        public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESDatabase database = null;
            if (arguments.length == 0) {
                throw new EcmaScriptException("Database requires 1 or 2 arguments");
            }
            if (arguments.length == 1) {
                database = new ESDatabase(Database.this.esDatabasePrototype, this.evaluator, Database.this.esRowSetPrototype, arguments[0].toString());
            } else if (arguments.length > 1) {
                database = new ESDatabase(Database.this.esDatabasePrototype, this.evaluator, Database.this.esRowSetPrototype, arguments[0].toString(), arguments[1].toString());
            }
            return database;
        }
    }
}

