/*
 * Decompiled with CFR 0.152.
 */
package FESI.Exceptions;

import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.EvaluationSource;
import FESI.Parser.EcmaScriptConstants;
import FESI.Parser.ParseException;
import FESI.Parser.Token;

public class EcmaScriptParseException
extends EcmaScriptException
implements EcmaScriptConstants {
    private ParseException parseException;
    private EvaluationSource evaluationSource;
    private boolean canBeIncomplete = true;

    public EcmaScriptParseException(ParseException e, EvaluationSource s) {
        super("Parsing error");
        this.parseException = e;
        this.evaluationSource = s;
    }

    public int getLineNumber() {
        Token next = null;
        Token tok = this.parseException.currentToken;
        if (tok != null && tok.next != null) {
            next = tok.next;
        }
        if (next != null) {
            return next.beginLine;
        }
        return -1;
    }

    public boolean isIncomplete() {
        if (!this.canBeIncomplete) {
            return false;
        }
        Token tok = this.parseException.currentToken;
        if (tok != null && tok.next != null) {
            tok = tok.next;
        }
        return tok.kind == 0;
    }

    public void setNeverIncomplete() {
        this.canBeIncomplete = false;
    }

    public String getMessage() {
        String retval;
        Token tok = this.parseException.currentToken;
        Token next = null;
        if (tok != null && tok.kind == 53) {
            retval = "Unterminated string constant near line " + tok.beginLine + ", column " + tok.beginColumn;
        } else {
            if (tok != null && tok.next != null) {
                next = tok.next;
            }
            retval = next != null & this.isForFutureExtension(next.kind) ? "Keyword '" + next.image + "' reserved for future extension near line " + next.beginLine + ", column " + next.beginColumn : "Syntax error detected near line " + next.beginLine + ", column " + next.beginColumn;
            if (tok != null) {
                retval = retval + ", after " + this.parseException.tokenImage[tok.kind];
            }
        }
        retval = retval + eol + this.evaluationSource;
        return retval;
    }

    private boolean isForFutureExtension(int k) {
        return k == 27 || k == 28 || k == 29 || k == 30 || k == 31 || k == 32 || k == 33 || k == 34 || k == 35 || k == 36 || k == 37 || k == 38 || k == 39 || k == 40 || k == 41 || k == 42;
    }
}

