/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.NumberPrototype;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;

public class NumberObject
extends BuiltinFunctionObject {
    private NumberObject(ESObject prototype, Evaluator evaluator) {
        super(prototype, evaluator, "Number", 1);
    }

    public String toString() {
        return "<Number>";
    }

    public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        if (arguments.length == 0) {
            return new ESNumber(0.0);
        }
        return new ESNumber(arguments[0].doubleValue());
    }

    public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        NumberPrototype theObject = null;
        ESObject np = this.evaluator.getNumberPrototype();
        theObject = new NumberPrototype(np, this.evaluator);
        theObject.value = arguments.length > 0 ? new ESNumber(arguments[0].doubleValue()) : new ESNumber(0.0);
        return theObject;
    }

    public static NumberObject makeNumberObject(Evaluator evaluator, ObjectPrototype objectPrototype, FunctionPrototype functionPrototype) {
        NumberPrototype numberPrototype = new NumberPrototype(objectPrototype, evaluator);
        NumberObject numberObject = new NumberObject(functionPrototype, evaluator);
        try {
            numberObject.putHiddenProperty("prototype", numberPrototype);
            numberObject.putHiddenProperty("length", new ESNumber(1.0));
            numberObject.putHiddenProperty("MAX_VALUE", new ESNumber(Double.MAX_VALUE));
            numberObject.putHiddenProperty("MIN_VALUE", new ESNumber(Double.MIN_VALUE));
            numberObject.putHiddenProperty("NaN", new ESNumber(Double.NaN));
            numberObject.putHiddenProperty("NEGATIVE_INFINITY", new ESNumber(Double.NEGATIVE_INFINITY));
            numberObject.putHiddenProperty("POSITIVE_INFINITY", new ESNumber(Double.POSITIVE_INFINITY));
            numberPrototype.putHiddenProperty("constructor", numberObject);
            class NumberPrototypeToString
            extends BuiltinFunctionObject {
                NumberPrototypeToString(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    double d;
                    ESNumber v = ((NumberPrototype)thisObject).value;
                    String s = ((Object)v).toString();
                    if (arguments.length > 0 && !Double.isNaN(d = arguments[0].doubleValue())) {
                        s = Long.toString((long)((ESValue)v).doubleValue(), (int)d);
                    }
                    return new ESString(s);
                }
            }
            numberPrototype.putHiddenProperty("toString", new NumberPrototypeToString("toString", evaluator, functionPrototype));
            class NumberPrototypeValueOf
            extends BuiltinFunctionObject {
                NumberPrototypeValueOf(String name, Evaluator evaluator, FunctionPrototype fp) {
                    super(fp, evaluator, name, 1);
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    return ((NumberPrototype)thisObject).value;
                }
            }
            numberPrototype.putHiddenProperty("valueOf", new NumberPrototypeValueOf("valueOf", evaluator, functionPrototype));
        }
        catch (EcmaScriptException e) {
            e.printStackTrace();
            throw new ProgrammingError(e.getMessage());
        }
        evaluator.setNumberPrototype(numberPrototype);
        return numberObject;
    }
}

