/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESLoader;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.ESWrapper;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.JSGlobalWrapper;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.UserEvaluationSource;
import FESI.jslib.JSException;
import FESI.jslib.JSFunction;
import FESI.jslib.JSGlobalObject;
import FESI.jslib.JSObject;
import java.io.Reader;
import java.util.logging.Logger;

public class JSWrapper
implements JSObject {
    protected static final Logger log = Logger.getLogger("strawberry.script");
    protected Evaluator evaluator;
    protected ESObject object;

    public JSWrapper(ESObject object, Evaluator evaluator) {
        this.object = object;
        this.evaluator = evaluator;
    }

    public ESObject getESObject() {
        return this.object;
    }

    public JSGlobalObject getGlobalObject() {
        return new JSGlobalWrapper(this.evaluator.getGlobalObject(), this.evaluator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(String methodName, Object[] args) throws JSException {
        Object obj = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                ESValue function = this.object.getProperty(methodName, methodName.hashCode());
                ESValue[] esargs = null;
                if (args == null) {
                    esargs = new ESValue[]{};
                } else {
                    esargs = new ESValue[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        esargs[i] = ESLoader.normalizeValue(args[i], this.evaluator);
                    }
                }
                ESValue value = function.callFunction(this.object, esargs);
                obj = value.toJavaObject();
            }
            catch (EcmaScriptException e) {
                throw new JSException(e.getMessage(), e);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String s) throws JSException {
        log.info("eval --- \u5165\u308a\u307e\u3059");
        Object obj = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                log.info("111) evaluator = " + this.evaluator.getClass().getName());
                ESValue value = this.evaluator.evaluate(s, this.object, false);
                if (value != null) {
                    obj = value.toJavaObject();
                }
            }
            catch (EcmaScriptException e) {
                throw new JSException(e.getMessage(), e);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(Reader r, String d) throws JSException {
        Object obj = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                UserEvaluationSource ses = d == null ? new UserEvaluationSource("<Anonymous stream>", null) : new UserEvaluationSource(d, null);
                ESValue value = this.evaluator.evaluate(r, this.object, ses, false);
                if (value != null) {
                    obj = value.toJavaObject();
                }
            }
            catch (EcmaScriptException e) {
                throw new JSException(e.getMessage(), e);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalAsFunction(Reader r, String d) throws JSException {
        Object obj = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                UserEvaluationSource ses = d == null ? new UserEvaluationSource("<Anonymous stream>", null) : new UserEvaluationSource(d, null);
                ESValue value = this.evaluator.evaluate(r, this.object, ses, true);
                if (value != null) {
                    obj = value.toJavaObject();
                }
            }
            catch (EcmaScriptException e) {
                throw new JSException(e.getMessage(), e);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalAsFunction(String s) throws JSException {
        Object obj = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                ESValue value = this.evaluator.evaluate(s, this.object, true);
                if (value != null) {
                    obj = value.toJavaObject();
                }
            }
            catch (EcmaScriptException e) {
                throw new JSException(e.getMessage(), e);
            }
        }
        return obj;
    }

    public Object evalAsFunction(Reader r, String d, String[] names, Object[] values) throws JSException {
        Object obj = null;
        throw new ProgrammingError("NOT IMPLEMENTED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalAsFunction(String body, String[] names, Object[] values) throws JSException {
        Object obj = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                int checkLength;
                int argLength = names == null ? 0 : names.length;
                int n = checkLength = values == null ? 0 : names.length;
                if (argLength != checkLength) {
                    throw new JSException("argument names and values arrays must have the same length, now: " + argLength + ", " + checkLength);
                }
                ESValue[] esArgs = new ESValue[argLength + 1];
                for (int i = 0; i < argLength; ++i) {
                    esArgs[i] = new ESString(names[i]);
                }
                esArgs[argLength] = new ESString(body);
                ESObject fo = this.evaluator.getFunctionObject();
                ESObject theFunction = fo.doConstruct(null, esArgs);
                esArgs = new ESValue[argLength];
                for (int i = 0; i < argLength; ++i) {
                    esArgs[i] = ESLoader.normalizeValue(values[i], this.evaluator);
                }
                ESValue value = theFunction.callFunction(this.object, esArgs);
                if (value != null) {
                    obj = value.toJavaObject();
                }
            }
            catch (EcmaScriptException e) {
                throw new JSException(e.getMessage(), e);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getMember(String name) throws JSException {
        Object obj = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                ESValue value = this.object.getProperty(name, name.hashCode());
                obj = value.toJavaObject();
            }
            catch (EcmaScriptException e) {
                throw new JSException(e.getMessage(), e);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSlot(int index) throws JSException {
        Object obj = null;
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                ESValue value = this.object.getProperty(index);
                obj = value.toJavaObject();
            }
            catch (EcmaScriptException e) {
                throw new JSException(e.getMessage(), e);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(String name) throws JSException {
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                this.object.deleteProperty(name, name.hashCode());
            }
            catch (EcmaScriptException e) {
                throw new JSException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMember(String name, Object value) throws JSException {
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                ESValue esvalue = ESLoader.normalizeValue(value, this.evaluator);
                this.object.putProperty(name, esvalue, name.hashCode());
            }
            catch (EcmaScriptException e) {
                throw new JSException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSlot(int index, Object value) throws JSException {
        Evaluator evaluator = this.evaluator;
        synchronized (evaluator) {
            try {
                ESValue esvalue = ESLoader.normalizeValue(value, this.evaluator);
                this.object.putProperty(index, esvalue);
            }
            catch (EcmaScriptException e) {
                throw new JSException(e.getMessage(), e);
            }
        }
    }

    public static JSGlobalObject makeEvaluator() throws JSException {
        Evaluator evaluator = new Evaluator();
        GlobalObject go = evaluator.getGlobalObject();
        return new JSGlobalWrapper(go, evaluator);
    }

    public static JSGlobalObject makeEvaluator(String[] extensions) throws JSException {
        Evaluator evaluator = new Evaluator();
        GlobalObject go = evaluator.getGlobalObject();
        try {
            if (extensions != null) {
                for (int i = 0; i < extensions.length; ++i) {
                    Object e = evaluator.addMandatoryExtension(extensions[i]);
                    if (e != null) continue;
                    throw new JSException("Could not load extension '" + extensions[i] + "'");
                }
            }
            return new JSGlobalWrapper(go, evaluator);
        }
        catch (EcmaScriptException e) {
            throw new JSException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ESObject wrapJSFunction(Evaluator evaluator, JSFunction jsf) {
        Evaluator evaluator2 = evaluator;
        synchronized (evaluator2) {
            JSFunction theFunction = jsf;
            class WrapedJSFunction
            extends BuiltinFunctionObject {
                private final /* synthetic */ JSFunction val$theFunction;

                WrapedJSFunction(String name, Evaluator evaluator, FunctionPrototype fp, JSFunction val$theFunction) {
                    super(fp, evaluator, name, 1);
                    this.val$theFunction = val$theFunction;
                }

                public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    ESValue value = ESUndefined.theUndefined;
                    Object[] jsArguments = new Object[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        jsArguments[i] = arguments[i] instanceof ESWrapper ? ((ESWrapper)arguments[i]).getJavaObject() : (arguments[i] instanceof ESObject ? new JSWrapper((ESObject)arguments[i], this.evaluator) : arguments[i].toJavaObject());
                    }
                    try {
                        Object result = this.val$theFunction.doCall(new JSWrapper(thisObject, this.evaluator), jsArguments);
                        value = ESLoader.normalizeValue(result, this.evaluator);
                    }
                    catch (JSException e) {
                        throw new EcmaScriptException(e.getMessage());
                    }
                    return value;
                }

                public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                    ESObject value = null;
                    Object[] jsArguments = new Object[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        jsArguments[i] = arguments[i] instanceof ESWrapper ? ((ESWrapper)arguments[i]).getJavaObject() : (arguments[i] instanceof ESObject ? new JSWrapper((ESObject)arguments[i], this.evaluator) : arguments[i].toJavaObject());
                    }
                    try {
                        Object result = this.val$theFunction.doNew(new JSWrapper(thisObject, this.evaluator), jsArguments);
                        value = ESLoader.normalizeObject(result, this.evaluator);
                    }
                    catch (JSException e) {
                        throw new EcmaScriptException(e.getMessage());
                    }
                    return value;
                }
            }
            return new WrapedJSFunction(jsf.toString(), evaluator, (FunctionPrototype)evaluator.getFunctionPrototype(), theFunction);
        }
    }

    public String toString() {
        return this.object.toString();
    }
}

