/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.AST.ASTFormalParameterList;
import FESI.AST.ASTStatementList;
import FESI.AST.EcmaScriptTreeConstants;
import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ConstructedFunctionObject;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.EcmaScriptParseException;
import FESI.Interpreter.EcmaScriptVariableVisitor;
import FESI.Interpreter.EvaluationSource;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.FunctionEvaluationSource;
import FESI.Interpreter.StringEvaluationSource;
import FESI.Parser.EcmaScript;
import FESI.Parser.ParseException;
import java.io.StringReader;
import java.util.Vector;

public class FunctionObject
extends BuiltinFunctionObject
implements EcmaScriptTreeConstants {
    static boolean debugParse = false;

    FunctionObject(ESObject prototype, Evaluator evaluator) {
        super(prototype, evaluator, "Function", 1);
    }

    public String getESClassName() {
        return "Function";
    }

    public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        return this.doConstruct(thisObject, arguments);
    }

    public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        EcmaScript parser;
        StringReader is;
        int i;
        ESObject fp = this.evaluator.getFunctionPrototype();
        ConstructedFunctionObject theFunction = null;
        ASTFormalParameterList fpl = null;
        ASTStatementList sl = null;
        StringBuffer parameters = new StringBuffer();
        int nArgs = arguments.length;
        for (i = 0; i < nArgs - 1; ++i) {
            if (i > 0) {
                parameters.append(",");
            }
            String arg = arguments[i].toString();
            parameters.append(arg);
        }
        String body = arguments[i].toString();
        String trimedParams = parameters.toString().trim();
        String fullFunctionText = "function anonymous (" + trimedParams + ") {" + body.toString() + "}";
        if (trimedParams.length() == 0) {
            fpl = new ASTFormalParameterList(33);
        } else {
            is = new StringReader(trimedParams);
            parser = new EcmaScript(is);
            try {
                fpl = (ASTFormalParameterList)parser.FormalParameterList();
                is.close();
            }
            catch (ParseException e) {
                if (debugParse) {
                    System.out.println("[[PARSING ERROR DETECTED: (debugParse true)]]");
                    System.out.println(e.getMessage());
                    System.out.println("[[BY ROUTINE:]]");
                    e.printStackTrace();
                    System.out.println();
                }
                throw new EcmaScriptParseException(e, new StringEvaluationSource(fullFunctionText, null));
            }
        }
        is = new StringReader(body.toString());
        parser = new EcmaScript(is);
        try {
            sl = (ASTStatementList)parser.StatementList();
            is.close();
        }
        catch (ParseException e) {
            if (debugParse) {
                System.out.println("[[PARSING ERROR DETECTED: (debugParse true)]]");
                System.out.println(e.getMessage());
                System.out.println("[[BY ROUTINE:]]");
                e.printStackTrace();
                System.out.println();
            }
            throw new EcmaScriptParseException(e, new StringEvaluationSource(fullFunctionText, null));
        }
        FunctionEvaluationSource fes = new FunctionEvaluationSource(new StringEvaluationSource(fullFunctionText, null), "<anonymous function>");
        EcmaScriptVariableVisitor varDeclarationVisitor = this.evaluator.getVarDeclarationVisitor();
        Vector variableNames = varDeclarationVisitor.processVariableDeclarations(sl, (EvaluationSource)fes);
        theFunction = ConstructedFunctionObject.makeNewConstructedFunction(this.evaluator, "anonymous", fes, fullFunctionText, fpl.getArguments(), variableNames, sl);
        return theFunction;
    }

    public String toString() {
        return "<Function>";
    }
}

