/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ArrayPrototype;
import FESI.Data.CompatibilityDescriptor;
import FESI.Data.ESLoader;
import FESI.Data.ESNull;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.ObjectObject;
import FESI.Data.ValueDescription;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.ClassInfo;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.EventAdaptor;
import FESI.Interpreter.ScopeChain;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

public class ESWrapper
extends ESObject {
    protected static final Logger log = Logger.getLogger("strawberry.script");
    static boolean debugEvent = false;
    private Object javaObject;
    private boolean asBean = false;
    private static ESObject noPropertyMarker = null;
    private Hashtable eventHandlers = null;
    private Hashtable eventAdaptors = null;
    static final int stepClass = 0;
    static final int stepConstructors = 1;
    static final int stepMethods = 2;
    static final int stepBeanMethods = 3;
    static final int stepFields = 4;
    static final int stepBeanProperties = 5;
    static final int stepEvents = 6;
    static final int stepNoMore = 7;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Object;

    public static void setDebugEvent(boolean b) {
        debugEvent = b;
    }

    public static boolean isDebugEvent() {
        return debugEvent;
    }

    public ESWrapper(Object javaObject, Evaluator evaluator) {
        super(null, evaluator);
        this.javaObject = javaObject;
        if (javaObject.getClass().isArray()) {
            throw new ProgrammingError("Object wrapper used on array object");
        }
        if (noPropertyMarker == null) {
            noPropertyMarker = new ObjectObject(null, evaluator);
        }
    }

    public ESWrapper(Object javaObject, Evaluator evaluator, boolean asBean) {
        super(null, evaluator);
        this.javaObject = javaObject;
        this.asBean = asBean;
        if (javaObject.getClass().isArray()) {
            throw new ProgrammingError("Object wrapper used on array object");
        }
        if (noPropertyMarker == null) {
            noPropertyMarker = new ObjectObject(null, evaluator);
        }
    }

    public Object getJavaObject() {
        return this.javaObject;
    }

    public boolean isBean() {
        return this.asBean;
    }

    public ESObject getPrototype() {
        throw new ProgrammingError("Cannot get prototype of Wrapper");
    }

    public String getESClassName() {
        return "Java Object";
    }

    public int getTypeOf() {
        return 6;
    }

    public ESValue getPropertyInScope(String propertyName, ScopeChain previousScope, int hash) throws EcmaScriptException {
        ESValue value;
        if (this.asBean) {
            value = this.getBeanProperty(propertyName, hash);
            if (value != noPropertyMarker) {
                return value;
            }
        } else {
            value = this.getObjectProperty(propertyName, hash);
            if (value == noPropertyMarker) {
                value = this.getBeanProperty(propertyName, hash);
            }
            if (value == noPropertyMarker) {
                value = this.getCorbaProperty(propertyName, hash);
            }
        }
        if (value == noPropertyMarker) {
            if (previousScope == null) {
                throw new EcmaScriptException("global variable '" + propertyName + "' does not have a value");
            }
            value = previousScope.getValue(propertyName, hash);
        }
        return value;
    }

    public ESValue getProperty(String propertyName, int hash) throws EcmaScriptException {
        ESValue value;
        if (this.asBean) {
            value = this.getBeanProperty(propertyName, hash);
            if (value == noPropertyMarker) {
                throw new EcmaScriptException("Property '" + propertyName + "' does not exists in bean " + this);
            }
        } else {
            value = this.getObjectProperty(propertyName, hash);
            if (value == noPropertyMarker) {
                value = this.getBeanProperty(propertyName, hash);
            }
            if (value == noPropertyMarker && this.javaObject instanceof Class) {
                String className = ((Class)this.javaObject).getName() + "$" + propertyName;
                if (ESLoader.debugJavaAccess) {
                    System.out.println("** Check if inside class: " + className);
                }
                Class<?> insideClass = null;
                try {
                    insideClass = Class.forName(className);
                }
                catch (ClassNotFoundException ex) {
                    throw new EcmaScriptException("Subclass, field or property '" + propertyName + "' does not exists in class " + this);
                }
                return new ESWrapper(insideClass, this.evaluator);
            }
            if (value == noPropertyMarker) {
                value = this.getCorbaProperty(propertyName, hash);
            }
            if (value == noPropertyMarker) {
                throw new EcmaScriptException("Field or property '" + propertyName + "' does not exists in object " + this);
            }
        }
        return value;
    }

    private ESValue getBeanProperty(String propertyName, int hash) throws EcmaScriptException {
        Class<?> propCls;
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Bean property searched: " + propertyName);
        }
        Class<?> cls = null;
        Object theObject = null;
        if (this.javaObject instanceof Class) {
            cls = (Class<?>)this.javaObject;
        } else {
            cls = this.javaObject.getClass();
            theObject = this.javaObject;
        }
        PropertyDescriptor descriptor = ClassInfo.lookupBeanField(propertyName, cls);
        if (descriptor == null) {
            return noPropertyMarker;
        }
        if (descriptor instanceof IndexedPropertyDescriptor && (propCls = descriptor.getPropertyType()) == null) {
            throw new EcmaScriptException("Bean property '" + propertyName + "' does not have an array access method");
        }
        Method readMethod = descriptor.getReadMethod();
        if (readMethod == null) {
            throw new EcmaScriptException("No read method for property " + propertyName);
        }
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Read method found for: " + propertyName);
        }
        Object obj = null;
        try {
            obj = readMethod.invoke(this.javaObject, (Object[])null);
        }
        catch (InvocationTargetException e) {
            throw new EcmaScriptException("Error int the getter for " + propertyName, e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new EcmaScriptException("Access error invoking getter for " + propertyName + ": " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ProgrammingError("Inconsistent type of argument for property " + propertyName + ": " + e.getMessage());
        }
        return ESLoader.normalizeValue(obj, this.evaluator);
    }

    private ESValue getCorbaProperty(String propertyName, int hash) throws EcmaScriptException {
        if (ESLoader.debugJavaAccess) {
            System.out.println("** CORBA property searched: " + propertyName);
        }
        Class<?> cls = this.javaObject.getClass();
        Method readMethod = null;
        try {
            readMethod = cls.getMethod(propertyName, null);
            if (readMethod == null) {
                return noPropertyMarker;
            }
            Class<?> rt = readMethod.getReturnType();
            if (rt == null || rt == Void.TYPE || readMethod.getParameterTypes().length != 0) {
                return noPropertyMarker;
            }
        }
        catch (NoSuchMethodException ignore) {
            return noPropertyMarker;
        }
        if (ESLoader.debugJavaAccess) {
            System.out.println("** CORBA read method found for: " + propertyName);
        }
        Object obj = null;
        try {
            obj = readMethod.invoke(this.javaObject, (Object[])null);
        }
        catch (InvocationTargetException e) {
            throw new EcmaScriptException("Error in the CORBA getter function for " + propertyName, e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new EcmaScriptException("Access error invoking CORBA getter for " + propertyName + ": " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new ProgrammingError("Inconsistent type of argument for property " + propertyName + ": " + e.getMessage());
        }
        return ESLoader.normalizeValue(obj, this.evaluator);
    }

    private ESValue getObjectProperty(String propertyName, int hash) throws EcmaScriptException {
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Java object field searched: " + propertyName);
        }
        try {
            Field fld;
            Class<?> cls = null;
            Object theObject = null;
            if (this.javaObject instanceof Class) {
                cls = (Class<?>)this.javaObject;
            } else {
                cls = this.javaObject.getClass();
                theObject = this.javaObject;
            }
            try {
                fld = theObject == null ? cls.getDeclaredField(propertyName) : cls.getField(propertyName);
            }
            catch (NoSuchFieldException e) {
                return noPropertyMarker;
            }
            int modifiers = fld.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                throw new EcmaScriptException("Field " + propertyName + " not public");
            }
            Object obj = fld.get(theObject);
            return ESLoader.normalizeValue(obj, this.evaluator);
        }
        catch (IllegalAccessException e) {
            throw new EcmaScriptException("Cannot access java field " + propertyName + " in " + this + ", error: " + e.toString());
        }
    }

    public boolean hasProperty(String propertyName, int hash) throws EcmaScriptException {
        try {
            this.getProperty(propertyName, hash);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isHiddenProperty(String propertyName, int hash) {
        return false;
    }

    public void putProperty(String propertyName, ESValue propertyValue, int hash) throws EcmaScriptException {
        if (propertyValue == ESUndefined.theUndefined) {
            throw new EcmaScriptException("Cannot set the field or property " + propertyName + " of a non EcmaScript object field to undefined");
        }
        if (this.asBean) {
            if (!this.putBeanProperty(propertyName, propertyValue, hash)) {
                throw new EcmaScriptException("Cannot put value in property '" + propertyName + "' which does not exists in Java Bean '" + this + "'");
            }
        } else {
            if (this.putObjectProperty(propertyName, propertyValue, hash)) {
                return;
            }
            if (this.putBeanProperty(propertyName, propertyValue, hash)) {
                return;
            }
            if (this.putCorbaProperty(propertyName, propertyValue, hash)) {
                return;
            }
            throw new EcmaScriptException("Cannot put value in field or property '" + propertyName + "' which does not exists in Java or Corba object '" + this + "'");
        }
    }

    private boolean putBeanProperty(String propertyName, ESValue propertyValue, int hash) throws EcmaScriptException {
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Bean property searched: " + propertyName);
        }
        if (propertyValue == ESUndefined.theUndefined) {
            throw new ProgrammingError("Cannot set bean property " + propertyName + " to undefined");
        }
        Class<?> cls = null;
        Object theObject = null;
        if (this.javaObject instanceof Class) {
            cls = (Class<?>)this.javaObject;
        } else {
            cls = this.javaObject.getClass();
            theObject = this.javaObject;
        }
        PropertyDescriptor descriptor = ClassInfo.lookupBeanField(propertyName, cls);
        if (descriptor == null) {
            if (theObject != null && propertyName.startsWith("on")) {
                this.putEventHandler(propertyName, propertyValue);
                return true;
            }
            return false;
        }
        Class<?> propClass = descriptor.getPropertyType();
        if (descriptor instanceof IndexedPropertyDescriptor && propClass == null) {
            throw new EcmaScriptException("Bean property '" + propertyName + "' does not have an array access method");
        }
        Method writeMethod = descriptor.getWriteMethod();
        if (writeMethod == null) {
            throw new EcmaScriptException("No write method for Java property '" + propertyName + "'");
        }
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Write method found for: " + propertyName);
        }
        Object[] params = new Object[1];
        if (propClass.isArray()) {
            if (!(propertyValue instanceof ArrayPrototype)) {
                throw new EcmaScriptException("Argument should be Array for property '" + propertyName + "'");
            }
            ArrayPrototype ao = (ArrayPrototype)propertyValue;
            params[0] = ao.toJavaArray(propClass.getComponentType());
        } else {
            params[0] = propertyValue.toJavaObject();
        }
        try {
            writeMethod.invoke(this.javaObject, params);
        }
        catch (InvocationTargetException e) {
            throw new EcmaScriptException("Error in the setter for " + propertyName, e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new EcmaScriptException("Access error invoking setter for " + propertyName + ": " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new EcmaScriptException("Type of argument not suitable for property " + propertyName + ": " + e.getMessage());
        }
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Property set: " + propertyName);
        }
        return true;
    }

    private boolean putCorbaProperty(String propertyName, ESValue propertyValue, int hash) throws EcmaScriptException {
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Corba property searched: " + propertyName);
        }
        if (propertyValue == ESUndefined.theUndefined) {
            throw new ProgrammingError("Cannot set non EcmaScript property " + propertyName + " to undefined");
        }
        Object[] params = new Object[]{propertyValue.toJavaObject()};
        Method writeMethod = null;
        try {
            writeMethod = this.lookupMethod(this.evaluator, propertyName, params, false);
            if (writeMethod == null) {
                return false;
            }
            Class<?> rt = writeMethod.getReturnType();
            if (rt != null && rt == (class$java$lang$Void == null ? (class$java$lang$Void = ESWrapper.class$("java.lang.Void")) : class$java$lang$Void)) {
                return false;
            }
        }
        catch (NoSuchMethodException ignore) {
            return false;
        }
        if (ESLoader.debugJavaAccess) {
            System.out.println("** CORBA write method found for: " + propertyName);
        }
        try {
            writeMethod.invoke(this.javaObject, params);
        }
        catch (InvocationTargetException e) {
            throw new EcmaScriptException("Error in the CORBA setter for " + propertyName, e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new EcmaScriptException("Access error invoking CORBA setter for " + propertyName + ": " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new EcmaScriptException("Type of argument not suitable for CORBA property " + propertyName + ": " + e.getMessage());
        }
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Property set: " + propertyName);
        }
        return true;
    }

    private boolean putObjectProperty(String propertyName, ESValue propertyValue, int hash) throws EcmaScriptException {
        Field fld;
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Object field searched: " + propertyName);
        }
        if (propertyValue == ESUndefined.theUndefined) {
            throw new ProgrammingError("Cannot set java object field " + propertyName + " to undefined");
        }
        Object theObject = null;
        Class<?> cls = null;
        if (this.javaObject instanceof Class) {
            cls = (Class<?>)this.javaObject;
        } else {
            cls = this.javaObject.getClass();
            theObject = this.javaObject;
        }
        try {
            fld = theObject == null ? cls.getDeclaredField(propertyName) : cls.getField(propertyName);
        }
        catch (NoSuchFieldException e) {
            if (theObject != null && propertyName.startsWith("on")) {
                this.putEventHandler(propertyName, propertyValue);
                return true;
            }
            return false;
        }
        int modifiers = fld.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            throw new EcmaScriptException("Field " + propertyName + " not public");
        }
        try {
            fld.set(theObject, propertyValue.toJavaObject());
        }
        catch (IllegalArgumentException e) {
            throw new EcmaScriptException("Field " + propertyName + " of " + this + " cannot be set with " + propertyValue + ", error: " + e.toString());
        }
        catch (IllegalAccessException e) {
            throw new EcmaScriptException("Access error setting field " + propertyName + " of " + this + ", error: " + e.toString());
        }
        return true;
    }

    public void putHiddenProperty(String propertyName, ESValue propertyValue) throws EcmaScriptException {
        throw new ProgrammingError("Cannot put hidden property in " + this);
    }

    public boolean deleteProperty(String propertyName, int hash) throws EcmaScriptException {
        return false;
    }

    public boolean isDirectEnumerator() {
        return true;
    }

    public Enumeration getProperties() {
        if (this.javaObject instanceof Enumeration) {
            return (Enumeration)this.javaObject;
        }
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                throw new NoSuchElementException();
            }
        };
    }

    public Enumeration getAllProperties() {
        return this.getProperties();
    }

    private EventAdaptor getEventAdaptor(Class listenerType) throws EcmaScriptException {
        EventAdaptor adaptor;
        if (this.eventAdaptors == null) {
            this.eventAdaptors = new Hashtable();
        }
        if ((adaptor = (EventAdaptor)this.eventAdaptors.get(listenerType)) == null) {
            if (debugEvent) {
                System.out.println("** Creating new adaptor for '" + listenerType.getName() + "'");
            }
            try {
                adaptor = EventAdaptor.getEventAdaptor(listenerType, this.javaObject, this);
            }
            catch (Exception e) {
                throw new EcmaScriptException("Cannot build adaptor for '" + listenerType.getName() + "', error: " + e);
            }
            this.eventAdaptors.put(listenerType, adaptor);
        }
        if (debugEvent) {
            System.out.println("** Adaptor found: " + adaptor);
        }
        return adaptor;
    }

    private void putEventHandler(String propertyName, ESValue handler) throws EcmaScriptException {
        BeanInfo bi;
        String eventName = propertyName.substring(2);
        if (debugEvent) {
            System.out.println("** Attempt to set event '" + propertyName + "'");
        }
        ESObject eventHandler = null;
        if (handler != ESNull.theNull) {
            if (handler instanceof FunctionPrototype) {
                eventHandler = (ESObject)handler;
            } else {
                ESValue body = handler.toESString();
                ESObject fo = this.evaluator.getFunctionObject();
                ESString event = new ESString("event");
                ESValue[] esArgs = new ESValue[]{event, body};
                try {
                    eventHandler = fo.doConstruct(null, esArgs);
                }
                catch (EcmaScriptException e) {
                    throw new EcmaScriptException("Error creating function anonymous(event){" + body + "}\n" + e);
                }
            }
        }
        Class<?> cls = this.javaObject.getClass();
        try {
            bi = Introspector.getBeanInfo(cls);
        }
        catch (IntrospectionException e) {
            throw new EcmaScriptException("BeanInfo not found for java class '" + cls + "', error: " + e.getMessage());
        }
        EventSetDescriptor[] eds = bi.getEventSetDescriptors();
        for (int i = 0; i < eds.length; ++i) {
            Method[] methods;
            EventSetDescriptor thisEvent = eds[i];
            String name = thisEvent.getName();
            if (name.equalsIgnoreCase(eventName)) {
                if (debugEvent) {
                    System.out.println("** Event '" + propertyName + "' found");
                }
                if ((methods = thisEvent.getListenerMethods()).length != 1) {
                    throw new EcmaScriptException("Only 1 listener supported, there are " + methods.length + " listeners for event '" + eventName + "'");
                }
                Class<?> listenerType = thisEvent.getListenerType();
                String key = listenerType.getName() + ":" + methods[0].getName();
                this.getEventAdaptor(listenerType);
                if (this.eventHandlers == null) {
                    this.eventHandlers = new Hashtable();
                }
                if (handler == ESNull.theNull) {
                    if (debugEvent) {
                        System.out.println(" ** Handler removed for key: " + key);
                    }
                    this.eventHandlers.remove(key);
                } else {
                    if (debugEvent) {
                        System.out.println(" ** Handler added for key: " + key);
                    }
                    this.eventHandlers.put(key, eventHandler);
                }
                return;
            }
            methods = thisEvent.getListenerMethods();
            for (int j = 0; j < methods.length; ++j) {
                Method thisMethod = methods[j];
                String methodName = thisMethod.getName();
                if (!methodName.equalsIgnoreCase(eventName)) continue;
                if (debugEvent) {
                    System.out.println("** Event method '" + propertyName + "' found");
                }
                Class<?> listenerType = thisEvent.getListenerType();
                String key = listenerType.getName() + ":" + thisMethod.getName();
                this.getEventAdaptor(listenerType);
                if (this.eventHandlers == null) {
                    this.eventHandlers = new Hashtable();
                }
                if (handler == ESNull.theNull) {
                    if (debugEvent) {
                        System.out.println(" ** Handler removed for key: " + key);
                    }
                    this.eventHandlers.remove(key);
                } else {
                    if (debugEvent) {
                        System.out.println(" ** Handler added for key: " + key);
                    }
                    this.eventHandlers.put(key, eventHandler);
                }
                return;
            }
        }
        throw new EcmaScriptException("Event '" + eventName + "' not found for java class " + cls);
    }

    public ESValue getDefaultValue(int hint) throws EcmaScriptException {
        if (hint == 5) {
            return new ESString(this.javaObject.toString());
        }
        throw new EcmaScriptException("No default value for " + this + " and hint " + hint);
    }

    public ESValue getDefaultValue() throws EcmaScriptException {
        return this.getDefaultValue(5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Method lookupMethod(Evaluator evaluator, String functionName, Object[] params, boolean staticMethod) throws EcmaScriptException, NoSuchMethodException {
        int nArgs = params.length;
        if (ESLoader.debugJavaAccess) {
            System.out.println("** " + (this.asBean ? "Bean" : "Class") + " method lookup: " + (staticMethod ? "static " : "") + functionName);
        }
        log.config("812) ** " + (this.asBean ? "Bean" : "Class") + " method lookup: " + (staticMethod ? "static " : "") + functionName);
        Class cls = null;
        Object theObject = null;
        if (staticMethod) {
            if (!(this.javaObject instanceof Class)) throw new ProgrammingError("Cannot lookup for static method if not class");
            cls = (Class)this.javaObject;
        } else {
            cls = this.javaObject.getClass();
            theObject = this.javaObject;
        }
        Method[] methods = null;
        if (this.asBean) {
            methods = ClassInfo.lookupBeanMethod(functionName, cls);
            log.config("832) " + methods);
        } else {
            methods = ClassInfo.lookupPublicMethod(functionName, cls);
            log.config("835) " + methods);
            if (methods != null) {
                log.config("836) " + methods.length);
            }
        }
        if (methods == null || methods.length == 0) {
            if (!staticMethod) throw new NoSuchMethodException("No method named '" + functionName + "' found in " + this);
            return null;
        }
        boolean atLeastOneFoundWithAttributes = false;
        Method nearestMethodFound = null;
        CompatibilityDescriptor descriptorOfNearestMethodFound = null;
        int distanceOfNearestMethodFound = -1;
        boolean multipleAtSameDistance = false;
        for (int i = 0; i < methods.length; ++i) {
            CompatibilityDescriptor cd;
            int distance;
            Method method = methods[i];
            if (ESLoader.debugJavaAccess) {
                System.out.println("** Method to validate: " + method.toString());
            }
            int modifiers = method.getModifiers();
            if (staticMethod && !Modifier.isStatic(modifiers)) continue;
            atLeastOneFoundWithAttributes = true;
            Class[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != nArgs || (distance = (cd = ESLoader.areParametersCompatible(paramTypes, params)).getDistance()) < 0) continue;
            if (ESLoader.debugJavaAccess) {
                System.out.println("** Method acceptable(" + distance + " : " + Modifier.toString(modifiers) + " " + methods[i].toString());
            }
            if (distance == 0 && !ESLoader.debugJavaAccess) {
                cd.convert(params);
                return method;
            }
            if (nearestMethodFound == null) {
                nearestMethodFound = method;
                descriptorOfNearestMethodFound = cd;
                distanceOfNearestMethodFound = distance;
                continue;
            }
            if (distance < distanceOfNearestMethodFound) {
                nearestMethodFound = method;
                descriptorOfNearestMethodFound = cd;
                distanceOfNearestMethodFound = distance;
                multipleAtSameDistance = false;
                continue;
            }
            if (distance != distanceOfNearestMethodFound) continue;
            if (ESLoader.debugJavaAccess) {
                System.out.println("** Same distance as previous method!");
            }
            if (distance == 0) continue;
            multipleAtSameDistance = true;
        }
        if (nearestMethodFound != null) {
            if (multipleAtSameDistance) {
                throw new EcmaScriptException("Ambiguous method '" + functionName + "' matching parameters in " + this);
            }
            descriptorOfNearestMethodFound.convert(params);
            return nearestMethodFound;
        }
        if (atLeastOneFoundWithAttributes) {
            throw new EcmaScriptException("No method '" + functionName + "' matching parameters in " + this);
        }
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Method rejected - did not match attribute or parameters");
        }
        if (!staticMethod) throw new EcmaScriptException("No method named '" + functionName + "' found in " + this);
        return null;
    }

    public ESValue doIndirectCall(Evaluator evaluator, ESObject target, String functionName, ESValue[] arguments) throws EcmaScriptException, NoSuchMethodException {
        Class<Object> retCls;
        int nArgs = arguments.length;
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Method searched: " + functionName + " in object of class " + this.javaObject.getClass());
        }
        log.config("** Method searched: " + functionName + " in object of class " + this.javaObject.getClass());
        Object[] params = new Object[nArgs];
        for (int k = 0; k < nArgs; ++k) {
            if (arguments[k] == ESUndefined.theUndefined) {
                throw new EcmaScriptException("Cannot use undefined as parameter for java method " + functionName + ", use 'null'");
            }
            params[k] = arguments[k].toJavaObject();
        }
        Method method = null;
        if (this.javaObject instanceof Class) {
            method = this.lookupMethod(evaluator, functionName, params, true);
        }
        log.config("926) method = " + method);
        if (method == null) {
            method = this.lookupMethod(evaluator, functionName, params, false);
        }
        Object obj = null;
        Class clazz = retCls = class$java$lang$Object == null ? (class$java$lang$Object = ESWrapper.class$("java.lang.Object")) : class$java$lang$Object;
        if (this.javaObject instanceof Map) {
            Map map = (Map)this.javaObject;
            if ("get".equals(functionName)) {
                log.config("950) params = " + params.length);
                obj = map.get(params[0]);
            } else if ("clear".equals(functionName)) {
                map.clear();
                retCls = Void.TYPE;
            } else {
                log.config("956) functionName = " + functionName);
            }
        } else {
            retCls = method.getReturnType();
            try {
                obj = method.invoke(this.javaObject, params);
            }
            catch (InvocationTargetException e) {
                throw new EcmaScriptException("Error in java method " + functionName, e.getTargetException());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new EcmaScriptException("Access error invoking java method " + functionName + ": " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new ProgrammingError("Inconsistent type of argument for method " + functionName + ": " + e.getMessage());
            }
        }
        ESValue eobj = retCls != Void.TYPE ? ESLoader.normalizeValue(obj, evaluator) : ESUndefined.theUndefined;
        return eobj;
    }

    public ESValue doIndirectCallInScope(Evaluator evaluator, ScopeChain previousScope, ESObject thisObject, String functionName, int hash, ESValue[] arguments) throws EcmaScriptException {
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Method searched (indirect): " + functionName);
        }
        try {
            return this.doIndirectCall(evaluator, thisObject, functionName, arguments);
        }
        catch (NoSuchMethodException e) {
            if (previousScope == null) {
                throw new EcmaScriptException("no global function named '" + functionName + "'");
            }
            return previousScope.doIndirectCall(evaluator, thisObject, functionName, hash, arguments);
        }
    }

    public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        return this.constructOrCall(thisObject, arguments, true);
    }

    public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
        return this.constructOrCall(thisObject, arguments, false);
    }

    private ESObject constructOrCall(ESObject thisObject, ESValue[] arguments, boolean isCall) throws EcmaScriptException {
        if (ESLoader.debugJavaAccess) {
            System.out.println("** Constructor searched for: " + this.javaObject.toString());
        }
        if (this.javaObject instanceof Class) {
            int nArgs = arguments.length;
            try {
                Class cls = (Class)this.javaObject;
                Constructor<?>[] constructors = cls.getConstructors();
                Object[] params = new Object[nArgs];
                for (int k = 0; k < nArgs; ++k) {
                    if (arguments[k] == ESUndefined.theUndefined) {
                        throw new EcmaScriptException("Cannot use undefined as parameter for java constructor " + cls.toString());
                    }
                    params[k] = arguments[k].toJavaObject();
                }
                boolean atLeastOneFoundWithAttributes = false;
                Constructor<?> nearestConstructorFound = null;
                CompatibilityDescriptor descriptorOfNearestConstructorFound = null;
                int distanceOfNearestConstructorFound = -1;
                boolean multipleAtSameDistance = false;
                for (int i = 0; i < constructors.length; ++i) {
                    CompatibilityDescriptor cd;
                    int distance;
                    Constructor<?> constructor = constructors[i];
                    if (ESLoader.debugJavaAccess) {
                        System.out.println("** Contructor examined: " + constructor.toString());
                    }
                    Class[] paramTypes = constructor.getParameterTypes();
                    int modifiers = constructor.getModifiers();
                    if (!Modifier.isPublic(modifiers)) continue;
                    atLeastOneFoundWithAttributes = true;
                    if (paramTypes.length != nArgs || (distance = (cd = ESLoader.areParametersCompatible(paramTypes, params)).getDistance()) < 0) continue;
                    if (ESLoader.debugJavaAccess) {
                        System.out.println("** Constructor acceptable(" + distance + " : " + Modifier.toString(modifiers) + " " + constructors[i].toString());
                    }
                    if (distance == 0 && !ESLoader.debugJavaAccess) {
                        nearestConstructorFound = constructor;
                        descriptorOfNearestConstructorFound = cd;
                        distanceOfNearestConstructorFound = distance;
                        break;
                    }
                    if (nearestConstructorFound == null) {
                        nearestConstructorFound = constructor;
                        descriptorOfNearestConstructorFound = cd;
                        distanceOfNearestConstructorFound = distance;
                        continue;
                    }
                    if (distance < distanceOfNearestConstructorFound) {
                        nearestConstructorFound = constructor;
                        descriptorOfNearestConstructorFound = cd;
                        distanceOfNearestConstructorFound = distance;
                        multipleAtSameDistance = false;
                        continue;
                    }
                    if (distance != distanceOfNearestConstructorFound) continue;
                    if (ESLoader.debugJavaAccess) {
                        System.out.println("** Same distance as previous constructor!");
                    }
                    if (distance == 0) continue;
                    multipleAtSameDistance = true;
                }
                if (nearestConstructorFound != null) {
                    if (multipleAtSameDistance) {
                        throw new EcmaScriptException("Ambiguous constructor for " + this.javaObject.toString());
                    }
                    descriptorOfNearestConstructorFound.convert(params);
                    if (ESLoader.debugJavaAccess) {
                        System.out.println("** Contructor called: " + nearestConstructorFound.toString());
                    }
                    Object obj = null;
                    try {
                        obj = nearestConstructorFound.newInstance(params);
                    }
                    catch (InvocationTargetException e) {
                        throw new EcmaScriptException("Error creating " + this.javaObject + ": " + e.getTargetException());
                    }
                    if (ESLoader.isBasicClass(cls) && !isCall) {
                        return new ESWrapper((Object)obj, this.evaluator);
                    }
                    return ESLoader.normalizeObject(obj, this.evaluator);
                }
                if (atLeastOneFoundWithAttributes) {
                    throw new EcmaScriptException("No constructor matching parameters in: " + this);
                }
                throw new EcmaScriptException("No public constructor in: " + this);
            }
            catch (Exception e) {
                throw new EcmaScriptException("Cannot build new " + this + ", error: " + e.toString());
            }
        }
        throw new EcmaScriptException("Not a java class: " + this);
    }

    public double doubleValue() {
        double d = Double.NaN;
        return d;
    }

    public boolean booleanValue() {
        return true;
    }

    public String toString() {
        return this.javaObject == null ? "<?Wrapper to null?>" : this.javaObject.toString();
    }

    public Object toJavaObject() {
        return this.javaObject;
    }

    public void dispatchEvent(Object[] a, Class listener, Method event) {
        ESObject handlerFunction;
        if (debugEvent) {
            System.out.println(" ** Dispatch event: " + event.getName() + " for " + listener.getName());
        }
        if (this.eventHandlers == null) {
            return;
        }
        String key = listener.getName() + ":" + event.getName();
        if (debugEvent) {
            System.out.println(" ** Event key: " + key);
        }
        if ((handlerFunction = (ESObject)this.eventHandlers.get(key)) == null) {
            return;
        }
        if (debugEvent) {
            System.out.println(" ** Handler found: " + handlerFunction);
        }
        try {
            this.evaluator.evaluateEvent(this, handlerFunction, a);
        }
        catch (EcmaScriptException e) {
            System.err.println("Exception in FESI event handler: " + e);
        }
    }

    public String toDetailString() {
        if (this.asBean) {
            return "ES:[BEAN:" + this.getESClassName() + ":" + this.javaObject.toString() + "]";
        }
        return "ES:[OBJ:" + this.getESClassName() + ":" + this.javaObject.toString() + "]";
    }

    private EventSetDescriptor[] getEvents(Class cls) {
        EventSetDescriptor[] eds = null;
        BeanInfo bi = null;
        try {
            bi = Introspector.getBeanInfo(cls);
        }
        catch (IntrospectionException e) {
            // empty catch block
        }
        if (bi != null) {
            eds = bi.getEventSetDescriptors();
        }
        if (eds == null) {
            eds = new EventSetDescriptor[]{};
        }
        return eds;
    }

    public Enumeration getAllDescriptions() {
        return new Enumeration(){
            Class clazz;
            int step;
            Constructor[] constructors;
            Method[] methods;
            Field[] fields;
            PropertyDescriptor[] beanProperties;
            MethodDescriptor[] beanMethods;
            EventSetDescriptor[] events;
            int index;
            {
                this.clazz = ESWrapper.this.javaObject.getClass();
                this.step = 0;
                this.constructors = this.clazz.getConstructors();
                this.methods = ESWrapper.this.asBean ? new Method[]{} : this.clazz.getMethods();
                this.fields = ESWrapper.this.asBean ? new Field[]{} : this.clazz.getFields();
                this.beanProperties = this.getBeanPropertyDescriptors();
                this.beanMethods = this.getBeanMethodDescriptors();
                this.events = ESWrapper.this.getEvents(this.clazz);
                this.index = 0;
            }

            private PropertyDescriptor[] getBeanPropertyDescriptors() {
                PropertyDescriptor[] bean_properties = new PropertyDescriptor[]{};
                if (ESWrapper.this.asBean) {
                    try {
                        BeanInfo beanInfo = Introspector.getBeanInfo(this.clazz);
                        bean_properties = beanInfo.getPropertyDescriptors();
                    }
                    catch (Exception e) {}
                } else {
                    PropertyDescriptor[] properties = null;
                    try {
                        BeanInfo beanInfo = Introspector.getBeanInfo(this.clazz);
                        properties = beanInfo.getPropertyDescriptors();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (properties != null) {
                        Field[] fields = this.clazz.getFields();
                        int remainingProps = 0;
                        for (int iProps = 0; iProps < properties.length; ++iProps) {
                            String propName = properties[iProps].getName();
                            for (int iField = 0; iField < fields.length; ++iField) {
                                String fieldName = fields[iField].getName();
                                if (!propName.equals(fieldName)) continue;
                                properties[iProps] = null;
                                break;
                            }
                            if (properties[iProps] == null) continue;
                            ++remainingProps;
                        }
                        if (remainingProps > 0) {
                            bean_properties = new PropertyDescriptor[remainingProps];
                            int insert = 0;
                            for (int iProps = 0; iProps < properties.length; ++iProps) {
                                if (properties[iProps] == null) continue;
                                bean_properties[insert++] = properties[iProps];
                            }
                        }
                    }
                }
                return bean_properties;
            }

            private MethodDescriptor[] getBeanMethodDescriptors() {
                MethodDescriptor[] bean_methods = new MethodDescriptor[]{};
                if (ESWrapper.this.asBean) {
                    try {
                        BeanInfo beanInfo = Introspector.getBeanInfo(this.clazz);
                        bean_methods = beanInfo.getMethodDescriptors();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return bean_methods;
            }

            public boolean hasMoreElements() {
                if (this.step == 0) {
                    return true;
                }
                if (this.step == 1) {
                    if (this.constructors.length > this.index) {
                        return true;
                    }
                    ++this.step;
                    this.index = 0;
                }
                if (this.step == 2) {
                    if (this.methods.length > this.index) {
                        return true;
                    }
                    ++this.step;
                    this.index = 0;
                }
                if (this.step == 3) {
                    if (this.beanMethods.length > this.index) {
                        return true;
                    }
                    ++this.step;
                    this.index = 0;
                }
                if (this.step == 4) {
                    if (this.fields.length > this.index) {
                        return true;
                    }
                    ++this.step;
                    this.index = 0;
                }
                if (this.step == 5) {
                    if (this.beanProperties.length > this.index) {
                        return true;
                    }
                    ++this.step;
                    this.index = 0;
                }
                if (this.step == 6) {
                    if (this.events.length > this.index) {
                        return true;
                    }
                    ++this.step;
                    this.index = 0;
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    switch (this.step) {
                        case 0: {
                            ++this.step;
                            if (ESWrapper.this.asBean) {
                                return new ValueDescription("BEAN", ESWrapper.describe_class_or_interface(this.clazz));
                            }
                            return new ValueDescription("CLASS", ESWrapper.describe_class_or_interface(this.clazz));
                        }
                        case 1: {
                            if (ESWrapper.this.asBean) {
                                String info = "[[error]]";
                                ++this.index;
                                try {
                                    BeanInfo beanInfo = Introspector.getBeanInfo(this.clazz);
                                    BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
                                    info = beanDescriptor.getName() + " (" + beanDescriptor.getShortDescription() + ")";
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return new ValueDescription("BEANINFO", info);
                            }
                            return new ValueDescription("CONSTR", ESWrapper.describe_method_or_constructor(this.constructors[this.index++]));
                        }
                        case 2: {
                            return new ValueDescription("FUNC", ESWrapper.describe_method_or_constructor(this.methods[this.index++]));
                        }
                        case 3: {
                            return new ValueDescription("METHOD", ESWrapper.describe_bean_method(this.beanMethods[this.index++]));
                        }
                        case 4: {
                            return new ValueDescription("FIELD", ESWrapper.describe_field(this.fields[this.index++], ESWrapper.this.javaObject));
                        }
                        case 5: {
                            return new ValueDescription("PROPS", ESWrapper.describe_bean_property(this.beanProperties[this.index++], ESWrapper.this.javaObject));
                        }
                        case 6: {
                            return new ValueDescription("EVENT", ESWrapper.describe_event(this.events[this.index++]));
                        }
                    }
                    throw new ProgrammingError("Inconsistent step");
                }
                throw new NoSuchElementException();
            }
        };
    }

    public ValueDescription getDescription(String name) {
        return new ValueDescription(name, "JAVAOBJ", this.toString());
    }

    private static String typename(Class t) {
        String brackets = "";
        while (t.isArray()) {
            brackets = brackets + "[]";
            t = t.getComponentType();
        }
        return t.getName() + brackets;
    }

    private static String modifiers(int m) {
        if (m == 0) {
            return "";
        }
        return Modifier.toString(m) + " ";
    }

    private static String describe_field(Field f, Object obj) {
        String s = ESWrapper.modifiers(f.getModifiers()) + ESWrapper.typename(f.getType()) + " " + f.getName();
        try {
            Object v = f.get(obj);
            s = s + " = " + obj.toString();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return s + ";";
    }

    private static String describe_bean_property(PropertyDescriptor d, Object obj) {
        String a = d instanceof IndexedPropertyDescriptor ? "[]" : "";
        String s = d.getName() + a + " (" + d.getShortDescription() + ")";
        Method readMethod = d.getReadMethod();
        if (readMethod != null) {
            try {
                Object v = readMethod.invoke(obj, (Object[])null);
                s = s + " = " + v.toString();
            }
            catch (InvocationTargetException ignore) {
            }
            catch (IllegalAccessException ignore) {
            }
            catch (IllegalArgumentException ignore) {
                // empty catch block
            }
        }
        return s + ";";
    }

    private static String describe_method_or_constructor(Member member) {
        int i;
        Class<?>[] exceptions;
        Class<?>[] parameters;
        Class<?> returntype = null;
        StringBuffer buffer = new StringBuffer();
        if (member instanceof Method) {
            Method m = (Method)member;
            returntype = m.getReturnType();
            parameters = m.getParameterTypes();
            exceptions = m.getExceptionTypes();
        } else {
            Constructor c = (Constructor)member;
            parameters = c.getParameterTypes();
            exceptions = c.getExceptionTypes();
        }
        buffer.append("" + ESWrapper.modifiers(member.getModifiers()) + (returntype != null ? ESWrapper.typename(returntype) + " " : "") + member.getName() + "(");
        for (i = 0; i < parameters.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(ESWrapper.typename(parameters[i]));
        }
        buffer.append(")");
        if (exceptions.length > 0) {
            buffer.append(" throws ");
        }
        for (i = 0; i < exceptions.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(ESWrapper.typename(exceptions[i]));
        }
        buffer.append(";");
        return buffer.toString();
    }

    private static String describe_bean_method(MethodDescriptor descriptor) {
        int i;
        Class<?> returntype = null;
        StringBuffer buffer = new StringBuffer();
        Method method = descriptor.getMethod();
        returntype = method.getReturnType();
        Class<?>[] parameters = method.getParameterTypes();
        Class<?>[] exceptions = method.getExceptionTypes();
        buffer.append(descriptor.getName() + ": " + ESWrapper.modifiers(method.getModifiers()) + (returntype != null ? ESWrapper.typename(returntype) + " " : "") + method.getName() + "(");
        for (i = 0; i < parameters.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(ESWrapper.typename(parameters[i]));
        }
        buffer.append(")");
        if (exceptions.length > 0) {
            buffer.append(" throws ");
        }
        for (i = 0; i < exceptions.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(ESWrapper.typename(exceptions[i]));
        }
        buffer.append(";");
        return buffer.toString();
    }

    private static String describe_class_or_interface(Class c) {
        StringBuffer buffer = new StringBuffer();
        if (c.isInterface()) {
            buffer.append(Modifier.toString(c.getModifiers()) + " " + c.getName());
        } else if (c.getSuperclass() != null) {
            buffer.append(Modifier.toString(c.getModifiers()) + " class " + c.getName() + " extends " + c.getSuperclass().getName());
        } else {
            buffer.append(Modifier.toString(c.getModifiers()) + " class " + c.getName());
        }
        Class<?>[] interfaces = c.getInterfaces();
        if (interfaces != null && interfaces.length > 0) {
            if (c.isInterface()) {
                buffer.append(" extends ");
            } else {
                buffer.append(" implements ");
            }
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(interfaces[i].getName());
            }
        }
        return buffer.toString();
    }

    private static String describe_event(EventSetDescriptor event) {
        Class<?> eventClass = event.getListenerType();
        return event.getName() + " " + eventClass.getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

