/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESObject;
import FESI.Data.ESPrimitive;
import FESI.Data.ESValue;
import FESI.Data.StringPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;

public final class ESString
extends ESPrimitive {
    private String string;

    public ESString(String value) {
        this.string = value;
    }

    public String toDetailString() {
        return "ES:\"" + this.string + "\"";
    }

    public int getTypeOf() {
        return 5;
    }

    public String getTypeofString() {
        return "string";
    }

    public String toString() {
        return this.string;
    }

    public int getStringLength() {
        return this.string.length();
    }

    public double doubleValue() {
        double value = Double.NaN;
        try {
            value = Double.valueOf(this.string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public boolean booleanValue() {
        return this.string.length() > 0;
    }

    public ESValue toESString() {
        return this;
    }

    public ESValue toESObject(Evaluator evaluator) throws EcmaScriptException {
        StringPrototype theObject = null;
        ESObject sp = evaluator.getStringPrototype();
        theObject = new StringPrototype(sp, evaluator);
        theObject.value = this;
        return theObject;
    }

    public Object toJavaObject() {
        return this.string;
    }

    public boolean isStringValue() {
        return true;
    }
}

